/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.interceptor;

import com.navercorp.pinpoint.bootstrap.context.AsyncContext;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.AbstractAsyncContextSpanEventEndPointInterceptor;
import com.navercorp.pinpoint.bootstrap.interceptor.ApiIdAwareAroundInterceptor;
import com.navercorp.pinpoint.bootstrap.util.ScopeUtils;

public abstract class AsyncContextSpanEventEndPointApiAwareInterceptor
extends AbstractAsyncContextSpanEventEndPointInterceptor
implements ApiIdAwareAroundInterceptor {
    public AsyncContextSpanEventEndPointApiAwareInterceptor(TraceContext traceContext) {
        super(traceContext);
    }

    @Override
    public void before(Object target, int apiId, Object[] args) {
        block6: {
            AsyncContext asyncContext;
            if (this.isDebug) {
                this.logger.beforeInterceptor(target, args);
            }
            if ((asyncContext = this.getAsyncContext(target, args)) == null) {
                return;
            }
            Trace trace = this.getAsyncTrace(asyncContext);
            if (trace == null) {
                return;
            }
            if (this.isDebug) {
                this.logger.debug("Asynchronous invocation. asyncContext={}, trace={}", (Object)asyncContext, (Object)trace);
            }
            ScopeUtils.entryAsyncTraceScope(trace);
            try {
                SpanEventRecorder recorder = trace.traceBlockBegin();
                this.beforeTrace(asyncContext, trace, recorder, target, apiId, args);
                this.doInBeforeTrace(recorder, target, apiId, args);
            }
            catch (Throwable th) {
                if (!this.logger.isWarnEnabled()) break block6;
                this.logger.warn("BEFORE. Caused:{}", (Object)th.getMessage(), (Object)th);
            }
        }
    }

    protected void beforeTrace(AsyncContext asyncContext, Trace trace, SpanEventRecorder recorder, Object target, int apiId, Object[] args) {
    }

    protected abstract void doInBeforeTrace(SpanEventRecorder var1, Object var2, int var3, Object[] var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void after(Object target, int apiId, Object[] args, Object result, Throwable throwable) {
        AsyncContext asyncContext;
        if (this.isDebug) {
            this.logger.afterInterceptor(target, args, result, throwable);
        }
        if ((asyncContext = this.getAsyncContext(target, args, result, throwable)) == null) {
            return;
        }
        Trace trace = asyncContext.currentAsyncTraceObject();
        if (trace == null) {
            return;
        }
        if (this.isDebug) {
            this.logger.debug("Asynchronous invocation. asyncContext={}, trace={}", (Object)asyncContext, (Object)trace);
        }
        if (!ScopeUtils.leaveAsyncTraceScope(trace)) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Failed to leave scope of async trace {}.", (Object)trace);
            }
            this.deleteAsyncTrace(trace);
            return;
        }
        try {
            SpanEventRecorder recorder = trace.currentSpanEventRecorder();
            this.afterTrace(asyncContext, trace, recorder, target, apiId, args, result, throwable);
            this.doInAfterTrace(recorder, target, apiId, args, result, throwable);
        }
        catch (Throwable th) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("AFTER error. Caused:{}", (Object)th.getMessage(), (Object)th);
            }
        }
        finally {
            trace.traceBlockEnd();
            if (ScopeUtils.isAsyncTraceEndScope(trace)) {
                this.deleteAsyncTrace(trace);
            }
            this.finishAsyncState(asyncContext);
        }
    }

    protected void afterTrace(AsyncContext asyncContext, Trace trace, SpanEventRecorder recorder, Object target, int apiId, Object[] args, Object result, Throwable throwable) {
    }

    protected abstract void doInAfterTrace(SpanEventRecorder var1, Object var2, int var3, Object[] var4, Object var5, Throwable var6);
}

