/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.storage.standalone.admin;

import io.cloudevents.CloudEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.eventmesh.api.admin.AbstractAdmin;
import org.apache.eventmesh.api.admin.TopicProperties;
import org.apache.eventmesh.storage.standalone.broker.Channel;
import org.apache.eventmesh.storage.standalone.broker.StandaloneBroker;
import org.apache.eventmesh.storage.standalone.broker.model.TopicMetadata;

public class StandaloneAdmin
extends AbstractAdmin {
    private final StandaloneBroker standaloneBroker = StandaloneBroker.getInstance();

    public StandaloneAdmin() {
        super(new AtomicBoolean(false));
    }

    public List<TopicProperties> getTopic() throws Exception {
        ConcurrentHashMap<TopicMetadata, Channel> messageContainer = this.standaloneBroker.getMessageContainer();
        ArrayList<TopicProperties> topicList = new ArrayList<TopicProperties>();
        ((ConcurrentHashMap.KeySetView)messageContainer.keySet()).forEach(topicMetadata -> {
            Channel channel = (Channel)messageContainer.get(topicMetadata);
            int messageCount = channel.getMessageCount();
            topicList.add(new TopicProperties(topicMetadata.getTopicName(), (long)messageCount));
        });
        topicList.sort(Comparator.comparing(t -> t.name));
        return topicList;
    }

    public void createTopic(String topicName) {
        this.standaloneBroker.createTopicIfAbsent(topicName);
    }

    public void deleteTopic(String topicName) {
        this.standaloneBroker.deleteTopicIfExist(topicName);
    }

    public void publish(CloudEvent cloudEvent) throws Exception {
        this.standaloneBroker.putMessage(cloudEvent.getSubject(), cloudEvent);
    }
}

