/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.protocol.cloudevents.resolver.http;

import io.cloudevents.CloudEvent;
import io.cloudevents.SpecVersion;
import io.cloudevents.core.builder.CloudEventBuilder;
import io.cloudevents.core.provider.EventFormatProvider;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.Constants;
import org.apache.eventmesh.common.protocol.http.body.Body;
import org.apache.eventmesh.common.protocol.http.body.message.SendMessageRequestBody;
import org.apache.eventmesh.common.protocol.http.common.ProtocolKey;
import org.apache.eventmesh.common.protocol.http.common.ProtocolVersion;
import org.apache.eventmesh.common.protocol.http.header.Header;
import org.apache.eventmesh.common.protocol.http.header.message.SendMessageRequestHeader;
import org.apache.eventmesh.protocol.api.exception.ProtocolHandleException;

public class SendMessageRequestProtocolResolver {
    public static CloudEvent buildEvent(Header header, Body body) throws ProtocolHandleException {
        try {
            SendMessageRequestHeader sendMessageRequestHeader = (SendMessageRequestHeader)header;
            SendMessageRequestBody sendMessageRequestBody = (SendMessageRequestBody)body;
            String protocolType = sendMessageRequestHeader.getProtocolType();
            String protocolDesc = sendMessageRequestHeader.getProtocolDesc();
            String protocolVersion = sendMessageRequestHeader.getProtocolVersion();
            String code = sendMessageRequestHeader.getCode();
            String env = sendMessageRequestHeader.getEnv();
            String idc = sendMessageRequestHeader.getIdc();
            String ip = sendMessageRequestHeader.getIp();
            String pid = sendMessageRequestHeader.getPid();
            String sys = sendMessageRequestHeader.getSys();
            String username = sendMessageRequestHeader.getUsername();
            String passwd = sendMessageRequestHeader.getPasswd();
            ProtocolVersion version = sendMessageRequestHeader.getVersion();
            String language = sendMessageRequestHeader.getLanguage();
            String producerGroup = sendMessageRequestBody.getProducerGroup();
            String content = sendMessageRequestBody.getContent();
            CloudEvent event = null;
            if (StringUtils.equalsAny((CharSequence)protocolVersion, (CharSequence[])new CharSequence[]{SpecVersion.V1.toString(), SpecVersion.V03.toString()})) {
                event = Objects.requireNonNull(EventFormatProvider.getInstance().resolveFormat("application/cloudevents+json")).deserialize(content.getBytes(Constants.DEFAULT_CHARSET));
                event = CloudEventBuilder.from((CloudEvent)event).withExtension("code", code).withExtension(ProtocolKey.ClientInstanceKey.ENV.getKey(), env).withExtension(ProtocolKey.ClientInstanceKey.IDC.getKey(), idc).withExtension(ProtocolKey.ClientInstanceKey.IP.getKey(), ip).withExtension(ProtocolKey.ClientInstanceKey.PID.getKey(), pid).withExtension(ProtocolKey.ClientInstanceKey.SYS.getKey(), sys).withExtension(ProtocolKey.ClientInstanceKey.USERNAME.getKey(), username).withExtension(ProtocolKey.ClientInstanceKey.PASSWD.getKey(), passwd).withExtension("version", version.getVersion()).withExtension("language", language).withExtension("protocoltype", protocolType).withExtension("protocoldesc", protocolDesc).withExtension("protocolversion", protocolVersion).withExtension("producergroup", producerGroup).build();
            }
            return event;
        }
        catch (Exception e) {
            throw new ProtocolHandleException(e.getMessage(), e.getCause());
        }
    }
}

