/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.components;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.component.html.HtmlCommandLink;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.InvalidOperationException;
import org.apache.empire.jsf2.app.FacesUtils;
import org.apache.empire.jsf2.components.TabPageTag;
import org.apache.empire.jsf2.controls.InputControlManager;
import org.apache.empire.jsf2.utils.StyleClass;
import org.apache.empire.jsf2.utils.TagEncodingHelper;
import org.apache.empire.jsf2.utils.TagEncodingHelperFactory;
import org.apache.empire.jsf2.utils.TagStyleClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabViewTag
extends UIOutput
implements TagEncodingHelperFactory.TagEncodingHolder {
    private static final Logger log = LoggerFactory.getLogger(TabViewTag.class);
    protected static String TAB_PAGE_ID = "pageId";
    protected static String TAB_ACTIVE_PAGE = "activePage";
    protected static String TAB_ACTIVE_INDEX = "activeIndex";
    protected static String TABLINK_ID_PREFIX = "tabLink";
    protected static String TAB_RENDERED_ATTRIBUTE = "visible";
    protected final TagEncodingHelper helper = TagEncodingHelperFactory.create(this, TagStyleClass.TAB_VIEW.get());
    private TabViewMode mode;

    public TabViewTag() {
        log.trace("TabViewTag created");
    }

    public String getFamily() {
        return "javax.faces.NamingContainer";
    }

    @Override
    public TagEncodingHelper getEncodingHelper() {
        return this.helper;
    }

    public TabViewMode getViewMode() {
        if (this.mode == null) {
            this.mode = TabViewMode.detect(this.helper.getTagAttributeString("mode", TabViewMode.TABLE.name()));
        }
        return this.mode;
    }

    public int getActivePageIndex() {
        Object active = this.helper.getTagAttributeValue(TAB_ACTIVE_INDEX);
        return ObjectUtils.getInteger((Object)active);
    }

    public void setActivePageIndex(int activeIndex) {
        ValueExpression ve = this.getValueExpression(TAB_ACTIVE_INDEX);
        if (ve != null) {
            FacesContext fc = FacesUtils.getContext();
            ve.setValue(fc.getELContext(), (Object)activeIndex);
        } else {
            this.getAttributes().put(TAB_ACTIVE_INDEX, activeIndex);
        }
    }

    public String getActivePageId() {
        Object active = this.helper.getTagAttributeValue(TAB_ACTIVE_PAGE);
        return ObjectUtils.getString((Object)active);
    }

    public void setActivePageId(String pageId) {
        ValueExpression ve = this.getValueExpression(TAB_ACTIVE_PAGE);
        if (ve != null) {
            FacesContext fc = FacesUtils.getContext();
            ve.setValue(fc.getELContext(), (Object)pageId);
        }
    }

    public TabPageTag getActiveTabPage() {
        Iterator ci = this.getFacetsAndChildren();
        if (!ci.hasNext()) {
            log.warn("Invalid TabPage definition!");
            return null;
        }
        UIComponent panel = (UIComponent)ci.next();
        int index = 0;
        int activeIndex = this.getActivePageIndex();
        String activePageId = this.getActivePageId();
        for (UIComponent c : panel.getChildren()) {
            boolean active;
            TabPageTag page;
            if (!(c instanceof TabPageTag) || !this.isPageVisible(page = (TabPageTag)c)) continue;
            boolean bl = activePageId != null ? activePageId.equals(page.getId()) : (active = index == activeIndex);
            if (active) {
                return page;
            }
            ++index;
        }
        if (activePageId != null) {
            log.warn("No visible tab-page with pageId {} has been found!", (Object)activePageId);
        } else {
            log.warn("No visible tab-page with index {} has been found!", (Object)activeIndex);
        }
        return null;
    }

    public void setActiveTab(ActionEvent event) {
        log.debug("setActiveTab");
        UIComponent comp = event.getComponent();
        String tabNo = comp.getId().substring(TABLINK_ID_PREFIX.length());
        int pageIndex = ObjectUtils.getInteger((Object)tabNo);
        if (pageIndex == this.getActivePageIndex()) {
            log.warn("setActiveTab is called for active page!");
            return;
        }
        this.setActivePageIndex(pageIndex);
        String pageId = (String)comp.getAttributes().get(TAB_PAGE_ID);
        this.setActivePageId(pageId);
        Object tcl = this.getAttributes().get("tabChangedListener");
        if (tcl != null) {
            if (!(tcl instanceof MethodExpression)) {
                throw new InvalidOperationException("tabChangedListener is not a valid method expression!");
            }
            FacesContext fc = FacesUtils.getContext();
            MethodExpression methodExpression = (MethodExpression)tcl;
            methodExpression.invoke(fc.getELContext(), new Object[]{pageIndex});
        }
    }

    public void encodeBegin(FacesContext context) throws IOException {
        super.encodeBegin(context);
        this.getViewMode();
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", (UIComponent)this);
        this.helper.writeComponentId(writer, true);
        this.helper.writeStyleClass(writer);
        String style = this.helper.getTagAttributeString("style");
        if (StringUtils.isNotEmpty((String)style)) {
            this.helper.writeAttribute(writer, "style", style);
        }
        String showTabBlindJs = null;
        if (ObjectUtils.getBoolean((Object)this.helper.getTagAttributeValue("showBlind"))) {
            String tabBlindClass = TagStyleClass.TAB_BLIND.get();
            writer.startElement("div", (UIComponent)this);
            writer.writeAttribute("class", (Object)tabBlindClass, null);
            writer.writeAttribute("style", (Object)"display:none", null);
            writer.endElement("div");
            String tabViewId = this.getClientId();
            showTabBlindJs = StringUtils.concat((String[])new String[]{"$(document.getElementById('", tabViewId, "')).find('.", tabBlindClass, "').show();"});
        }
        if (ObjectUtils.getBoolean((Object)this.helper.getTagAttributeValue("hideTabBar"))) {
            this.encodeTabs(context, null, null);
        } else {
            writer.startElement(this.mode.BAR_TAG, (UIComponent)this);
            writer.writeAttribute("class", (Object)TagStyleClass.TAB_BAR.get(), null);
            if (this.mode.BAR_ROW_TAG != null) {
                writer.startElement(this.mode.BAR_ROW_TAG, (UIComponent)this);
            }
            this.encodeTabs(context, writer, showTabBlindJs);
            if (this.mode.BAR_PAD_TAG != null) {
                writer.startElement(this.mode.BAR_PAD_TAG, (UIComponent)this);
                writer.writeAttribute("class", (Object)TagStyleClass.TAB_BAR_PADDING.get(), null);
                this.encodeTabPadding(context, writer);
                writer.endElement(this.mode.BAR_PAD_TAG);
            } else {
                this.encodeTabPadding(context, writer);
            }
            if (this.mode.BAR_ROW_TAG != null) {
                writer.endElement(this.mode.BAR_ROW_TAG);
            }
            writer.endElement(this.mode.BAR_TAG);
        }
        writer.startElement(this.mode.PANEL_TAG, (UIComponent)this);
        writer.writeAttribute("class", (Object)TagStyleClass.TAB_PANEL.get(), null);
        String minHeight = this.helper.getTagAttributeString("minHeight");
        if (StringUtils.isNotEmpty((String)minHeight)) {
            writer.writeAttribute("style", (Object)("min-height:" + minHeight), null);
        }
    }

    public boolean getRendersChildren() {
        return super.getRendersChildren();
    }

    public void encodeChildren(FacesContext context) throws IOException {
        super.encodeChildren(context);
    }

    public void encodeEnd(FacesContext context) throws IOException {
        super.encodeEnd(context);
        ResponseWriter writer = context.getResponseWriter();
        writer.endElement(this.mode.PANEL_TAG);
        writer.endElement("div");
    }

    public void decode(FacesContext context) {
        for (UIComponent c : this.getChildren()) {
            c.decode(context);
        }
        super.decode(context);
    }

    public void processDecodes(FacesContext context) {
        this.setRenderTabs(context);
        super.processDecodes(context);
    }

    public void processValidators(FacesContext context) {
        this.setRenderTabs(context);
        super.processValidators(context);
    }

    public void processUpdates(FacesContext context) {
        this.setRenderTabs(context);
        super.processUpdates(context);
    }

    protected void encodeTabs(FacesContext context, ResponseWriter writer, String showTabBlindJs) throws IOException {
        Iterator ci = this.getFacetsAndChildren();
        if (!ci.hasNext()) {
            log.warn("Invalid TabPage definition!");
            return;
        }
        UIComponent panel = (UIComponent)ci.next();
        int index = 0;
        int activeIndex = this.getActivePageIndex();
        String activePageId = this.getActivePageId();
        List chk = panel.getChildren();
        for (int i = chk.size() - 1; i >= 0; --i) {
            if (!(chk.get(i) instanceof HtmlCommandLink)) continue;
            chk.remove(i);
        }
        for (UIComponent c : panel.getChildren()) {
            boolean active;
            if (!(c instanceof TabPageTag)) continue;
            TabPageTag page = (TabPageTag)c;
            boolean visible = this.isPageVisible(page);
            if (!visible) {
                page.setRendered(false);
                continue;
            }
            boolean bl = activePageId != null ? activePageId.equals(page.getId()) : (active = index == activeIndex);
            if (active && index != activeIndex) {
                this.setActivePageIndex(index);
            }
            if (writer != null) {
                boolean disabled = this.isPageDisabled(page);
                writer.startElement(this.mode.BAR_ITEM_TAG, (UIComponent)this);
                StyleClass styleClass = new StyleClass((Object)TagStyleClass.TAB_LABEL);
                if (active) {
                    styleClass.add((Object)TagStyleClass.TAB_ACTIVE);
                } else if (disabled) {
                    styleClass.add((Object)TagStyleClass.TAB_DISABLED);
                }
                writer.writeAttribute("class", (Object)styleClass, null);
                this.encodeTabLink(context, writer, index, page, active || disabled, showTabBlindJs);
                writer.endElement(this.mode.BAR_ITEM_TAG);
            }
            page.setRendered(active);
            ++index;
        }
    }

    protected void encodeTabLink(FacesContext context, ResponseWriter writer, int index, TabPageTag pageTag, boolean disabled, String showTabBlindJs) throws IOException {
        HtmlCommandLink link = null;
        List tabLinks = this.getChildren();
        if (tabLinks.size() > index) {
            UIComponent c = (UIComponent)tabLinks.get(index);
            if (c instanceof HtmlCommandLink) {
                link = (HtmlCommandLink)c;
            } else {
                log.error("INFO: Unexpected child node for {}! Child item type is {}.", (Object)this.getClass().getName(), (Object)c.getClass().getName());
                c.setRendered(true);
                c.encodeAll(context);
                c.setRendered(false);
                return;
            }
        }
        if (link == null) {
            String linkId = TABLINK_ID_PREFIX + String.valueOf(index);
            link = this.createTabCommandLink(context, pageTag, linkId);
            tabLinks.add(index, link);
            String styleClass = StringUtils.coalesce((String)link.getStyleClass(), (String)TagStyleClass.TAB_LINK.get());
            String extraClass = pageTag.helper.getTagAttributeString("labelClass");
            if (StringUtils.isNotEmpty((String)extraClass)) {
                styleClass = StringUtils.concat((String[])new String[]{styleClass, " ", extraClass});
            }
            link.setStyleClass(styleClass);
            if (showTabBlindJs != null) {
                String onClick = link.getOnclick();
                onClick = StringUtils.concat((String[])new String[]{onClick, showTabBlindJs});
                link.setOnclick(onClick);
            }
            TabPageActionListener tpal = new TabPageActionListener(this);
            link.addActionListener((ActionListener)tpal);
        }
        link.getAttributes().put(TAB_PAGE_ID, pageTag.getId());
        link.setValue((Object)pageTag.getTabLabel());
        link.setTitle(pageTag.getTabTitle());
        link.setDisabled(disabled);
        link.setRendered(true);
        this.encodeTabCommandLink(context, pageTag, link);
        link.setRendered(false);
    }

    protected HtmlCommandLink createTabCommandLink(FacesContext context, TabPageTag pageTag, String linkId) {
        HtmlCommandLink link = InputControlManager.createComponent(context, HtmlCommandLink.class);
        link.setId(linkId);
        return link;
    }

    protected void encodeTabCommandLink(FacesContext context, TabPageTag pageTag, HtmlCommandLink link) throws IOException {
        UIComponent labelFacet = pageTag.getFacet("label");
        if (labelFacet != null) {
            link.encodeBegin(context);
            labelFacet.encodeAll(context);
            link.encodeEnd(context);
        } else {
            link.encodeAll(context);
        }
    }

    protected void encodeTabPadding(FacesContext context, ResponseWriter writer) throws IOException {
        UIComponent paddingFacet = this.getFacet("tabPadding");
        if (paddingFacet != null) {
            paddingFacet.encodeAll(context);
        }
    }

    protected void setRenderTabs(FacesContext context) {
        if (this.getFacetCount() < 1) {
            return;
        }
        UIComponent panel = (UIComponent)this.getFacets().values().iterator().next();
        int tabIndex = 0;
        int activeIndex = this.getActivePageIndex();
        for (UIComponent page : panel.getChildren()) {
            boolean rendered;
            if (!(page instanceof TabPageTag) || !this.isPageVisible((TabPageTag)page)) continue;
            boolean bl = rendered = tabIndex == activeIndex;
            if (page.isRendered() != rendered) {
                page.setRendered(rendered);
            }
            ++tabIndex;
        }
    }

    protected boolean isPageVisible(TabPageTag page) {
        return ObjectUtils.getBoolean(page.getAttributes().get(TAB_RENDERED_ATTRIBUTE), (boolean)true);
    }

    protected boolean isPageDisabled(TabPageTag page) {
        return ObjectUtils.getBoolean(page.getAttributes().get("disabled"), (boolean)false);
    }

    public static enum TabViewMode {
        TABLE("table", "tr", "td", "td", "table", "tr", "td"),
        GRID("div", null, "div", "div", "div", null, "div");

        public final String BAR_TAG;
        public final String BAR_ROW_TAG;
        public final String BAR_ITEM_TAG;
        public final String BAR_PAD_TAG;
        public final String PANEL_TAG;
        public final String PAGE_WRAP_TAG;
        public final String PAGE_TAG;

        private TabViewMode(String barTag, String barRowTag, String barItemTag, String barPadTag, String panelTag, String pageWrapTag, String pageTag) {
            this.BAR_TAG = barTag;
            this.BAR_ROW_TAG = barRowTag;
            this.BAR_ITEM_TAG = barItemTag;
            this.BAR_PAD_TAG = barPadTag;
            this.PANEL_TAG = panelTag;
            this.PAGE_WRAP_TAG = pageWrapTag;
            this.PAGE_TAG = pageTag;
        }

        public static TabViewMode detect(String mode) {
            if (mode == null || mode.length() == 0) {
                return TABLE;
            }
            TabViewMode[] values = TabViewMode.values();
            for (int i = 0; i < values.length; ++i) {
                if (!values[i].name().equalsIgnoreCase(mode)) continue;
                return values[i];
            }
            log.warn("TabViewMode \"{}\" not found. Using default!", (Object)mode);
            return TABLE;
        }

        public String toString() {
            return this.name();
        }
    }

    public static class TabPageActionListener
    implements ActionListener {
        public TabPageActionListener() {
        }

        public TabPageActionListener(TabViewTag tabViewTag) {
        }

        public void processAction(ActionEvent actionEvent) throws AbortProcessingException {
            UIComponent tabView = actionEvent.getComponent().getParent();
            if (!(tabView instanceof TabViewTag)) {
                throw new InvalidArgumentException("ActionEvent.component", tabView != null ? tabView.getClass().getName() : null);
            }
            TabViewTag tvt = (TabViewTag)tabView;
            tvt.setActiveTab(actionEvent);
        }
    }
}

