/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.rds.model.CreateTenantDatabaseRequest;
import com.amazonaws.services.rds.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateTenantDatabaseRequestMarshaller
implements Marshaller<Request<CreateTenantDatabaseRequest>, CreateTenantDatabaseRequest> {
    public Request<CreateTenantDatabaseRequest> marshall(CreateTenantDatabaseRequest createTenantDatabaseRequest) {
        if (createTenantDatabaseRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createTenantDatabaseRequest, "AmazonRDS");
        request.addParameter("Action", "CreateTenantDatabase");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (createTenantDatabaseRequest.getDBInstanceIdentifier() != null) {
            request.addParameter("DBInstanceIdentifier", StringUtils.fromString((String)createTenantDatabaseRequest.getDBInstanceIdentifier()));
        }
        if (createTenantDatabaseRequest.getTenantDBName() != null) {
            request.addParameter("TenantDBName", StringUtils.fromString((String)createTenantDatabaseRequest.getTenantDBName()));
        }
        if (createTenantDatabaseRequest.getMasterUsername() != null) {
            request.addParameter("MasterUsername", StringUtils.fromString((String)createTenantDatabaseRequest.getMasterUsername()));
        }
        if (createTenantDatabaseRequest.getMasterUserPassword() != null) {
            request.addParameter("MasterUserPassword", StringUtils.fromString((String)createTenantDatabaseRequest.getMasterUserPassword()));
        }
        if (createTenantDatabaseRequest.getCharacterSetName() != null) {
            request.addParameter("CharacterSetName", StringUtils.fromString((String)createTenantDatabaseRequest.getCharacterSetName()));
        }
        if (createTenantDatabaseRequest.getNcharCharacterSetName() != null) {
            request.addParameter("NcharCharacterSetName", StringUtils.fromString((String)createTenantDatabaseRequest.getNcharCharacterSetName()));
        }
        if (!createTenantDatabaseRequest.getTags().isEmpty() || !((SdkInternalList)createTenantDatabaseRequest.getTags()).isAutoConstruct()) {
            SdkInternalList tagsList = (SdkInternalList)createTenantDatabaseRequest.getTags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue != null) {
                    if (tagsListValue.getKey() != null) {
                        request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.getKey()));
                    }
                    if (tagsListValue.getValue() != null) {
                        request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.getValue()));
                    }
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

