/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.virtual;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.Parser;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.filter.ColumnIndexSelector;
import org.apache.druid.segment.ColumnSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.NilColumnValueSelector;
import org.apache.druid.segment.column.ColumnHolder;
import org.apache.druid.segment.column.ColumnIndexSupplier;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.SelectableColumn;
import org.apache.druid.segment.data.ReadableOffset;
import org.apache.druid.segment.nested.NestedColumnIndexSupplier;
import org.apache.druid.segment.nested.NestedColumnSelectorFactory;
import org.apache.druid.segment.nested.NestedColumnTypeInspector;
import org.apache.druid.segment.nested.NestedPathField;
import org.apache.druid.segment.nested.NestedPathPart;
import org.apache.druid.segment.nested.NestedVectorColumnSelectorFactory;
import org.apache.druid.segment.serde.NoIndexesColumnIndexSupplier;
import org.apache.druid.segment.vector.NilVectorSelector;
import org.apache.druid.segment.vector.ReadableVectorOffset;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;
import org.apache.druid.segment.vector.VectorObjectSelector;
import org.apache.druid.segment.vector.VectorValueSelector;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.apache.druid.segment.virtual.SpecializedExpressionVirtualColumn;

@JsonTypeName(value="nested-merge")
public class NestedMergeVirtualColumn
extends SpecializedExpressionVirtualColumn {
    private final List<String> columns;

    @JsonCreator
    public NestedMergeVirtualColumn(@JsonProperty(value="name") String name, @JsonProperty(value="columns") List<String> columns, @JacksonInject ExprMacroTable macroTable) {
        super(new ExpressionVirtualColumn(name, StringUtils.format("%s(%s)", "json_merge", columns.stream().map(column -> Parser.identifier(column).stringify()).collect(Collectors.joining(","))), ColumnType.NESTED_DATA, macroTable));
        this.columns = columns;
    }

    @JsonProperty
    public List<String> getColumns() {
        return this.columns;
    }

    @Override
    public SelectableColumn toSelectableColumn(final ColumnIndexSelector columnSelector) {
        return new SelectableColumn(){

            @Override
            public <T> T as(Class<T> clazz) {
                if (NestedColumnTypeInspector.class.equals(clazz) || NestedColumnSelectorFactory.class.equals(clazz) || NestedVectorColumnSelectorFactory.class.equals(clazz) || NestedColumnIndexSupplier.class.equals(clazz)) {
                    return (T)NestedMergeVirtualColumn.this.createNestedBundle(columnSelector);
                }
                return null;
            }
        };
    }

    public String toString() {
        return "NestedMergeVirtualColumn{name='" + this.getOutputName() + "', columns=" + String.valueOf(this.columns) + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NestedMergeVirtualColumn that = (NestedMergeVirtualColumn)o;
        return Objects.equals(this.columns, that.columns);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.columns);
    }

    @Nullable
    AsNestedColumn createNestedBundle(ColumnSelector columnSelector) {
        HashMap<String, SelectableColumn> keyToColumnMap = new HashMap<String, SelectableColumn>();
        ArrayList<SelectableColumn> selectableColumns = new ArrayList<SelectableColumn>();
        for (String column : this.columns) {
            ColumnHolder columnHolder = columnSelector.getColumnHolder(column);
            SelectableColumn selectableColumn = columnHolder.getColumn();
            NestedColumnTypeInspector typeInspector = selectableColumn.as(NestedColumnTypeInspector.class);
            if (typeInspector == null) {
                return null;
            }
            List<List<NestedPathPart>> fields = typeInspector.getNestedFields();
            for (List<NestedPathPart> field : fields) {
                if (field.isEmpty()) continue;
                if (field.get(0) instanceof NestedPathField) {
                    keyToColumnMap.put(field.get(0).getPartIdentifier(), selectableColumn);
                    continue;
                }
                return null;
            }
            selectableColumns.add(selectableColumn);
        }
        return new AsNestedColumn(columnSelector, selectableColumns, keyToColumnMap);
    }

    class AsNestedColumn
    implements NestedColumnTypeInspector,
    NestedVectorColumnSelectorFactory,
    NestedColumnSelectorFactory,
    NestedColumnIndexSupplier {
        private final ColumnSelector columnSelector;
        private final List<SelectableColumn> selectableColumns;
        private final Map<String, SelectableColumn> keyToColumnMap;

        public AsNestedColumn(ColumnSelector columnSelector, List<SelectableColumn> selectableColumns, Map<String, SelectableColumn> keyToColumnMap) {
            this.columnSelector = columnSelector;
            this.selectableColumns = selectableColumns;
            this.keyToColumnMap = keyToColumnMap;
        }

        @Override
        public List<List<NestedPathPart>> getNestedFields() {
            ArrayList<List<NestedPathPart>> retVal = new ArrayList<List<NestedPathPart>>();
            for (SelectableColumn column : this.selectableColumns) {
                NestedColumnTypeInspector typeInspector = column.as(NestedColumnTypeInspector.class);
                if (typeInspector == null) continue;
                List<List<NestedPathPart>> fields = typeInspector.getNestedFields();
                for (List<NestedPathPart> field : fields) {
                    if (field.isEmpty() || !(field.get(0) instanceof NestedPathField) || !this.keyToColumnMap.containsKey(field.get(0).getPartIdentifier())) continue;
                    retVal.add(field);
                }
            }
            return retVal;
        }

        @Override
        @Nullable
        public Set<ColumnType> getFieldTypes(List<NestedPathPart> path) {
            NestedColumnTypeInspector typeInspector;
            if (path.isEmpty()) {
                return Set.of(ColumnType.NESTED_DATA);
            }
            SelectableColumn column = this.getColumnForPath(path);
            if (column != null && (typeInspector = column.as(NestedColumnTypeInspector.class)) != null) {
                return typeInspector.getFieldTypes(path);
            }
            return Set.of();
        }

        @Override
        @Nullable
        public ColumnType getFieldLogicalType(List<NestedPathPart> path) {
            NestedColumnTypeInspector typeInspector;
            if (path.isEmpty()) {
                return ColumnType.NESTED_DATA;
            }
            SelectableColumn column = this.getColumnForPath(path);
            if (column != null && (typeInspector = column.as(NestedColumnTypeInspector.class)) != null) {
                return typeInspector.getFieldLogicalType(path);
            }
            return null;
        }

        @Override
        public boolean isNumeric(List<NestedPathPart> path) {
            NestedColumnTypeInspector typeInspector;
            if (path.isEmpty()) {
                return false;
            }
            SelectableColumn column = this.getColumnForPath(path);
            if (column != null && (typeInspector = column.as(NestedColumnTypeInspector.class)) != null) {
                return typeInspector.isNumeric(path);
            }
            return false;
        }

        @Override
        public DimensionSelector makeDimensionSelector(List<NestedPathPart> path, @Nullable ExtractionFn extractionFn, ColumnSelectorFactory columnSelectorFactory, @Nullable ReadableOffset readableOffset) {
            NestedColumnSelectorFactory factory;
            if (path.isEmpty()) {
                return NestedMergeVirtualColumn.this.makeDimensionSelector(DefaultDimensionSpec.of(NestedMergeVirtualColumn.this.getOutputName()), columnSelectorFactory, this.columnSelector, readableOffset);
            }
            SelectableColumn column = this.getColumnForPath(path);
            if (column != null && (factory = column.as(NestedColumnSelectorFactory.class)) != null) {
                return factory.makeDimensionSelector(path, extractionFn, columnSelectorFactory, readableOffset);
            }
            return DimensionSelector.constant(null, extractionFn);
        }

        @Override
        public ColumnValueSelector<?> makeColumnValueSelector(List<NestedPathPart> path, ColumnSelectorFactory columnSelectorFactory, @Nullable ReadableOffset readableOffset) {
            NestedColumnSelectorFactory factory;
            if (path.isEmpty()) {
                return NestedMergeVirtualColumn.this.makeColumnValueSelector(NestedMergeVirtualColumn.this.getOutputName(), columnSelectorFactory, this.columnSelector, readableOffset);
            }
            SelectableColumn column = this.getColumnForPath(path);
            if (column != null && (factory = column.as(NestedColumnSelectorFactory.class)) != null) {
                return factory.makeColumnValueSelector(path, columnSelectorFactory, readableOffset);
            }
            return NilColumnValueSelector.instance();
        }

        @Override
        public SingleValueDimensionVectorSelector makeSingleValueDimensionVectorSelector(List<NestedPathPart> path, VectorColumnSelectorFactory columnSelectorFactory, ReadableVectorOffset readableOffset) {
            NestedVectorColumnSelectorFactory factory;
            if (path.isEmpty()) {
                return NestedMergeVirtualColumn.this.makeSingleValueVectorDimensionSelector(DefaultDimensionSpec.of(NestedMergeVirtualColumn.this.getOutputName()), columnSelectorFactory, this.columnSelector, readableOffset);
            }
            SelectableColumn column = this.getColumnForPath(path);
            if (column != null && (factory = column.as(NestedVectorColumnSelectorFactory.class)) != null) {
                return factory.makeSingleValueDimensionVectorSelector(path, columnSelectorFactory, readableOffset);
            }
            return NilVectorSelector.create(readableOffset);
        }

        @Override
        public VectorObjectSelector makeVectorObjectSelector(List<NestedPathPart> path, VectorColumnSelectorFactory columnSelectorFactory, ReadableVectorOffset readableOffset) {
            NestedVectorColumnSelectorFactory factory;
            if (path.isEmpty()) {
                return NestedMergeVirtualColumn.this.makeVectorObjectSelector(NestedMergeVirtualColumn.this.getOutputName(), columnSelectorFactory, this.columnSelector, readableOffset);
            }
            SelectableColumn column = this.getColumnForPath(path);
            if (column != null && (factory = column.as(NestedVectorColumnSelectorFactory.class)) != null) {
                return factory.makeVectorObjectSelector(path, columnSelectorFactory, readableOffset);
            }
            return NilVectorSelector.create(readableOffset);
        }

        @Override
        public VectorValueSelector makeVectorValueSelector(List<NestedPathPart> path, VectorColumnSelectorFactory columnSelectorFactory, ReadableVectorOffset readableOffset) {
            NestedVectorColumnSelectorFactory factory;
            if (path.isEmpty()) {
                return NestedMergeVirtualColumn.this.makeVectorValueSelector(NestedMergeVirtualColumn.this.getOutputName(), columnSelectorFactory, this.columnSelector, readableOffset);
            }
            SelectableColumn column = this.getColumnForPath(path);
            if (column != null && (factory = column.as(NestedVectorColumnSelectorFactory.class)) != null) {
                return factory.makeVectorValueSelector(path, columnSelectorFactory, readableOffset);
            }
            return NilVectorSelector.create(readableOffset);
        }

        @Override
        @Nullable
        public ColumnIndexSupplier getColumnIndexSupplier(List<NestedPathPart> path) {
            if (path.isEmpty()) {
                return NoIndexesColumnIndexSupplier.getInstance();
            }
            SelectableColumn column = this.getColumnForPath(path);
            if (column != null) {
                NestedColumnIndexSupplier supplier = column.as(NestedColumnIndexSupplier.class);
                if (supplier != null) {
                    return supplier.getColumnIndexSupplier(path);
                }
                return NoIndexesColumnIndexSupplier.getInstance();
            }
            return null;
        }

        @Nullable
        private SelectableColumn getColumnForPath(List<NestedPathPart> path) {
            if (path.isEmpty()) {
                throw DruidException.defensive("Empty path should be handled by the caller, not here.", new Object[0]);
            }
            if (path.get(0) instanceof NestedPathField) {
                return this.keyToColumnMap.get(path.get(0).getPartIdentifier());
            }
            return null;
        }
    }
}

