/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter;

import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.filter.vector.BooleanVectorValueMatcher;
import org.apache.druid.query.filter.vector.VectorValueMatcher;
import org.apache.druid.segment.filter.ValueMatchers;
import org.apache.druid.segment.vector.VectorSizeInspector;

public enum ConstantMatcherType {
    ALL_TRUE{

        @Override
        public ValueMatcher asValueMatcher() {
            return ValueMatchers.allTrue();
        }

        @Override
        public VectorValueMatcher asVectorMatcher(VectorSizeInspector inspector) {
            return BooleanVectorValueMatcher.of(inspector, this);
        }
    }
    ,
    ALL_FALSE{

        @Override
        public ValueMatcher asValueMatcher() {
            return ValueMatchers.allFalse();
        }

        @Override
        public VectorValueMatcher asVectorMatcher(VectorSizeInspector inspector) {
            return BooleanVectorValueMatcher.of(inspector, this);
        }
    }
    ,
    ALL_UNKNOWN{

        @Override
        public ValueMatcher asValueMatcher() {
            return ValueMatchers.allUnknown();
        }

        @Override
        public VectorValueMatcher asVectorMatcher(VectorSizeInspector inspector) {
            return BooleanVectorValueMatcher.of(inspector, this);
        }
    };


    public abstract ValueMatcher asValueMatcher();

    public abstract VectorValueMatcher asVectorMatcher(VectorSizeInspector var1);
}

