/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.epinephelinae.vector;

import org.apache.datasketches.memory.WritableMemory;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.groupby.epinephelinae.collection.MemoryPointer;
import org.apache.druid.query.groupby.epinephelinae.vector.GroupByVectorColumnSelector;
import org.apache.druid.segment.vector.VectorValueSelector;

public class DoubleGroupByVectorColumnSelector
implements GroupByVectorColumnSelector {
    private final VectorValueSelector selector;

    DoubleGroupByVectorColumnSelector(VectorValueSelector selector) {
        this.selector = selector;
    }

    @Override
    public int getGroupingKeySize() {
        return 8;
    }

    @Override
    public int writeKeys(WritableMemory keySpace, int keySize, int keyOffset, int startRow, int endRow) {
        double[] vector = this.selector.getDoubleVector();
        if (keySize == 8) {
            keySpace.putDoubleArray((long)keyOffset, vector, startRow, endRow - startRow);
        } else {
            int i = startRow;
            int j = keyOffset;
            while (i < endRow) {
                keySpace.putDouble((long)j, vector[i]);
                ++i;
                j += keySize;
            }
        }
        return 0;
    }

    @Override
    public void writeKeyToResultRow(MemoryPointer keyMemory, int keyOffset, ResultRow resultRow, int resultRowPosition) {
        resultRow.set(resultRowPosition, keyMemory.memory().getDouble(keyMemory.position() + (long)keyOffset));
    }

    @Override
    public void reset() {
    }
}

