/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr.vector;

import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.vector.ExprEvalObjectVector;
import org.apache.druid.math.expr.vector.ExprEvalVector;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;
import org.apache.druid.math.expr.vector.IfFunctionVectorProcessor;

public class IfObjectVectorProcessor
extends IfFunctionVectorProcessor<Object[]> {
    private final Object[] output;

    public IfObjectVectorProcessor(ExpressionType outputType, ExprVectorProcessor<?> conditionProcessor, ExprVectorProcessor<Object[]> thenProcessor, ExprVectorProcessor<Object[]> elseProcessor) {
        super(outputType, conditionProcessor, thenProcessor, elseProcessor);
        this.output = new Object[conditionProcessor.maxVectorSize()];
    }

    @Override
    public ExprEvalVector<Object[]> evalVector(Expr.VectorInputBinding bindings) {
        this.thenBindingFilterer.setBindings(bindings);
        this.elseBindingFilterer.setBindings(bindings);
        ExprEvalVector conditionVector = this.conditionProcessor.evalVector(bindings);
        int[] thenSelection = this.thenBindingFilterer.getVectorMatch().getSelection();
        int[] elseSelection = this.elseBindingFilterer.getVectorMatch().getSelection();
        int thens = 0;
        int elses = 0;
        for (int i = 0; i < bindings.getCurrentVectorSize(); ++i) {
            if (conditionVector.elementAsBoolean(i)) {
                thenSelection[thens++] = i;
                continue;
            }
            elseSelection[elses++] = i;
        }
        this.thenBindingFilterer.getVectorMatch().setSelectionSize(thens);
        this.elseBindingFilterer.getVectorMatch().setSelectionSize(elses);
        if (elses == 0) {
            return this.thenProcessor.evalVector(bindings);
        }
        if (thens == 0) {
            return this.elseProcessor.evalVector(bindings);
        }
        ExprEvalVector thenVector = this.thenProcessor.evalVector(this.thenBindingFilterer);
        Object[] thenValues = thenVector.getObjectVector();
        for (int i = 0; i < thens; ++i) {
            int outIndex = thenSelection[i];
            this.output[outIndex] = thenValues[i];
        }
        ExprEvalVector elseVector = this.elseProcessor.evalVector(this.elseBindingFilterer);
        Object[] elseValues = elseVector.getObjectVector();
        for (int i = 0; i < elses; ++i) {
            int outIndex = elseSelection[i];
            this.output[outIndex] = elseValues[i];
        }
        return new ExprEvalObjectVector(this.output, this.outputType);
    }
}

