/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.inputsource.hdfs;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.StringUtils;

public class HdfsInputSourceConfig {
    static final Set<String> DEFAULT_ALLOWED_PROTOCOLS = ImmutableSet.of((Object)"hdfs");
    @JsonProperty
    private final Set<String> allowedProtocols;

    @JsonCreator
    public HdfsInputSourceConfig(@JsonProperty(value="allowedProtocols") @Nullable Set<String> allowedProtocols) {
        this.allowedProtocols = allowedProtocols == null || allowedProtocols.isEmpty() ? DEFAULT_ALLOWED_PROTOCOLS : allowedProtocols.stream().map(StringUtils::toLowerCase).collect(Collectors.toSet());
    }

    public Set<String> getAllowedProtocols() {
        return this.allowedProtocols;
    }
}

