/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.duty;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.client.DataSourcesSnapshot;
import org.apache.druid.client.indexing.ClientCompactionIOConfig;
import org.apache.druid.client.indexing.ClientCompactionIntervalSpec;
import org.apache.druid.client.indexing.ClientCompactionRunnerInfo;
import org.apache.druid.client.indexing.ClientCompactionTaskDimensionsSpec;
import org.apache.druid.client.indexing.ClientCompactionTaskGranularitySpec;
import org.apache.druid.client.indexing.ClientCompactionTaskQuery;
import org.apache.druid.client.indexing.ClientCompactionTaskQueryTuningConfig;
import org.apache.druid.client.indexing.ClientCompactionTaskTransformSpec;
import org.apache.druid.client.indexing.TaskPayloadResponse;
import org.apache.druid.common.guava.FutureUtils;
import org.apache.druid.common.utils.IdUtils;
import org.apache.druid.indexer.CompactionEngine;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexer.TaskStatusPlus;
import org.apache.druid.indexer.partitions.DimensionRangePartitionsSpec;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.granularity.GranularityType;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.metadata.LockFilterPolicy;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.rpc.indexing.OverlordClient;
import org.apache.druid.server.compaction.CompactionCandidate;
import org.apache.druid.server.compaction.CompactionCandidateSearchPolicy;
import org.apache.druid.server.compaction.CompactionSegmentIterator;
import org.apache.druid.server.compaction.CompactionStatusTracker;
import org.apache.druid.server.compaction.PriorityBasedCompactionSegmentIterator;
import org.apache.druid.server.coordinator.AutoCompactionSnapshot;
import org.apache.druid.server.coordinator.DataSourceCompactionConfig;
import org.apache.druid.server.coordinator.DruidCompactionConfig;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.duty.CoordinatorCustomDuty;
import org.apache.druid.server.coordinator.duty.CoordinatorDutyUtils;
import org.apache.druid.server.coordinator.stats.CoordinatorRunStats;
import org.apache.druid.server.coordinator.stats.Dimension;
import org.apache.druid.server.coordinator.stats.RowKey;
import org.apache.druid.server.coordinator.stats.Stats;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableInterval;

public class CompactSegments
implements CoordinatorCustomDuty {
    public static final String COMPACTION_TASK_TYPE = "compact";
    public static final String STORE_COMPACTION_STATE_KEY = "storeCompactionState";
    private static final String COMPACTION_REASON_KEY = "compactionReason";
    private static final Logger LOG = new Logger(CompactSegments.class);
    private static final String TASK_ID_PREFIX = "coordinator-issued";
    private static final Predicate<TaskStatusPlus> IS_COMPACTION_TASK = status -> null != status && COMPACTION_TASK_TYPE.equals(status.getType());
    private final CompactionStatusTracker statusTracker;
    private final OverlordClient overlordClient;
    private final AtomicReference<Map<String, AutoCompactionSnapshot>> autoCompactionSnapshotPerDataSource = new AtomicReference();

    @JsonCreator
    public CompactSegments(@JacksonInject CompactionStatusTracker statusTracker, @JacksonInject OverlordClient overlordClient) {
        this.overlordClient = overlordClient;
        this.statusTracker = statusTracker;
        this.resetCompactionSnapshot();
    }

    @VisibleForTesting
    public OverlordClient getOverlordClient() {
        return this.overlordClient;
    }

    @Override
    public DruidCoordinatorRuntimeParams run(DruidCoordinatorRuntimeParams params) {
        if (this.isCompactionSupervisorEnabled()) {
            LOG.warn("Skipping CompactSegments duty since compaction supervisors are already running on Overlord.", new Object[0]);
        } else {
            this.run(params.getCompactionConfig(), params.getDataSourcesSnapshot(), CompactionEngine.NATIVE, params.getCoordinatorStats());
        }
        return params;
    }

    public void run(DruidCompactionConfig dynamicConfig, DataSourcesSnapshot dataSources, CompactionEngine defaultEngine, CoordinatorRunStats stats) {
        int maxCompactionTaskSlots = dynamicConfig.getMaxCompactionTaskSlots();
        if (maxCompactionTaskSlots <= 0) {
            this.resetCompactionSnapshot();
            return;
        }
        this.statusTracker.onSegmentTimelineUpdated(dataSources.getSnapshotTime());
        this.statusTracker.onCompactionConfigUpdated(dynamicConfig);
        List<DataSourceCompactionConfig> compactionConfigList = dynamicConfig.getCompactionConfigs();
        if (compactionConfigList == null || compactionConfigList.isEmpty()) {
            this.resetCompactionSnapshot();
            return;
        }
        Map<String, DataSourceCompactionConfig> compactionConfigs = compactionConfigList.stream().collect(Collectors.toMap(DataSourceCompactionConfig::getDataSource, Function.identity()));
        HashMap<String, List<Interval>> intervalsToSkipCompaction = new HashMap<String, List<Interval>>();
        int busyCompactionTaskSlots = 0;
        List<TaskStatusPlus> compactionTasks = CoordinatorDutyUtils.getStatusOfActiveTasks(this.overlordClient, IS_COMPACTION_TASK);
        Set<String> activeTaskIds = compactionTasks.stream().map(TaskStatusPlus::getId).collect(Collectors.toSet());
        this.trackStatusOfCompletedTasks(activeTaskIds);
        for (TaskStatusPlus status : compactionTasks) {
            CompactionEngine compactionRunnerType;
            DataSourceCompactionConfig dataSourceCompactionConfig;
            TaskPayloadResponse response = (TaskPayloadResponse)FutureUtils.getUnchecked(this.overlordClient.taskPayload(status.getId()), (boolean)true);
            if (response == null) {
                throw new ISE("Could not find payload for active compaction task[%s]", new Object[]{status.getId()});
            }
            if (!COMPACTION_TASK_TYPE.equals(response.getPayload().getType())) {
                throw new ISE("Payload of active compaction task[%s] is of invalid type[%s]", new Object[]{status.getId(), response.getPayload().getType()});
            }
            ClientCompactionTaskQuery compactionTaskQuery = (ClientCompactionTaskQuery)response.getPayload();
            if (this.cancelTaskIfGranularityChanged(compactionTaskQuery, dataSourceCompactionConfig = compactionConfigs.get(status.getDataSource()))) continue;
            Interval interval = compactionTaskQuery.getIoConfig().getInputSpec().getInterval();
            intervalsToSkipCompaction.computeIfAbsent(status.getDataSource(), k -> new ArrayList()).add(interval);
            CompactionEngine compactionEngine = compactionRunnerType = compactionTaskQuery.getCompactionRunner() == null ? CompactionEngine.NATIVE : compactionTaskQuery.getCompactionRunner().getType();
            if (compactionRunnerType == CompactionEngine.NATIVE) {
                busyCompactionTaskSlots += CompactSegments.findMaxNumTaskSlotsUsedByOneNativeCompactionTask(compactionTaskQuery.getTuningConfig());
                continue;
            }
            busyCompactionTaskSlots += CompactSegments.findMaxNumTaskSlotsUsedByOneMsqCompactionTask(compactionTaskQuery.getContext());
        }
        this.getLockedIntervals(compactionConfigList).forEach((dataSource, intervals) -> intervalsToSkipCompaction.computeIfAbsent((String)dataSource, ds -> new ArrayList()).addAll(intervals));
        CompactionCandidateSearchPolicy policy = dynamicConfig.getCompactionPolicy();
        PriorityBasedCompactionSegmentIterator iterator = new PriorityBasedCompactionSegmentIterator(policy, compactionConfigs, dataSources.getUsedSegmentsTimelinesPerDataSource(), intervalsToSkipCompaction, this.statusTracker);
        int compactionTaskCapacity = this.getCompactionTaskCapacity(dynamicConfig);
        int availableCompactionTaskSlots = this.getAvailableCompactionTaskSlots(compactionTaskCapacity, busyCompactionTaskSlots);
        HashMap<String, AutoCompactionSnapshot.Builder> currentRunAutoCompactionSnapshotBuilders = new HashMap<String, AutoCompactionSnapshot.Builder>();
        int numSubmittedCompactionTasks = this.submitCompactionTasks(compactionConfigs, currentRunAutoCompactionSnapshotBuilders, availableCompactionTaskSlots, iterator, defaultEngine);
        stats.add(Stats.Compaction.MAX_SLOTS, compactionTaskCapacity);
        stats.add(Stats.Compaction.AVAILABLE_SLOTS, availableCompactionTaskSlots);
        stats.add(Stats.Compaction.SUBMITTED_TASKS, numSubmittedCompactionTasks);
        this.updateCompactionSnapshotStats(currentRunAutoCompactionSnapshotBuilders, iterator, stats);
    }

    private void resetCompactionSnapshot() {
        this.autoCompactionSnapshotPerDataSource.set(Collections.emptyMap());
    }

    private boolean isCompactionSupervisorEnabled() {
        try {
            return (Boolean)FutureUtils.getUnchecked(this.overlordClient.isCompactionSupervisorEnabled(), (boolean)true);
        }
        catch (Exception e) {
            return false;
        }
    }

    private void trackStatusOfCompletedTasks(Set<String> activeTaskIds) {
        HashSet<String> finishedTaskIds = new HashSet<String>(this.statusTracker.getSubmittedTaskIds());
        finishedTaskIds.removeAll(activeTaskIds);
        if (finishedTaskIds.isEmpty()) {
            return;
        }
        Map taskStatusMap = (Map)FutureUtils.getUnchecked(this.overlordClient.taskStatuses(finishedTaskIds), (boolean)true);
        for (String taskId : finishedTaskIds) {
            TaskStatus taskStatus = taskStatusMap.getOrDefault(taskId, TaskStatus.success((String)taskId));
            if (!taskStatus.isComplete()) continue;
            this.statusTracker.onTaskFinished(taskId, taskStatus);
        }
    }

    private boolean cancelTaskIfGranularityChanged(ClientCompactionTaskQuery compactionTaskQuery, DataSourceCompactionConfig dataSourceCompactionConfig) {
        if (dataSourceCompactionConfig == null || dataSourceCompactionConfig.getGranularitySpec() == null || compactionTaskQuery.getGranularitySpec() == null) {
            return false;
        }
        Granularity configuredSegmentGranularity = dataSourceCompactionConfig.getGranularitySpec().getSegmentGranularity();
        Granularity taskSegmentGranularity = compactionTaskQuery.getGranularitySpec().getSegmentGranularity();
        if (configuredSegmentGranularity == null || configuredSegmentGranularity.equals(taskSegmentGranularity)) {
            return false;
        }
        LOG.info("Cancelling task[%s] as task segmentGranularity[%s] differs from compaction config segmentGranularity[%s].", new Object[]{compactionTaskQuery.getId(), taskSegmentGranularity, configuredSegmentGranularity});
        this.overlordClient.cancelTask(compactionTaskQuery.getId());
        return true;
    }

    private Map<String, List<Interval>> getLockedIntervals(List<DataSourceCompactionConfig> compactionConfigs) {
        List<LockFilterPolicy> lockFilterPolicies = compactionConfigs.stream().map(config -> new LockFilterPolicy(config.getDataSource(), config.getTaskPriority(), null, config.getTaskContext())).collect(Collectors.toList());
        HashMap<String, List<Interval>> datasourceToLockedIntervals = new HashMap<String, List<Interval>>((Map)FutureUtils.getUnchecked(this.overlordClient.findLockedIntervals(lockFilterPolicies), (boolean)true));
        LOG.debug("Skipping the following intervals for Compaction as they are currently locked: %s", new Object[]{datasourceToLockedIntervals});
        return datasourceToLockedIntervals;
    }

    public static int findMaxNumTaskSlotsUsedByOneNativeCompactionTask(@Nullable ClientCompactionTaskQueryTuningConfig tuningConfig) {
        if (CompactSegments.isParallelMode(tuningConfig)) {
            Integer maxNumConcurrentSubTasks = tuningConfig.getMaxNumConcurrentSubTasks();
            return (maxNumConcurrentSubTasks == null ? 1 : maxNumConcurrentSubTasks) + 1;
        }
        return 1;
    }

    static int findMaxNumTaskSlotsUsedByOneMsqCompactionTask(@Nullable Map<String, Object> context) {
        return context == null ? 2 : (Integer)context.getOrDefault("maxNumTasks", 2);
    }

    @VisibleForTesting
    static boolean isParallelMode(@Nullable ClientCompactionTaskQueryTuningConfig tuningConfig) {
        if (null == tuningConfig) {
            return false;
        }
        boolean useRangePartitions = CompactSegments.useRangePartitions(tuningConfig);
        int minRequiredNumConcurrentSubTasks = useRangePartitions ? 1 : 2;
        return tuningConfig.getMaxNumConcurrentSubTasks() != null && tuningConfig.getMaxNumConcurrentSubTasks() >= minRequiredNumConcurrentSubTasks;
    }

    private static boolean useRangePartitions(ClientCompactionTaskQueryTuningConfig tuningConfig) {
        return tuningConfig.getPartitionsSpec() instanceof DimensionRangePartitionsSpec;
    }

    private int getCompactionTaskCapacity(DruidCompactionConfig dynamicConfig) {
        int totalWorkerCapacity = CoordinatorDutyUtils.getTotalWorkerCapacity(this.overlordClient);
        return Math.min((int)((double)totalWorkerCapacity * dynamicConfig.getCompactionTaskSlotRatio()), dynamicConfig.getMaxCompactionTaskSlots());
    }

    private int getAvailableCompactionTaskSlots(int compactionTaskCapacity, int busyCompactionTaskSlots) {
        int availableCompactionTaskSlots = busyCompactionTaskSlots > 0 ? Math.max(0, compactionTaskCapacity - busyCompactionTaskSlots) : Math.max(1, compactionTaskCapacity);
        LOG.debug("Found [%d] available task slots for compaction out of max compaction task capacity [%d]", new Object[]{availableCompactionTaskSlots, compactionTaskCapacity});
        return availableCompactionTaskSlots;
    }

    private int submitCompactionTasks(Map<String, DataSourceCompactionConfig> compactionConfigs, Map<String, AutoCompactionSnapshot.Builder> currentRunAutoCompactionSnapshotBuilders, int numAvailableCompactionTaskSlots, CompactionSegmentIterator iterator, CompactionEngine defaultEngine) {
        int slotsRequiredForCurrentTask;
        if (numAvailableCompactionTaskSlots <= 0) {
            return 0;
        }
        int numSubmittedTasks = 0;
        for (int totalTaskSlotsAssigned = 0; iterator.hasNext() && totalTaskSlotsAssigned < numAvailableCompactionTaskSlots; totalTaskSlotsAssigned += slotsRequiredForCurrentTask) {
            CompactionCandidate entry = (CompactionCandidate)iterator.next();
            String dataSourceName = entry.getDataSource();
            currentRunAutoCompactionSnapshotBuilders.computeIfAbsent(dataSourceName, AutoCompactionSnapshot::builder).incrementCompactedStats(entry.getStats());
            DataSourceCompactionConfig config = compactionConfigs.get(dataSourceName);
            List<DataSegment> segmentsToCompact = entry.getSegments();
            Granularity segmentGranularityToUse = null;
            if (config.getGranularitySpec() == null || config.getGranularitySpec().getSegmentGranularity() == null) {
                Interval interval = segmentsToCompact.get(0).getInterval();
                if (segmentsToCompact.stream().allMatch(segment -> interval.overlaps((ReadableInterval)segment.getInterval()))) {
                    try {
                        segmentGranularityToUse = GranularityType.fromPeriod((Period)interval.toPeriod()).getDefaultGranularity();
                    }
                    catch (IllegalArgumentException iae) {
                        LOG.warn("Cannot determine segmentGranularity from interval[%s].", new Object[]{interval});
                    }
                } else {
                    LOG.warn("Not setting 'segmentGranularity' for auto-compaction task as the segments to compact do not have the same interval.", new Object[0]);
                }
            } else {
                segmentGranularityToUse = config.getGranularitySpec().getSegmentGranularity();
            }
            ClientCompactionTaskGranularitySpec granularitySpec = new ClientCompactionTaskGranularitySpec(segmentGranularityToUse, config.getGranularitySpec() != null ? config.getGranularitySpec().getQueryGranularity() : null, config.getGranularitySpec() != null ? config.getGranularitySpec().isRollup() : null);
            ClientCompactionTaskDimensionsSpec dimensionsSpec = config.getDimensionsSpec() != null ? new ClientCompactionTaskDimensionsSpec(config.getDimensionsSpec().getDimensions()) : null;
            ClientCompactionTaskTransformSpec transformSpec = null;
            if (config.getTransformSpec() != null) {
                transformSpec = new ClientCompactionTaskTransformSpec(config.getTransformSpec().getFilter());
            }
            Boolean dropExisting = null;
            if (config.getIoConfig() != null) {
                dropExisting = config.getIoConfig().isDropExisting();
            }
            if ((dropExisting == null || !dropExisting.booleanValue()) && segmentsToCompact.stream().allMatch(DataSegment::isTombstone)) {
                dropExisting = true;
                LOG.info("Forcing dropExisting to true since all segments to compact are tombstones.", new Object[0]);
            }
            CompactionEngine compactionEngine = config.getEngine() == null ? defaultEngine : config.getEngine();
            Map<String, Object> autoCompactionContext = this.newAutoCompactionContext(config.getTaskContext());
            if (compactionEngine == CompactionEngine.MSQ) {
                if (autoCompactionContext.containsKey("maxNumTasks")) {
                    slotsRequiredForCurrentTask = (Integer)autoCompactionContext.get("maxNumTasks");
                } else {
                    slotsRequiredForCurrentTask = Math.min(numAvailableCompactionTaskSlots == 1 ? 2 : numAvailableCompactionTaskSlots, 5);
                    autoCompactionContext.put("maxNumTasks", slotsRequiredForCurrentTask);
                }
            } else {
                slotsRequiredForCurrentTask = CompactSegments.findMaxNumTaskSlotsUsedByOneNativeCompactionTask(config.getTuningConfig());
            }
            if (entry.getCurrentStatus() != null) {
                autoCompactionContext.put(COMPACTION_REASON_KEY, entry.getCurrentStatus().getReason());
            }
            String taskId = this.compactSegments(entry, config.getTaskPriority(), ClientCompactionTaskQueryTuningConfig.from(config.getTuningConfig(), config.getMaxRowsPerSegment(), config.getMetricsSpec() != null), granularitySpec, dimensionsSpec, config.getMetricsSpec(), transformSpec, dropExisting, autoCompactionContext, new ClientCompactionRunnerInfo(compactionEngine));
            LOG.debug("Submitted a compaction task[%s] for [%d] segments in datasource[%s], umbrella interval[%s].", new Object[]{taskId, segmentsToCompact.size(), dataSourceName, entry.getUmbrellaInterval()});
            LOG.debugSegments(segmentsToCompact, "Compacting segments");
            ++numSubmittedTasks;
        }
        LOG.info("Submitted a total of [%d] compaction tasks.", new Object[]{numSubmittedTasks});
        return numSubmittedTasks;
    }

    private Map<String, Object> newAutoCompactionContext(@Nullable Map<String, Object> configuredContext) {
        HashMap<String, Object> newContext = configuredContext == null ? new HashMap<String, Object>() : new HashMap<String, Object>(configuredContext);
        newContext.put(STORE_COMPACTION_STATE_KEY, true);
        return newContext;
    }

    private void updateCompactionSnapshotStats(Map<String, AutoCompactionSnapshot.Builder> currentRunAutoCompactionSnapshotBuilders, CompactionSegmentIterator iterator, CoordinatorRunStats stats) {
        while (iterator.hasNext()) {
            CompactionCandidate entry = (CompactionCandidate)iterator.next();
            currentRunAutoCompactionSnapshotBuilders.computeIfAbsent(entry.getDataSource(), AutoCompactionSnapshot::builder).incrementWaitingStats(entry.getStats());
        }
        iterator.getCompactedSegments().forEach(candidateSegments -> currentRunAutoCompactionSnapshotBuilders.computeIfAbsent(candidateSegments.getDataSource(), AutoCompactionSnapshot::builder).incrementCompactedStats(candidateSegments.getStats()));
        iterator.getSkippedSegments().forEach(candidateSegments -> currentRunAutoCompactionSnapshotBuilders.computeIfAbsent(candidateSegments.getDataSource(), AutoCompactionSnapshot::builder).incrementSkippedStats(candidateSegments.getStats()));
        HashMap currentAutoCompactionSnapshotPerDataSource = new HashMap();
        currentRunAutoCompactionSnapshotBuilders.forEach((dataSource, builder) -> {
            AutoCompactionSnapshot autoCompactionSnapshot = builder.build();
            currentAutoCompactionSnapshotPerDataSource.put(dataSource, autoCompactionSnapshot);
            this.collectSnapshotStats(autoCompactionSnapshot, stats);
        });
        this.autoCompactionSnapshotPerDataSource.set(currentAutoCompactionSnapshotPerDataSource);
    }

    private void collectSnapshotStats(AutoCompactionSnapshot autoCompactionSnapshot, CoordinatorRunStats stats) {
        RowKey rowKey = RowKey.of(Dimension.DATASOURCE, autoCompactionSnapshot.getDataSource());
        stats.add(Stats.Compaction.PENDING_BYTES, rowKey, autoCompactionSnapshot.getBytesAwaitingCompaction());
        stats.add(Stats.Compaction.PENDING_SEGMENTS, rowKey, autoCompactionSnapshot.getSegmentCountAwaitingCompaction());
        stats.add(Stats.Compaction.PENDING_INTERVALS, rowKey, autoCompactionSnapshot.getIntervalCountAwaitingCompaction());
        stats.add(Stats.Compaction.COMPACTED_BYTES, rowKey, autoCompactionSnapshot.getBytesCompacted());
        stats.add(Stats.Compaction.COMPACTED_SEGMENTS, rowKey, autoCompactionSnapshot.getSegmentCountCompacted());
        stats.add(Stats.Compaction.COMPACTED_INTERVALS, rowKey, autoCompactionSnapshot.getIntervalCountCompacted());
        stats.add(Stats.Compaction.SKIPPED_BYTES, rowKey, autoCompactionSnapshot.getBytesSkipped());
        stats.add(Stats.Compaction.SKIPPED_SEGMENTS, rowKey, autoCompactionSnapshot.getSegmentCountSkipped());
        stats.add(Stats.Compaction.SKIPPED_INTERVALS, rowKey, autoCompactionSnapshot.getIntervalCountSkipped());
    }

    @Nullable
    public AutoCompactionSnapshot getAutoCompactionSnapshot(String dataSource) {
        return this.autoCompactionSnapshotPerDataSource.get().get(dataSource);
    }

    public Map<String, AutoCompactionSnapshot> getAutoCompactionSnapshot() {
        return this.autoCompactionSnapshotPerDataSource.get();
    }

    private String compactSegments(CompactionCandidate entry, int compactionTaskPriority, ClientCompactionTaskQueryTuningConfig tuningConfig, ClientCompactionTaskGranularitySpec granularitySpec, @Nullable ClientCompactionTaskDimensionsSpec dimensionsSpec, @Nullable AggregatorFactory[] metricsSpec, @Nullable ClientCompactionTaskTransformSpec transformSpec, @Nullable Boolean dropExisting, @Nullable Map<String, Object> context, ClientCompactionRunnerInfo compactionRunner) {
        List<DataSegment> segments = entry.getSegments();
        Preconditions.checkArgument((!segments.isEmpty() ? 1 : 0) != 0, (Object)"Expect non-empty segments to compact");
        String dataSource = segments.get(0).getDataSource();
        Preconditions.checkArgument((boolean)segments.stream().allMatch(segment -> segment.getDataSource().equals(dataSource)), (Object)"Segments must have the same dataSource");
        context = context == null ? new HashMap<String, Object>() : context;
        context.put("priority", compactionTaskPriority);
        String taskId = IdUtils.newTaskId((String)TASK_ID_PREFIX, (String)COMPACTION_TASK_TYPE, (String)dataSource, null);
        Granularity segmentGranularity = granularitySpec == null ? null : granularitySpec.getSegmentGranularity();
        ClientCompactionTaskQuery taskPayload = new ClientCompactionTaskQuery(taskId, dataSource, new ClientCompactionIOConfig(ClientCompactionIntervalSpec.fromSegments(segments, segmentGranularity), dropExisting), tuningConfig, granularitySpec, dimensionsSpec, metricsSpec, transformSpec, context, compactionRunner);
        FutureUtils.getUnchecked(this.overlordClient.runTask(taskId, taskPayload), (boolean)true);
        this.statusTracker.onTaskSubmitted(taskPayload, entry);
        return taskId;
    }
}

