/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client.broker;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import org.apache.druid.client.broker.BrokerClient;
import org.apache.druid.common.guava.FutureUtils;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.druid.java.util.http.client.response.BytesFullResponseHandler;
import org.apache.druid.query.explain.ExplainPlan;
import org.apache.druid.query.http.ClientSqlQuery;
import org.apache.druid.query.http.SqlTaskStatus;
import org.apache.druid.rpc.RequestBuilder;
import org.apache.druid.rpc.ServiceClient;
import org.jboss.netty.handler.codec.http.HttpMethod;

public class BrokerClientImpl
implements BrokerClient {
    private final ServiceClient client;
    private final ObjectMapper jsonMapper;

    public BrokerClientImpl(ServiceClient client, ObjectMapper jsonMapper) {
        this.client = client;
        this.jsonMapper = jsonMapper;
    }

    @Override
    public ListenableFuture<SqlTaskStatus> submitSqlTask(ClientSqlQuery sqlQuery) {
        return FutureUtils.transform(this.client.asyncRequest(new RequestBuilder(HttpMethod.POST, "/druid/v2/sql/task/").jsonContent(this.jsonMapper, sqlQuery), new BytesFullResponseHandler()), holder -> (SqlTaskStatus)JacksonUtils.readValue((ObjectMapper)this.jsonMapper, (byte[])holder.getContent(), SqlTaskStatus.class));
    }

    @Override
    public ListenableFuture<List<ExplainPlan>> fetchExplainPlan(ClientSqlQuery sqlQuery) {
        ClientSqlQuery explainSqlQuery = new ClientSqlQuery(StringUtils.format((String)"EXPLAIN PLAN FOR %s", (Object[])new Object[]{sqlQuery.getQuery()}), null, false, false, false, null, null);
        return FutureUtils.transform(this.client.asyncRequest(new RequestBuilder(HttpMethod.POST, "/druid/v2/sql/task/").jsonContent(this.jsonMapper, explainSqlQuery), new BytesFullResponseHandler()), holder -> (List)JacksonUtils.readValue((ObjectMapper)this.jsonMapper, (byte[])holder.getContent(), (TypeReference)new TypeReference<List<ExplainPlan>>(){}));
    }
}

