/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog.model.table;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Supplier;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.druid.catalog.model.ColumnSpec;
import org.apache.druid.catalog.model.Columns;
import org.apache.druid.catalog.model.TableDefnRegistry;
import org.apache.druid.catalog.model.table.BaseTableFunction;
import org.apache.druid.catalog.model.table.ExternalTableSpec;
import org.apache.druid.catalog.model.table.InputSourceDefn;
import org.apache.druid.catalog.model.table.ResolvedExternalTable;
import org.apache.druid.catalog.model.table.TableFunction;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.utils.CollectionUtils;

public abstract class BaseInputSourceDefn
implements InputSourceDefn {
    private static final Logger LOG = new Logger(BaseInputSourceDefn.class);
    private AdHocTableFunction adHocTableFn;

    protected abstract Class<? extends InputSource> inputSourceClass();

    @Override
    public void bind(TableDefnRegistry registry) {
        this.adHocTableFn = this.defineAdHocTableFunction();
    }

    @Override
    public void validate(ResolvedExternalTable table) {
        this.convertTableToSource(table);
    }

    protected abstract AdHocTableFunction defineAdHocTableFunction();

    @Override
    public TableFunction adHocTableFn() {
        return this.adHocTableFn;
    }

    protected ExternalTableSpec convertArgsToTable(Map<String, Object> args, List<ColumnSpec> columns, ObjectMapper jsonMapper) {
        return new ExternalTableSpec(this.convertArgsToSource(args, jsonMapper), this.convertArgsToFormat(args, columns, jsonMapper), Columns.convertSignature(columns), (Supplier<Set<String>>)((Supplier)() -> Collections.singleton(this.typeValue())));
    }

    protected InputSource convertArgsToSource(Map<String, Object> args, ObjectMapper jsonMapper) {
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        this.auditInputSource(jsonMap);
        this.convertArgsToSourceMap(jsonMap, args);
        return this.convertSource(jsonMap, jsonMapper);
    }

    protected abstract void convertArgsToSourceMap(Map<String, Object> var1, Map<String, Object> var2);

    protected InputFormat convertArgsToFormat(Map<String, Object> args, List<ColumnSpec> columns, ObjectMapper jsonMapper) {
        return null;
    }

    protected abstract ExternalTableSpec convertCompletedTable(ResolvedExternalTable var1, Map<String, Object> var2, List<ColumnSpec> var3);

    @Override
    public ExternalTableSpec convertTable(ResolvedExternalTable table) {
        return new ExternalTableSpec(this.convertTableToSource(table), this.convertTableToFormat(table), Columns.convertSignature(table.resolvedTable().spec().columns()), (Supplier<Set<String>>)((Supplier)() -> Collections.singleton(this.typeValue())));
    }

    protected InputSource convertTableToSource(ResolvedExternalTable table) {
        return this.convertSource(new HashMap<String, Object>(table.inputSourceMap), table.resolvedTable().jsonMapper());
    }

    protected InputSource convertSource(Map<String, Object> jsonMap, ObjectMapper jsonMapper) {
        try {
            this.auditInputSource(jsonMap);
            return (InputSource)jsonMapper.convertValue(jsonMap, this.inputSourceClass());
        }
        catch (Exception e) {
            LOG.debug((Throwable)e, "Invalid input source specification", new Object[0]);
            throw new IAE((Throwable)e, "Invalid input source specification", new Object[0]);
        }
    }

    protected void auditInputSource(Map<String, Object> jsonMap) {
    }

    protected abstract InputFormat convertTableToFormat(ResolvedExternalTable var1);

    protected List<ColumnSpec> selectPartialTableColumns(ResolvedExternalTable table, List<ColumnSpec> columns) {
        List<ColumnSpec> tableCols = table.resolvedTable().spec().columns();
        if (CollectionUtils.isNullOrEmpty(tableCols)) {
            return columns;
        }
        if (!CollectionUtils.isNullOrEmpty(columns)) {
            throw new IAE("Catalog definition for the [%s] input source already contains column definitions", new Object[]{this.typeValue()});
        }
        return tableCols;
    }

    public class PartialTableFunction
    extends BaseTableFunction {
        private final ResolvedExternalTable table;

        public PartialTableFunction(ResolvedExternalTable table, List<TableFunction.ParameterDefn> params) {
            super(params);
            this.table = table;
        }

        @Override
        public ExternalTableSpec apply(String fnName, Map<String, Object> args, List<ColumnSpec> columns, ObjectMapper jsonMapper) {
            if (CollectionUtils.isNullOrEmpty(this.table.resolvedTable().spec().columns())) {
                PartialTableFunction.requireSchema(fnName, columns);
            }
            return BaseInputSourceDefn.this.convertCompletedTable(this.table, args, columns);
        }
    }

    public class AdHocTableFunction
    extends BaseTableFunction {
        public AdHocTableFunction(List<TableFunction.ParameterDefn> parameters) {
            super(parameters);
        }

        @Override
        public ExternalTableSpec apply(String fnName, Map<String, Object> args, List<ColumnSpec> columns, ObjectMapper jsonMapper) {
            AdHocTableFunction.requireSchema(fnName, columns);
            return BaseInputSourceDefn.this.convertArgsToTable(args, columns, jsonMapper);
        }
    }
}

