/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.logs.model.transform;

import com.amazonaws.services.logs.model.Anomaly;
import com.amazonaws.services.logs.model.transform.PatternTokenJsonUnmarshaller;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.ListUnmarshaller;
import com.amazonaws.transform.MapUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class AnomalyJsonUnmarshaller
implements Unmarshaller<Anomaly, JsonUnmarshallerContext> {
    private static AnomalyJsonUnmarshaller instance;

    public Anomaly unmarshall(JsonUnmarshallerContext context) throws Exception {
        Anomaly anomaly = new Anomaly();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("anomalyId", targetDepth)) {
                    context.nextToken();
                    anomaly.setAnomalyId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("patternId", targetDepth)) {
                    context.nextToken();
                    anomaly.setPatternId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("anomalyDetectorArn", targetDepth)) {
                    context.nextToken();
                    anomaly.setAnomalyDetectorArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("patternString", targetDepth)) {
                    context.nextToken();
                    anomaly.setPatternString((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("patternRegex", targetDepth)) {
                    context.nextToken();
                    anomaly.setPatternRegex((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("priority", targetDepth)) {
                    context.nextToken();
                    anomaly.setPriority((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("firstSeen", targetDepth)) {
                    context.nextToken();
                    anomaly.setFirstSeen((Long)context.getUnmarshaller(Long.class).unmarshall((Object)context));
                }
                if (context.testExpression("lastSeen", targetDepth)) {
                    context.nextToken();
                    anomaly.setLastSeen((Long)context.getUnmarshaller(Long.class).unmarshall((Object)context));
                }
                if (context.testExpression("description", targetDepth)) {
                    context.nextToken();
                    anomaly.setDescription((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("active", targetDepth)) {
                    context.nextToken();
                    anomaly.setActive((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("state", targetDepth)) {
                    context.nextToken();
                    anomaly.setState((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("histogram", targetDepth)) {
                    context.nextToken();
                    anomaly.setHistogram(new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(Long.class)).unmarshall(context));
                }
                if (context.testExpression("logSamples", targetDepth)) {
                    context.nextToken();
                    anomaly.setLogSamples(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("patternTokens", targetDepth)) {
                    context.nextToken();
                    anomaly.setPatternTokens(new ListUnmarshaller((Unmarshaller)PatternTokenJsonUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("logGroupArnList", targetDepth)) {
                    context.nextToken();
                    anomaly.setLogGroupArnList(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("suppressed", targetDepth)) {
                    context.nextToken();
                    anomaly.setSuppressed((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("suppressedDate", targetDepth)) {
                    context.nextToken();
                    anomaly.setSuppressedDate((Long)context.getUnmarshaller(Long.class).unmarshall((Object)context));
                }
                if (context.testExpression("suppressedUntil", targetDepth)) {
                    context.nextToken();
                    anomaly.setSuppressedUntil((Long)context.getUnmarshaller(Long.class).unmarshall((Object)context));
                }
                if (context.testExpression("isPatternLevelSuppression", targetDepth)) {
                    context.nextToken();
                    anomaly.setIsPatternLevelSuppression((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return anomaly;
    }

    public static AnomalyJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new AnomalyJsonUnmarshaller();
        }
        return instance;
    }
}

