/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.security.basic;

import com.google.inject.Inject;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.security.basic.BasicAuthSSLConfig;
import org.apache.druid.server.security.TLSCertificateChecker;
import org.apache.druid.server.security.TLSUtils;

public class BasicSecuritySSLSocketFactory
extends SSLSocketFactory {
    private static final Logger LOG = new Logger(BasicSecuritySSLSocketFactory.class);
    private SSLSocketFactory sf;
    @Inject
    private static BasicAuthSSLConfig basicAuthSSLConfig;
    @Inject
    private static TLSCertificateChecker certificateChecker;

    public BasicSecuritySSLSocketFactory() {
        SSLContext ctx = new TLSUtils.ClientSSLContextBuilder().setProtocol(basicAuthSSLConfig.getProtocol()).setTrustStoreType(basicAuthSSLConfig.getTrustStoreType()).setTrustStorePath(basicAuthSSLConfig.getTrustStorePath()).setTrustStoreAlgorithm(basicAuthSSLConfig.getTrustStoreAlgorithm()).setTrustStorePasswordProvider(basicAuthSSLConfig.getTrustStorePasswordProvider()).setKeyStoreType(basicAuthSSLConfig.getKeyStoreType()).setKeyStorePath(basicAuthSSLConfig.getKeyStorePath()).setKeyStoreAlgorithm(basicAuthSSLConfig.getKeyManagerFactoryAlgorithm()).setCertAlias(basicAuthSSLConfig.getCertAlias()).setKeyStorePasswordProvider(basicAuthSSLConfig.getKeyStorePasswordProvider()).setKeyManagerFactoryPasswordProvider(basicAuthSSLConfig.getKeyManagerPasswordProvider()).setValidateHostnames(basicAuthSSLConfig.getValidateHostnames()).setCertificateChecker(certificateChecker).build();
        this.sf = ctx.getSocketFactory();
    }

    public static SocketFactory getDefault() {
        return new BasicSecuritySSLSocketFactory();
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.sf.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.sf.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        return this.sf.createSocket(s, host, port, autoClose);
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        return this.sf.createSocket(host, port);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
        return this.sf.createSocket(host, port, localHost, localPort);
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        return this.sf.createSocket(host, port);
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.sf.createSocket(address, port, localAddress, localPort);
    }
}

