/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.azure;

import com.azure.storage.blob.models.BlobStorageException;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import org.apache.druid.common.utils.CurrentTimeMillisSupplier;
import org.apache.druid.guice.annotations.Global;
import org.apache.druid.java.util.common.IOE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.storage.azure.AzureAccountConfig;
import org.apache.druid.storage.azure.AzureCloudBlobIterableFactory;
import org.apache.druid.storage.azure.AzureInputDataConfig;
import org.apache.druid.storage.azure.AzureStorage;
import org.apache.druid.storage.azure.AzureTaskLogsConfig;
import org.apache.druid.storage.azure.AzureUtils;
import org.apache.druid.storage.azure.blob.CloudBlobHolder;
import org.apache.druid.tasklogs.TaskLogs;

public class AzureTaskLogs
implements TaskLogs {
    private static final Logger log = new Logger(AzureTaskLogs.class);
    private final AzureTaskLogsConfig config;
    private final AzureInputDataConfig inputDataConfig;
    private final AzureAccountConfig accountConfig;
    private final AzureStorage azureStorage;
    private final AzureCloudBlobIterableFactory azureCloudBlobIterableFactory;
    private final CurrentTimeMillisSupplier timeSupplier;

    @Inject
    public AzureTaskLogs(AzureTaskLogsConfig config, AzureInputDataConfig inputDataConfig, AzureAccountConfig accountConfig, @Global AzureStorage azureStorage, AzureCloudBlobIterableFactory azureCloudBlobIterableFactory, CurrentTimeMillisSupplier timeSupplier) {
        this.config = config;
        this.inputDataConfig = inputDataConfig;
        this.azureStorage = azureStorage;
        this.accountConfig = accountConfig;
        this.azureCloudBlobIterableFactory = azureCloudBlobIterableFactory;
        this.timeSupplier = timeSupplier;
    }

    public void pushTaskLog(String taskid, File logFile) {
        String taskKey = this.getTaskLogKey(taskid);
        log.info("Pushing task log %s to: %s", new Object[]{logFile, taskKey});
        this.pushTaskFile(logFile, taskKey);
    }

    public void pushTaskReports(String taskid, File reportFile) {
        String taskKey = this.getTaskReportsKey(taskid);
        log.info("Pushing task reports %s to: %s", new Object[]{reportFile, taskKey});
        this.pushTaskFile(reportFile, taskKey);
    }

    public void pushTaskStatus(String taskid, File statusFile) {
        String taskKey = this.getTaskStatusKey(taskid);
        log.info("Pushing task status %s to: %s", new Object[]{statusFile, taskKey});
        this.pushTaskFile(statusFile, taskKey);
    }

    private void pushTaskFile(File logFile, String taskKey) {
        try {
            this.azureStorage.uploadBlockBlob(logFile, this.config.getContainer(), taskKey, this.accountConfig.getMaxTries());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void pushTaskPayload(String taskid, File taskPayloadFile) {
        String taskKey = this.getTaskPayloadKey(taskid);
        log.info("Pushing task payload [%s] to location [%s]", new Object[]{taskPayloadFile, taskKey});
        this.pushTaskFile(taskPayloadFile, taskKey);
    }

    public Optional<InputStream> streamTaskPayload(String taskid) throws IOException {
        return this.streamTaskFile(0L, this.getTaskPayloadKey(taskid));
    }

    public Optional<InputStream> streamTaskLog(String taskid, long offset) throws IOException {
        return this.streamTaskFile(offset, this.getTaskLogKey(taskid));
    }

    public Optional<InputStream> streamTaskReports(String taskid) throws IOException {
        return this.streamTaskFile(0L, this.getTaskReportsKey(taskid));
    }

    public Optional<InputStream> streamTaskStatus(String taskid) throws IOException {
        return this.streamTaskFile(0L, this.getTaskStatusKey(taskid));
    }

    private Optional<InputStream> streamTaskFile(long offset, String taskKey) throws IOException {
        String container = this.config.getContainer();
        try {
            if (!this.azureStorage.getBlockBlobExists(container, taskKey)) {
                return Optional.absent();
            }
            try {
                long length = this.azureStorage.getBlockBlobLength(container, taskKey);
                long start = offset > 0L && offset < length ? offset : (offset < 0L && -1L * offset < length ? length + offset : 0L);
                InputStream stream = this.azureStorage.getBlockBlobInputStream(container, taskKey);
                stream.skip(start);
                return Optional.of((Object)stream);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        catch (BlobStorageException e) {
            throw new IOE((Throwable)e, "Failed to stream logs from: %s", new Object[]{taskKey});
        }
    }

    private String getTaskLogKey(String taskid) {
        return StringUtils.format((String)"%s/%s/log", (Object[])new Object[]{this.config.getPrefix(), taskid});
    }

    private String getTaskReportsKey(String taskid) {
        return StringUtils.format((String)"%s/%s/report.json", (Object[])new Object[]{this.config.getPrefix(), taskid});
    }

    private String getTaskStatusKey(String taskid) {
        return StringUtils.format((String)"%s/%s/status.json", (Object[])new Object[]{this.config.getPrefix(), taskid});
    }

    private String getTaskPayloadKey(String taskid) {
        return StringUtils.format((String)"%s/%s/task.json", (Object[])new Object[]{this.config.getPrefix(), taskid});
    }

    public void killAll() throws IOException {
        log.info("Deleting all task logs from Azure storage location [bucket: %s    prefix: %s].", new Object[]{this.config.getContainer(), this.config.getPrefix()});
        long now = this.timeSupplier.getAsLong();
        this.killOlderThan(now);
    }

    public void killOlderThan(long timestamp) throws IOException {
        log.info("Deleting all task logs from Azure storage location [bucket: '%s' prefix: '%s'] older than %s.", new Object[]{this.config.getContainer(), this.config.getPrefix(), new Date(timestamp)});
        try {
            AzureUtils.deleteObjectsInPath(this.azureStorage, this.inputDataConfig, this.accountConfig, this.azureCloudBlobIterableFactory, this.config.getContainer(), this.config.getPrefix(), (Predicate<CloudBlobHolder>)((Predicate)object -> object.getLastModifed().getTime() < timestamp));
        }
        catch (Exception e) {
            log.error("Error occurred while deleting task log files from Azure. Error: %s", new Object[]{e.getMessage()});
            throw new IOException(e);
        }
    }
}

