/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.virtual;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprType;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.InputBindings;
import org.apache.druid.math.expr.vector.CastToTypeVectorProcessor;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;
import org.apache.druid.math.expr.vector.VectorProcessors;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.groupby.DeferExpressionDimensions;
import org.apache.druid.query.groupby.epinephelinae.vector.GroupByVectorColumnSelector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.Types;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.vector.ConstantVectorSelectors;
import org.apache.druid.segment.vector.ReadableVectorInspector;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;
import org.apache.druid.segment.vector.VectorObjectSelector;
import org.apache.druid.segment.vector.VectorValueSelector;
import org.apache.druid.segment.virtual.ExpressionDeferredGroupByVectorColumnSelector;
import org.apache.druid.segment.virtual.ExpressionPlan;
import org.apache.druid.segment.virtual.ExpressionPlanner;
import org.apache.druid.segment.virtual.ExpressionSelectors;
import org.apache.druid.segment.virtual.ExpressionVectorInputBinding;
import org.apache.druid.segment.virtual.ExpressionVectorMultiValueStringObjectSelector;
import org.apache.druid.segment.virtual.ExpressionVectorObjectSelector;
import org.apache.druid.segment.virtual.ExpressionVectorValueSelector;
import org.apache.druid.segment.virtual.SingleStringInputDeferredEvaluationExpressionDimensionVectorSelector;

public class ExpressionVectorSelectors {
    private ExpressionVectorSelectors() {
    }

    public static SingleValueDimensionVectorSelector makeSingleValueDimensionVectorSelector(VectorColumnSelectorFactory factory, Expr expression) {
        ExpressionPlan plan = ExpressionPlanner.plan(factory, expression);
        Preconditions.checkArgument((boolean)plan.is(ExpressionPlan.Trait.VECTORIZABLE));
        if (plan.isConstant()) {
            String constant = plan.getExpression().eval(InputBindings.nilBindings()).asString();
            return ConstantVectorSelectors.singleValueDimensionVectorSelector(factory.getReadableVectorInspector(), constant);
        }
        if (plan.is(ExpressionPlan.Trait.SINGLE_INPUT_SCALAR) && plan.getOutputType() != null && plan.getOutputType().is(ExprType.STRING)) {
            return new SingleStringInputDeferredEvaluationExpressionDimensionVectorSelector(factory.makeSingleValueDimensionSelector(DefaultDimensionSpec.of(plan.getSingleInputName())), plan.getExpression());
        }
        throw new IllegalStateException("Only constant and single input string expressions currently support dictionary encoded selectors");
    }

    public static VectorValueSelector makeVectorValueSelector(VectorColumnSelectorFactory factory, Expr expression) {
        ExpressionPlan plan = ExpressionPlanner.plan(factory, expression);
        Preconditions.checkArgument((boolean)plan.is(ExpressionPlan.Trait.VECTORIZABLE));
        if (plan.isConstant()) {
            return ConstantVectorSelectors.vectorValueSelector(factory.getReadableVectorInspector(), (Number)plan.getExpression().eval(InputBindings.nilBindings()).valueOrDefault());
        }
        Expr.VectorInputBinding bindings = ExpressionVectorSelectors.createVectorBindings(plan.getAnalysis(), factory);
        ExprVectorProcessor processor = plan.getExpression().asVectorProcessor(bindings);
        return new ExpressionVectorValueSelector(processor, bindings);
    }

    public static VectorObjectSelector makeVectorObjectSelector(VectorColumnSelectorFactory factory, Expr expression, @Nullable ColumnType outputTypeHint) {
        ExpressionPlan plan = ExpressionPlanner.plan(factory, expression);
        Preconditions.checkArgument((boolean)plan.is(ExpressionPlan.Trait.VECTORIZABLE));
        if (plan.isConstant()) {
            ExprEval eval = plan.getExpression().eval(InputBindings.nilBindings());
            if (Types.is(outputTypeHint, ValueType.STRING) && eval.type().isArray()) {
                return ConstantVectorSelectors.vectorObjectSelector(factory.getReadableVectorInspector(), ExpressionSelectors.coerceEvalToObjectOrList(eval));
            }
            return ConstantVectorSelectors.vectorObjectSelector(factory.getReadableVectorInspector(), eval.valueOrDefault());
        }
        Expr.VectorInputBinding bindings = ExpressionVectorSelectors.createVectorBindings(plan.getAnalysis(), factory);
        ExprVectorProcessor processor = plan.getExpression().asVectorProcessor(bindings);
        if (Types.is(outputTypeHint, ValueType.STRING) && processor.getOutputType().isArray()) {
            return new ExpressionVectorMultiValueStringObjectSelector(processor, bindings);
        }
        return new ExpressionVectorObjectSelector(processor, bindings);
    }

    @Nullable
    public static GroupByVectorColumnSelector makeGroupByVectorColumnSelector(VectorColumnSelectorFactory factory, Expr expression, DeferExpressionDimensions deferExpressionDimensions) {
        ExpressionPlan plan = ExpressionPlanner.plan(factory, expression);
        Preconditions.checkArgument((boolean)plan.is(ExpressionPlan.Trait.VECTORIZABLE));
        List<String> requiredBindings = plan.getAnalysis().getRequiredBindingsList();
        if (!deferExpressionDimensions.useDeferredGroupBySelector(plan, requiredBindings, factory)) {
            return null;
        }
        RowSignature.Builder requiredBindingsSignatureBuilder = RowSignature.builder();
        ArrayList<GroupByVectorColumnSelector> subSelectors = new ArrayList<GroupByVectorColumnSelector>();
        for (String columnName : requiredBindings) {
            ColumnCapabilities capabilities = factory.getColumnCapabilities(columnName);
            ColumnType columnType = capabilities != null ? capabilities.toColumnType() : ColumnType.STRING;
            GroupByVectorColumnSelector subSelector = factory.makeGroupByVectorColumnSelector(columnName, deferExpressionDimensions);
            requiredBindingsSignatureBuilder.add(columnName, columnType);
            subSelectors.add(subSelector);
        }
        return new ExpressionDeferredGroupByVectorColumnSelector(expression.asSingleThreaded(factory), requiredBindingsSignatureBuilder.build(), subSelectors);
    }

    public static VectorObjectSelector castValueSelectorToObject(ReadableVectorInspector inspector, String columnName, VectorValueSelector selector, ColumnType selectorType, ColumnType castTo) {
        ExpressionVectorInputBinding binding = new ExpressionVectorInputBinding(inspector);
        binding.addNumeric(columnName, ExpressionType.fromColumnType(selectorType), selector);
        return new ExpressionVectorObjectSelector(CastToTypeVectorProcessor.cast(VectorProcessors.identifier(binding, columnName), ExpressionType.fromColumnType(castTo), binding.getMaxVectorSize()), binding);
    }

    public static VectorValueSelector castObjectSelectorToNumeric(ReadableVectorInspector inspector, String columnName, VectorObjectSelector selector, ColumnType selectorType, ColumnType castTo) {
        Preconditions.checkArgument((boolean)castTo.isNumeric(), (Object)"Must cast to a numeric type to make a value selector");
        ExpressionVectorInputBinding binding = new ExpressionVectorInputBinding(inspector);
        binding.addObjectSelector(columnName, ExpressionType.fromColumnType(selectorType), selector);
        return new ExpressionVectorValueSelector(CastToTypeVectorProcessor.cast(VectorProcessors.identifier(binding, columnName), ExpressionType.fromColumnType(castTo), binding.getMaxVectorSize()), binding);
    }

    private static Expr.VectorInputBinding createVectorBindings(Expr.BindingAnalysis bindingAnalysis, VectorColumnSelectorFactory vectorColumnSelectorFactory) {
        ExpressionVectorInputBinding binding = new ExpressionVectorInputBinding(vectorColumnSelectorFactory.getReadableVectorInspector());
        List<String> columns = bindingAnalysis.getRequiredBindingsList();
        block4: for (String columnName : columns) {
            ColumnCapabilities columnCapabilities = vectorColumnSelectorFactory.getColumnCapabilities(columnName);
            if (columnCapabilities == null) continue;
            switch ((ValueType)columnCapabilities.getType()) {
                case FLOAT: 
                case DOUBLE: {
                    binding.addNumeric(columnName, ExpressionType.DOUBLE, vectorColumnSelectorFactory.makeValueSelector(columnName));
                    continue block4;
                }
                case LONG: {
                    binding.addNumeric(columnName, ExpressionType.LONG, vectorColumnSelectorFactory.makeValueSelector(columnName));
                    continue block4;
                }
            }
            binding.addObjectSelector(columnName, ExpressionType.fromColumnType(columnCapabilities.toColumnType()), vectorColumnSelectorFactory.makeObjectSelector(columnName));
        }
        return binding;
    }
}

