/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join.lookup;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.Closeable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.query.filter.InDimFilter;
import org.apache.druid.query.lookup.LookupExtractor;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.join.JoinConditionAnalysis;
import org.apache.druid.segment.join.JoinMatcher;
import org.apache.druid.segment.join.Joinable;
import org.apache.druid.segment.join.lookup.LookupJoinMatcher;

public class LookupJoinable
implements Joinable {
    static final List<String> ALL_COLUMNS = ImmutableList.of((Object)"k", (Object)"v");
    private final LookupExtractor extractor;

    private LookupJoinable(LookupExtractor extractor) {
        this.extractor = extractor;
    }

    public static LookupJoinable wrap(LookupExtractor extractor) {
        return new LookupJoinable(extractor);
    }

    @Override
    public List<String> getAvailableColumns() {
        return ALL_COLUMNS;
    }

    @Override
    public int getCardinality(String columnName) {
        return -1;
    }

    @Override
    @Nullable
    public ColumnCapabilities getColumnCapabilities(String columnName) {
        if (ALL_COLUMNS.contains(columnName)) {
            return new ColumnCapabilitiesImpl().setType(ColumnType.STRING);
        }
        return null;
    }

    @Override
    public JoinMatcher makeJoinMatcher(ColumnSelectorFactory leftSelectorFactory, JoinConditionAnalysis condition, boolean remainderNeeded, Closer closer) {
        return LookupJoinMatcher.create(this.extractor, leftSelectorFactory, condition, remainderNeeded);
    }

    @Override
    public Joinable.ColumnValuesWithUniqueFlag getMatchableColumnValues(String columnName, boolean includeNull, int maxNumValues) {
        if ("k".equals(columnName) && this.extractor.supportsAsMap()) {
            Set<String> nonMatchingValues;
            Set<String> keys = this.extractor.asMap().keySet();
            if (includeNull) {
                nonMatchingValues = Collections.emptySet();
            } else {
                nonMatchingValues = new HashSet<String>();
                nonMatchingValues.add(null);
            }
            int matchingKeys = keys.size();
            for (String value : nonMatchingValues) {
                if (!keys.contains(value)) continue;
                --matchingKeys;
            }
            if (matchingKeys > maxNumValues) {
                return new Joinable.ColumnValuesWithUniqueFlag((Set<String>)ImmutableSet.of(), false);
            }
            if (matchingKeys == keys.size()) {
                return new Joinable.ColumnValuesWithUniqueFlag(keys, true);
            }
            return new Joinable.ColumnValuesWithUniqueFlag((Set<String>)Sets.difference(keys, nonMatchingValues), true);
        }
        return new Joinable.ColumnValuesWithUniqueFlag((Set<String>)ImmutableSet.of(), false);
    }

    @Override
    public Optional<InDimFilter.ValuesSet> getCorrelatedColumnValues(String searchColumnName, String searchColumnValue, String retrievalColumnName, long maxCorrelationSetSize, boolean allowNonKeyColumnSearch) {
        InDimFilter.ValuesSet correlatedValues;
        if (!ALL_COLUMNS.contains(searchColumnName) || !ALL_COLUMNS.contains(retrievalColumnName)) {
            return Optional.empty();
        }
        if ("k".equals(searchColumnName)) {
            correlatedValues = "k".equals(retrievalColumnName) ? InDimFilter.ValuesSet.of(searchColumnValue) : InDimFilter.ValuesSet.of(this.extractor.apply(searchColumnValue));
        } else {
            if (!allowNonKeyColumnSearch) {
                return Optional.empty();
            }
            if ("v".equals(retrievalColumnName)) {
                correlatedValues = InDimFilter.ValuesSet.of(searchColumnValue);
            } else {
                Iterator<String> unapplied = this.extractor.unapplyAll(Collections.singleton(searchColumnValue));
                if (unapplied != null) {
                    correlatedValues = InDimFilter.ValuesSet.copyOf(unapplied);
                } else {
                    return Optional.empty();
                }
            }
        }
        return Optional.of(correlatedValues);
    }

    @Override
    public Optional<Closeable> acquireReferences() {
        return Optional.of(() -> {});
    }
}

