/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.column;

import java.util.Objects;
import org.apache.druid.segment.column.ColumnIndexCapabilities;

public class SimpleColumnIndexCapabilities
implements ColumnIndexCapabilities {
    private static final SimpleColumnIndexCapabilities DEFAULT = new SimpleColumnIndexCapabilities(true, true);
    private final boolean invertible;
    private final boolean exact;

    public static ColumnIndexCapabilities getConstant() {
        return DEFAULT;
    }

    public SimpleColumnIndexCapabilities(boolean invertible, boolean exact) {
        this.invertible = invertible;
        this.exact = exact;
    }

    @Override
    public boolean isInvertible() {
        return this.invertible;
    }

    @Override
    public boolean isExact() {
        return this.exact;
    }

    @Override
    public ColumnIndexCapabilities merge(ColumnIndexCapabilities other) {
        return new SimpleColumnIndexCapabilities(this.invertible && other.isInvertible(), this.exact && other.isExact());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleColumnIndexCapabilities that = (SimpleColumnIndexCapabilities)o;
        return this.invertible == that.invertible && this.exact == that.exact;
    }

    public int hashCode() {
        return Objects.hash(this.invertible, this.exact);
    }
}

