/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntIterators;
import it.unimi.dsi.fastutil.longs.LongHeaps;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.druid.java.util.common.IAE;

public final class IntIteratorUtils {
    public static int skip(IntIterator it, int n) {
        int skipped;
        if (n < 0) {
            throw new IAE("n: " + n, new Object[0]);
        }
        for (skipped = 0; skipped < n && it.hasNext(); ++skipped) {
            it.nextInt();
        }
        return skipped;
    }

    public static IntIterator mergeAscending(List<IntIterator> iterators) {
        if (iterators.isEmpty()) {
            return IntIterators.EMPTY_ITERATOR;
        }
        if (iterators.size() == 1) {
            return iterators.get(0);
        }
        return new MergeIntIterator(iterators);
    }

    public static IntIterator fromRoaringBitmapIntIterator(org.roaringbitmap.IntIterator iterator) {
        return new RoaringBitmapDelegatingIntIterator(iterator);
    }

    private IntIteratorUtils() {
    }

    private static class RoaringBitmapDelegatingIntIterator
    implements IntIterator {
        private final org.roaringbitmap.IntIterator delegate;

        private RoaringBitmapDelegatingIntIterator(org.roaringbitmap.IntIterator delegate) {
            this.delegate = delegate;
        }

        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        public int nextInt() {
            return this.delegate.next();
        }

        public int skip(int n) {
            return IntIteratorUtils.skip(this, n);
        }
    }

    static final class MergeIntIterator
    implements IntIterator {
        private final IntIterator[] iterators;
        private final long[] pQueue;
        private int pQueueSize;

        private static long makeQueueElement(int value, int index) {
            return (long)index | (long)value << 32;
        }

        private static int value(long queueElement) {
            return (int)(queueElement >>> 32);
        }

        private static int iterIndex(long queueElement) {
            return (int)queueElement;
        }

        MergeIntIterator(List<IntIterator> iterators) {
            this.iterators = iterators.toArray(new IntIterator[0]);
            this.pQueue = new long[iterators.size()];
            this.pQueueSize = 0;
            for (int iterIndex = 0; iterIndex < this.iterators.length; ++iterIndex) {
                IntIterator iter = this.iterators[iterIndex];
                if (iter == null || !iter.hasNext()) continue;
                this.pQueue[this.pQueueSize] = MergeIntIterator.makeQueueElement(iter.nextInt(), iterIndex);
                ++this.pQueueSize;
                LongHeaps.upHeap((long[])this.pQueue, (int)this.pQueueSize, (int)(this.pQueueSize - 1), null);
            }
        }

        public boolean hasNext() {
            return this.pQueueSize != 0;
        }

        public int nextInt() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            long queueHead = this.pQueue[0];
            int retVal = MergeIntIterator.value(queueHead);
            int iterIndex = MergeIntIterator.iterIndex(queueHead);
            IntIterator retIt = this.iterators[iterIndex];
            if (retIt.hasNext()) {
                this.pQueue[0] = MergeIntIterator.makeQueueElement(retIt.nextInt(), iterIndex);
                LongHeaps.downHeap((long[])this.pQueue, (int)this.pQueueSize, (int)0, null);
            } else {
                --this.pQueueSize;
                if (this.pQueueSize != 0) {
                    this.pQueue[0] = this.pQueue[this.pQueueSize];
                    LongHeaps.downHeap((long[])this.pQueue, (int)this.pQueueSize, (int)0, null);
                }
            }
            return retVal;
        }

        public int skip(int n) {
            return IntIteratorUtils.skip(this, n);
        }
    }
}

