/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.rowsandcols.concrete;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.common.semantic.SemanticCreator;
import org.apache.druid.common.semantic.SemanticUtils;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.query.rowsandcols.column.Column;
import org.apache.druid.query.rowsandcols.concrete.ColumnHolderRACColumn;
import org.apache.druid.segment.CloseableShapeshifter;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexCursorFactory;
import org.apache.druid.segment.column.ColumnHolder;

public class QueryableIndexRowsAndColumns
implements RowsAndColumns,
AutoCloseable,
CloseableShapeshifter {
    private static final Map<Class<?>, Function<QueryableIndexRowsAndColumns, ?>> AS_MAP = SemanticUtils.makeAsMap(QueryableIndexRowsAndColumns.class);
    private final QueryableIndex index;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final Closer closer = Closer.create();
    private final AtomicInteger numRows = new AtomicInteger(-1);

    public QueryableIndexRowsAndColumns(QueryableIndex index) {
        this.index = index;
    }

    @Override
    public Collection<String> getColumnNames() {
        return this.index.getColumnNames();
    }

    @Override
    public int numRows() {
        int retVal = this.numRows.get();
        if (retVal < 0) {
            retVal = this.index.getNumRows();
            this.numRows.set(retVal);
        }
        return retVal;
    }

    @Override
    @Nullable
    public Column findColumn(String name) {
        if (this.closed.get()) {
            throw DruidException.defensive("Cannot be accessed after being closed!?", new Object[0]);
        }
        ColumnHolder columnHolder = this.index.getColumnHolder(name);
        if (columnHolder == null) {
            return null;
        }
        return this.closer.register(new ColumnHolderRACColumn(columnHolder));
    }

    @Override
    @Nullable
    public <T> T as(@Nonnull Class<T> clazz) {
        return (T)AS_MAP.getOrDefault(clazz, arg -> null).apply(this);
    }

    @Override
    public void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            this.closer.close();
        }
    }

    @SemanticCreator
    public CursorFactory toCursorFactory() {
        return new QueryableIndexCursorFactory(this.index);
    }

    @SemanticCreator
    public QueryableIndex toQueryableIndex() {
        return this.index;
    }
}

