/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.rowsandcols.concrete;

import com.google.common.base.Objects;
import java.util.Collection;
import java.util.LinkedHashMap;
import javax.annotation.Nullable;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.read.FrameReader;
import org.apache.druid.query.rowsandcols.column.Column;
import org.apache.druid.query.rowsandcols.concrete.FrameRowsAndColumns;
import org.apache.druid.segment.CloseableShapeshifter;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.column.RowSignature;

public abstract class AbstractFrameRowsAndColumns
implements FrameRowsAndColumns,
AutoCloseable,
CloseableShapeshifter {
    final Frame frame;
    final RowSignature signature;
    final LinkedHashMap<String, Column> colCache = new LinkedHashMap();

    public AbstractFrameRowsAndColumns(Frame frame, RowSignature signature) {
        this.frame = frame;
        this.signature = signature;
    }

    @Override
    public Frame getFrame() {
        return this.frame;
    }

    @Override
    public RowSignature getSignature() {
        return this.signature;
    }

    @Override
    public Collection<String> getColumnNames() {
        return this.signature.getColumnNames();
    }

    @Override
    public int numRows() {
        return this.frame.numRows();
    }

    @Override
    @Nullable
    public <T> T as(Class<T> clazz) {
        if (CursorFactory.class.equals(clazz)) {
            return (T)FrameReader.create(this.signature).makeCursorFactory(this.frame);
        }
        return FrameRowsAndColumns.super.as(clazz);
    }

    @Override
    public void close() {
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.frame, this.signature});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractFrameRowsAndColumns)) {
            return false;
        }
        AbstractFrameRowsAndColumns otherFrame = (AbstractFrameRowsAndColumns)o;
        return this.frame.writableMemory().equals(otherFrame.frame.writableMemory()) && this.signature.equals(otherFrame.signature);
    }
}

