/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.any;

import java.nio.ByteBuffer;
import org.apache.druid.query.aggregation.any.NumericAnyVectorAggregator;
import org.apache.druid.segment.vector.VectorValueSelector;

public class LongAnyVectorAggregator
extends NumericAnyVectorAggregator {
    public LongAnyVectorAggregator(VectorValueSelector vectorValueSelector) {
        super(vectorValueSelector);
    }

    @Override
    void initValue(ByteBuffer buf, int position) {
        buf.putLong(position, 0L);
    }

    @Override
    boolean putAnyValueFromRow(ByteBuffer buf, int position, int startRow, int endRow) {
        boolean isRowsWithinIndex;
        long[] values = this.vectorValueSelector.getLongVector();
        boolean bl = isRowsWithinIndex = startRow < endRow && startRow < values.length;
        if (isRowsWithinIndex) {
            buf.putLong(position, values[startRow]);
        }
        return isRowsWithinIndex;
    }

    @Override
    Object getNonNullObject(ByteBuffer buf, int position) {
        return buf.getLong(position);
    }
}

