/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.HumanReadableBytes;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.query.BadQueryContextException;
import org.apache.druid.query.QueryContexts;
import org.apache.druid.query.QueryResourceId;

public class QueryContext {
    private static final QueryContext EMPTY = new QueryContext(null);
    private final Map<String, Object> context;

    public QueryContext(Map<String, Object> context) {
        this.context = context == null ? Collections.emptyMap() : Collections.unmodifiableMap(new TreeMap<String, Object>(context));
    }

    public static QueryContext empty() {
        return EMPTY;
    }

    public static QueryContext of(Map<String, Object> context) {
        return new QueryContext(context);
    }

    public boolean isEmpty() {
        return this.context.isEmpty();
    }

    public Map<String, Object> asMap() {
        return this.context;
    }

    public boolean containsKey(String key) {
        return this.context.containsKey(key);
    }

    @Nullable
    public Object get(String key) {
        return this.context.get(key);
    }

    @Nullable
    public String getString(String key) {
        return this.getString(key, null);
    }

    public String getString(String key, String defaultValue) {
        return QueryContexts.parseString(this.context, key, defaultValue);
    }

    public Boolean getBoolean(String key) {
        return QueryContexts.getAsBoolean(key, this.get(key));
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return QueryContexts.parseBoolean(this.context, key, defaultValue);
    }

    public Integer getInt(String key) {
        return QueryContexts.getAsInt(key, this.get(key));
    }

    public int getInt(String key, int defaultValue) {
        return QueryContexts.parseInt(this.context, key, defaultValue);
    }

    public Long getLong(String key) {
        return QueryContexts.getAsLong(key, this.get(key));
    }

    public long getLong(String key, long defaultValue) {
        return QueryContexts.parseLong(this.context, key, defaultValue);
    }

    public Float getFloat(String key) {
        return QueryContexts.getAsFloat(key, this.get(key));
    }

    public float getFloat(String key, float defaultValue) {
        return QueryContexts.getAsFloat(key, this.get(key), defaultValue);
    }

    public HumanReadableBytes getHumanReadableBytes(String key, HumanReadableBytes defaultValue) {
        return QueryContexts.getAsHumanReadableBytes(key, this.get(key), defaultValue);
    }

    public HumanReadableBytes getHumanReadableBytes(String key, long defaultBytes) {
        return QueryContexts.getAsHumanReadableBytes(key, this.get(key), HumanReadableBytes.valueOf(defaultBytes));
    }

    public <E extends Enum<E>> E getEnum(String key, Class<E> clazz, E defaultValue) {
        return QueryContexts.getAsEnum(key, this.get(key), clazz, defaultValue);
    }

    public Granularity getGranularity(String key, ObjectMapper jsonMapper) {
        String granularityString = this.getString(key);
        if (granularityString == null) {
            return null;
        }
        try {
            return (Granularity)jsonMapper.readValue(granularityString, Granularity.class);
        }
        catch (IOException e) {
            throw QueryContexts.badTypeException(key, "a Granularity", granularityString);
        }
    }

    public boolean isDebug() {
        return this.getBoolean("debug", false);
    }

    public boolean isBySegment() {
        return this.isBySegment(false);
    }

    public boolean isBySegment(boolean defaultValue) {
        return this.getBoolean("bySegment", defaultValue);
    }

    public boolean isPopulateCache() {
        return this.isPopulateCache(true);
    }

    public boolean isPopulateCache(boolean defaultValue) {
        return this.getBoolean("populateCache", defaultValue);
    }

    public boolean isUseCache() {
        return this.isUseCache(true);
    }

    public boolean isUseCache(boolean defaultValue) {
        return this.getBoolean("useCache", defaultValue);
    }

    public boolean isPopulateResultLevelCache() {
        return this.isPopulateResultLevelCache(true);
    }

    public boolean isPopulateResultLevelCache(boolean defaultValue) {
        return this.getBoolean("populateResultLevelCache", defaultValue);
    }

    public boolean isUseResultLevelCache() {
        return this.isUseResultLevelCache(true);
    }

    public boolean isUseResultLevelCache(boolean defaultValue) {
        return this.getBoolean("useResultLevelCache", defaultValue);
    }

    public boolean isFinalize(boolean defaultValue) {
        return this.getBoolean("finalize", defaultValue);
    }

    public boolean isSerializeDateTimeAsLong(boolean defaultValue) {
        return this.getBoolean("serializeDateTimeAsLong", defaultValue);
    }

    public boolean isSerializeDateTimeAsLongInner(boolean defaultValue) {
        return this.getBoolean("serializeDateTimeAsLongInner", defaultValue);
    }

    public QueryContexts.Vectorize getVectorize() {
        return this.getVectorize(QueryContexts.DEFAULT_VECTORIZE);
    }

    public QueryContexts.Vectorize getVectorize(QueryContexts.Vectorize defaultValue) {
        return this.getEnum("vectorize", QueryContexts.Vectorize.class, defaultValue);
    }

    public QueryContexts.Vectorize getVectorizeVirtualColumns() {
        return this.getVectorizeVirtualColumns(QueryContexts.DEFAULT_VECTORIZE_VIRTUAL_COLUMN);
    }

    public QueryContexts.Vectorize getVectorizeVirtualColumns(QueryContexts.Vectorize defaultValue) {
        return this.getEnum("vectorizeVirtualColumns", QueryContexts.Vectorize.class, defaultValue);
    }

    public int getVectorSize() {
        return this.getVectorSize(512);
    }

    public int getVectorSize(int defaultSize) {
        return this.getInt("vectorSize", defaultSize);
    }

    public int getMaxSubqueryRows(int defaultSize) {
        return this.getInt("maxSubqueryRows", defaultSize);
    }

    public String getMaxSubqueryMemoryBytes(String defaultMemoryBytes) {
        Object maxSubqueryBytesObject = this.get("maxSubqueryBytes");
        if (maxSubqueryBytesObject == null) {
            maxSubqueryBytesObject = defaultMemoryBytes;
        }
        return String.valueOf(maxSubqueryBytesObject);
    }

    public boolean isUseNestedForUnknownTypeInSubquery(boolean defaultUseNestedForUnkownTypeInSubquery) {
        return this.getBoolean("useNestedForUnknownTypeInSubquery", defaultUseNestedForUnkownTypeInSubquery);
    }

    public boolean isUseNestedForUnknownTypeInSubquery() {
        return this.isUseNestedForUnknownTypeInSubquery(false);
    }

    public int getUncoveredIntervalsLimit() {
        return this.getUncoveredIntervalsLimit(0);
    }

    public int getUncoveredIntervalsLimit(int defaultValue) {
        return this.getInt("uncoveredIntervalsLimit", defaultValue);
    }

    public int getPriority() {
        return this.getPriority(0);
    }

    public int getPriority(int defaultValue) {
        return this.getInt("priority", defaultValue);
    }

    public String getLane() {
        return this.getString("lane");
    }

    public boolean getEnableParallelMerges() {
        return this.getBoolean("enableParallelMerge", true);
    }

    public int getParallelMergeInitialYieldRows(int defaultValue) {
        return this.getInt("parallelMergeInitialYieldRows", defaultValue);
    }

    public int getParallelMergeSmallBatchRows(int defaultValue) {
        return this.getInt("parallelMergeSmallBatchRows", defaultValue);
    }

    public int getParallelMergeParallelism(int defaultValue) {
        return this.getInt("parallelMergeParallelism", defaultValue);
    }

    public long getJoinFilterRewriteMaxSize() {
        return this.getLong("joinFilterRewriteMaxSize", 10000L);
    }

    public boolean getEnableJoinFilterPushDown() {
        return this.getBoolean("enableJoinFilterPushDown", true);
    }

    public boolean getEnableJoinFilterRewrite() {
        return this.getBoolean("enableJoinFilterRewrite", true);
    }

    public boolean isSecondaryPartitionPruningEnabled() {
        return this.getBoolean("secondaryPartitionPruning", true);
    }

    public long getMaxQueuedBytes(long defaultValue) {
        return this.getLong("maxQueuedBytes", defaultValue);
    }

    public long getMaxScatterGatherBytes() {
        return this.getLong("maxScatterGatherBytes", Long.MAX_VALUE);
    }

    public boolean hasTimeout() {
        return this.getTimeout() != 0L;
    }

    public long getTimeout() {
        return this.getTimeout(this.getDefaultTimeout());
    }

    public long getTimeout(long defaultTimeout) {
        long timeout = this.getLong("timeout", defaultTimeout);
        if (timeout >= 0L) {
            return timeout;
        }
        throw new BadQueryContextException(StringUtils.format("Timeout [%s] must be a non negative value, but was %d", "timeout", timeout));
    }

    public long getDefaultTimeout() {
        long defaultTimeout = this.getLong("defaultTimeout", QueryContexts.DEFAULT_TIMEOUT_MILLIS);
        if (defaultTimeout >= 0L) {
            return defaultTimeout;
        }
        throw new BadQueryContextException(StringUtils.format("Timeout [%s] must be a non negative value, but was %d", "defaultTimeout", defaultTimeout));
    }

    public void verifyMaxQueryTimeout(long maxQueryTimeout) {
        long timeout = this.getTimeout();
        if (timeout > maxQueryTimeout) {
            throw new BadQueryContextException(StringUtils.format("Configured %s = %d is more than enforced limit of %d.", "timeout", timeout, maxQueryTimeout));
        }
    }

    public void verifyMaxScatterGatherBytes(long maxScatterGatherBytesLimit) {
        long curr = this.getLong("maxScatterGatherBytes", 0L);
        if (curr > maxScatterGatherBytesLimit) {
            throw new BadQueryContextException(StringUtils.format("Configured %s = %d is more than enforced limit of %d.", "maxScatterGatherBytes", curr, maxScatterGatherBytesLimit));
        }
    }

    public int getNumRetriesOnMissingSegments(int defaultValue) {
        return this.getInt("numRetriesOnMissingSegments", defaultValue);
    }

    public boolean allowReturnPartialResults(boolean defaultValue) {
        return this.getBoolean("returnPartialResults", defaultValue);
    }

    public boolean getEnableJoinFilterRewriteValueColumnFilters() {
        return this.getBoolean("enableJoinFilterRewriteValueColumnFilters", false);
    }

    public boolean getEnableRewriteJoinToFilter() {
        return this.getBoolean("enableRewriteJoinToFilter", true);
    }

    public boolean getEnableJoinLeftScanDirect() {
        return this.getBoolean("enableJoinLeftTableScanDirect", false);
    }

    public int getInSubQueryThreshold() {
        return this.getInSubQueryThreshold(Integer.MAX_VALUE);
    }

    public int getInSubQueryThreshold(int defaultValue) {
        return this.getInt("inSubQueryThreshold", defaultValue);
    }

    public int getInFunctionThreshold() {
        return this.getInt("inFunctionThreshold", 100);
    }

    public int getInFunctionExprThreshold() {
        return this.getInt("inFunctionExprThreshold", 2);
    }

    public boolean isTimeBoundaryPlanningEnabled() {
        return this.getBoolean("enableTimeBoundaryPlanning", false);
    }

    public boolean isCatalogValidationEnabled() {
        return this.getBoolean("catalogValidationEnabled", true);
    }

    public boolean isExtendedFilteredSumRewrite() {
        return this.getBoolean("extendedFilteredSumRewrite", true);
    }

    public QueryResourceId getQueryResourceId() {
        return new QueryResourceId(this.getString("queryResourceId"));
    }

    public String getBrokerServiceName() {
        return this.getString("brokerService");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryContext other = (QueryContext)o;
        return this.context.equals(other.context);
    }

    public int hashCode() {
        return Objects.hash(this.context);
    }

    public String toString() {
        return "QueryContext{context=" + this.context + "}";
    }

    public boolean isDecoupledMode() {
        String value = this.getString("plannerStrategy", "COUPLED");
        return "DECOUPLED".equals(value);
    }
}

