/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common.logger;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

public class Logger {
    @VisibleForTesting
    static final int SEGMENTS_PER_LOG_MESSAGE = 64;
    private final org.slf4j.Logger log;
    private final boolean stackTraces;
    private final Logger noStackTraceLogger;

    public Logger(String name) {
        this(LoggerFactory.getLogger((String)name), true);
    }

    public Logger(Class clazz) {
        this(LoggerFactory.getLogger((Class)clazz), true);
    }

    protected Logger(org.slf4j.Logger log, boolean stackTraces) {
        this.log = log;
        this.stackTraces = stackTraces;
        this.noStackTraceLogger = stackTraces ? new Logger(log, false) : this;
    }

    protected org.slf4j.Logger getSlf4jLogger() {
        return this.log;
    }

    public String toString() {
        return StringUtils.format("Logger{name=[%s], class[%s]}", this.log.getName(), this.log.getClass());
    }

    public Logger noStackTrace() {
        return this.noStackTraceLogger;
    }

    public void trace(String message, Object ... formatArgs) {
        if (this.log.isTraceEnabled()) {
            this.log.trace(StringUtils.nonStrictFormat(message, formatArgs));
        }
    }

    public void trace(Marker marker, String message, Object ... formatArgs) {
        if (this.log.isTraceEnabled()) {
            this.log.trace(marker, StringUtils.nonStrictFormat(message, formatArgs));
        }
    }

    public void debug(String message, Object ... formatArgs) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(StringUtils.nonStrictFormat(message, formatArgs));
        }
    }

    public void debug(Marker marker, String message, Object ... formatArgs) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(marker, StringUtils.nonStrictFormat(message, formatArgs));
        }
    }

    public void debug(Throwable t, String message, Object ... formatArgs) {
        if (this.log.isDebugEnabled()) {
            this.logException((arg_0, arg_1) -> ((org.slf4j.Logger)this.log).debug(arg_0, arg_1), t, StringUtils.nonStrictFormat(message, formatArgs));
        }
    }

    public void info(String message, Object ... formatArgs) {
        if (this.log.isInfoEnabled()) {
            this.log.info(StringUtils.nonStrictFormat(message, formatArgs));
        }
    }

    public void info(Marker marker, String message, Object ... formatArgs) {
        if (this.log.isInfoEnabled()) {
            this.log.info(marker, StringUtils.nonStrictFormat(message, formatArgs));
        }
    }

    public void info(Throwable t, String message, Object ... formatArgs) {
        if (this.log.isInfoEnabled()) {
            this.logException((arg_0, arg_1) -> ((org.slf4j.Logger)this.log).info(arg_0, arg_1), t, StringUtils.nonStrictFormat(message, formatArgs));
        }
    }

    @Deprecated
    public void warn(String message, Throwable t) {
        this.warn(t, message, new Object[0]);
    }

    public void warn(String message, Object ... formatArgs) {
        this.log.warn(StringUtils.nonStrictFormat(message, formatArgs));
    }

    public void warn(Marker marker, String message, Object ... formatArgs) {
        this.log.warn(marker, StringUtils.nonStrictFormat(message, formatArgs));
    }

    public void warn(Throwable t, String message, Object ... formatArgs) {
        this.logException((arg_0, arg_1) -> ((org.slf4j.Logger)this.log).warn(arg_0, arg_1), t, StringUtils.nonStrictFormat(message, formatArgs));
    }

    public void error(String message, Object ... formatArgs) {
        this.log.error(StringUtils.nonStrictFormat(message, formatArgs));
    }

    public void error(Marker marker, String message, Object ... formatArgs) {
        this.log.error(marker, StringUtils.nonStrictFormat(message, formatArgs));
    }

    @Deprecated
    public void error(String message, Throwable t) {
        this.error(t, message, new Object[0]);
    }

    public void error(Throwable t, String message, Object ... formatArgs) {
        this.logException((arg_0, arg_1) -> ((org.slf4j.Logger)this.log).error(arg_0, arg_1), t, StringUtils.nonStrictFormat(message, formatArgs));
    }

    public void debugSegments(@Nullable Collection<DataSegment> segments, @Nullable String preamble) {
        if (this.log.isDebugEnabled()) {
            Logger.logSegments(this::debug, segments, preamble);
        }
    }

    public void infoSegments(@Nullable Collection<DataSegment> segments, @Nullable String preamble) {
        if (this.log.isInfoEnabled()) {
            Logger.logSegments(this::info, segments, preamble);
        }
    }

    public void infoSegmentIds(@Nullable Stream<SegmentId> segments, @Nullable String preamble) {
        if (this.log.isInfoEnabled()) {
            Logger.logSegmentIds(this::info, segments, preamble);
        }
    }

    public void warnSegments(@Nullable Collection<DataSegment> segments, @Nullable String preamble) {
        if (this.log.isWarnEnabled()) {
            Logger.logSegments(this::warn, segments, preamble);
        }
    }

    public void errorSegments(@Nullable Collection<DataSegment> segments, @Nullable String preamble) {
        Logger.logSegments(this::error, segments, preamble);
    }

    public boolean isTraceEnabled() {
        return this.log.isTraceEnabled();
    }

    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.log.isInfoEnabled();
    }

    private void logException(BiConsumer<String, Throwable> fn, Throwable t, String message) {
        boolean logStackTrace;
        boolean bl = logStackTrace = this.stackTraces || this.log.isDebugEnabled();
        if (logStackTrace) {
            if (t instanceof DruidException && !((DruidException)t).getContext().isEmpty()) {
                message = message == null ? "" : message + "\nDruidException context: " + ((DruidException)t).getContext();
            }
            fn.accept(message, t);
        } else if (message.isEmpty()) {
            fn.accept(t.toString(), null);
        } else {
            fn.accept(StringUtils.nonStrictFormat("%s (%s)", message, t.toString()), null);
        }
    }

    public String getName() {
        return this.log.getName();
    }

    @VisibleForTesting
    static void logSegments(LogFunction logger, @Nullable Collection<DataSegment> segments, @Nullable String preamble) {
        if (segments == null || segments.isEmpty()) {
            return;
        }
        Logger.logSegmentIds(logger, segments.stream().map(DataSegment::getId), preamble);
    }

    @VisibleForTesting
    static void logSegmentIds(LogFunction logger, @Nullable Stream<SegmentId> stream, @Nullable String preamble) {
        Preconditions.checkNotNull((Object)preamble);
        if (stream == null) {
            return;
        }
        Iterator iterator = stream.iterator();
        if (!iterator.hasNext()) {
            return;
        }
        String logFormat = preamble + ": %s";
        int counter = 0;
        StringBuilder sb = null;
        while (iterator.hasNext()) {
            SegmentId nextId = (SegmentId)iterator.next();
            if (counter == 0) {
                sb = new StringBuilder(64 * (2 + nextId.safeUpperLimitOfStringSize())).append("[");
            }
            sb.append(nextId);
            if (++counter < 64 && iterator.hasNext()) {
                sb.append(", ");
            }
            if ((counter %= 64) != 0) continue;
            sb.append("]");
            logger.log(logFormat, sb.toString());
        }
        if (counter > 0) {
            sb.append("]");
            logger.log(logFormat, sb.toString());
        }
    }

    @FunctionalInterface
    public static interface LogFunction {
        public void log(String var1, Object ... var2);
    }
}

