/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common.guava;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import org.apache.druid.java.util.common.guava.Accumulator;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.SequenceWrapper;
import org.apache.druid.java.util.common.guava.WrappingYielder;
import org.apache.druid.java.util.common.guava.Yielder;
import org.apache.druid.java.util.common.guava.YieldingAccumulator;

final class WrappingSequence<T>
implements Sequence<T> {
    private final Sequence<T> baseSequence;
    private final SequenceWrapper wrapper;

    WrappingSequence(Sequence<T> baseSequence, SequenceWrapper wrapper) {
        this.baseSequence = (Sequence)Preconditions.checkNotNull(baseSequence, (Object)"baseSequence");
        this.wrapper = (SequenceWrapper)Preconditions.checkNotNull((Object)wrapper, (Object)"wrapper");
    }

    @Override
    public <OutType> OutType accumulate(final OutType outType, final Accumulator<OutType, T> accumulator) {
        Object result;
        try {
            this.wrapper.before();
            result = this.wrapper.wrap(new Supplier<OutType>(){

                public OutType get() {
                    return WrappingSequence.this.baseSequence.accumulate(outType, accumulator);
                }
            });
        }
        catch (Throwable t) {
            try {
                this.wrapper.after(false, t);
            }
            catch (Exception e) {
                t.addSuppressed(e);
            }
            Throwables.propagateIfPossible((Throwable)t);
            throw new RuntimeException(t);
        }
        try {
            this.wrapper.after(true, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return (OutType)result;
    }

    @Override
    public <OutType> Yielder<OutType> toYielder(final OutType initValue, final YieldingAccumulator<OutType, T> accumulator) {
        try {
            this.wrapper.before();
            return (Yielder)this.wrapper.wrap(new Supplier<Yielder<OutType>>(){

                public Yielder<OutType> get() {
                    return new WrappingYielder<Object>(WrappingSequence.this.baseSequence.toYielder(initValue, accumulator), WrappingSequence.this.wrapper);
                }
            });
        }
        catch (Throwable t) {
            try {
                this.wrapper.after(false, t);
            }
            catch (Exception e) {
                t.addSuppressed(e);
            }
            Throwables.propagateIfPossible((Throwable)t);
            throw new RuntimeException(t);
        }
    }
}

