/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;

public class DefineClassUtils {
    private static final MethodHandle DEFINE_CLASS;
    private static final Exception DEFINE_CLASS_NOT_SUPPORTED_EXCEPTION;

    private static MethodHandle getMethodHandle(MethodHandles.Lookup lookup) throws ReflectiveOperationException {
        MethodHandle defineClass = lookup.unreflect(MethodHandles.Lookup.class.getMethod("defineClass", byte[].class));
        MethodHandle privateLookupIn = lookup.findStatic(MethodHandles.class, "privateLookupIn", MethodType.methodType(MethodHandles.Lookup.class, Class.class, MethodHandles.Lookup.class));
        privateLookupIn = MethodHandles.insertArguments(privateLookupIn, 1, lookup);
        defineClass = MethodHandles.filterArguments(defineClass, 0, privateLookupIn);
        defineClass = MethodHandles.dropArguments(defineClass, 2, new Class[]{String.class});
        return defineClass;
    }

    public static Class defineClass(Class<?> targetClass, byte[] byteCode, String className) {
        if (DEFINE_CLASS == null) {
            throw new UnsupportedOperationException("defineClass is not supported on this platform, because internal Java APIs are not compatible with this Druid version", DEFINE_CLASS_NOT_SUPPORTED_EXCEPTION);
        }
        try {
            return DEFINE_CLASS.invokeExact(targetClass, byteCode, className);
        }
        catch (Throwable t) {
            throw new UnsupportedOperationException("Unable to define specialized class: " + className, t);
        }
    }

    static {
        MethodHandle defineClass = null;
        Exception exception = null;
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            defineClass = DefineClassUtils.getMethodHandle(lookup);
        }
        catch (ReflectiveOperationException | RuntimeException e) {
            exception = e;
        }
        if (defineClass != null) {
            DEFINE_CLASS = defineClass;
            DEFINE_CLASS_NOT_SUPPORTED_EXCEPTION = null;
        } else {
            DEFINE_CLASS = null;
            DEFINE_CLASS_NOT_SUPPORTED_EXCEPTION = exception;
        }
    }
}

