/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.segment.row;

import com.google.common.base.Preconditions;
import org.apache.datasketches.memory.Memory;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.FrameType;
import org.apache.druid.frame.segment.row.ReadableFrameRowPointer;
import org.apache.druid.segment.data.ReadableOffset;

public class CursorFrameRowPointer
implements ReadableFrameRowPointer {
    private final Frame frame;
    private final ReadableOffset offset;
    private final Memory rowPositions;
    int cachedOffset = -1;
    long cachedPosition;
    long cachedLength;

    public CursorFrameRowPointer(Frame frame, ReadableOffset offset) {
        this.frame = FrameType.ROW_BASED.ensureType(frame);
        this.offset = (ReadableOffset)Preconditions.checkNotNull((Object)offset, (Object)"offset");
        this.rowPositions = frame.region(0);
    }

    @Override
    public long position() {
        this.update();
        return this.cachedPosition;
    }

    @Override
    public long length() {
        this.update();
        return this.cachedLength;
    }

    private void update() {
        int rowNumber = this.offset.getOffset();
        if (this.cachedOffset != rowNumber) {
            int physicalRowNumber = this.frame.physicalRow(this.offset.getOffset());
            long rowEndPosition = this.rowPositions.getLong(8L * (long)physicalRowNumber);
            long rowPosition = physicalRowNumber == 0 ? 0L : this.rowPositions.getLong(8L * (long)(physicalRowNumber - 1));
            this.cachedOffset = rowNumber;
            this.cachedPosition = rowPosition;
            this.cachedLength = rowEndPosition - rowPosition;
        }
    }
}

