/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.key;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.datasketches.memory.Memory;
import org.apache.druid.error.DruidException;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.FrameType;
import org.apache.druid.frame.field.FieldReader;
import org.apache.druid.frame.key.ByteRowKeyComparator;
import org.apache.druid.frame.key.FrameComparisonWidget;
import org.apache.druid.frame.key.KeyColumn;
import org.apache.druid.frame.key.KeyOrder;
import org.apache.druid.frame.key.RowKey;
import org.apache.druid.frame.key.RowKeyComparisonRunLengths;
import org.apache.druid.frame.key.RowKeyReader;
import org.apache.druid.frame.key.RunLengthEntry;
import org.apache.druid.frame.read.FrameReaderUtils;
import org.apache.druid.frame.write.FrameWriterUtils;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.serde.ComplexMetricSerde;
import org.apache.druid.segment.serde.ComplexMetrics;

@NotThreadSafe
public class FrameComparisonWidgetImpl
implements FrameComparisonWidget {
    private final Frame frame;
    private final RowSignature signature;
    private final Memory rowOffsetRegion;
    private final Memory dataRegion;
    private final int keyFieldCount;
    private final List<FieldReader> keyFieldReaders;
    private final int firstFieldPosition;
    private final RowKeyComparisonRunLengths rowKeyComparisonRunLengths;
    private final ComplexMetricSerde[] complexMetricSerdes;
    private final ColumnType[] columnTypes;

    private FrameComparisonWidgetImpl(Frame frame, RowSignature signature, Memory rowOffsetRegion, Memory dataRegion, List<FieldReader> keyFieldReaders, int firstFieldPosition, RowKeyComparisonRunLengths rowKeyComparisonRunLengths, ComplexMetricSerde[] complexMetricSerdes, ColumnType[] columnTypes) {
        this.frame = frame;
        this.signature = signature;
        this.rowOffsetRegion = rowOffsetRegion;
        this.dataRegion = dataRegion;
        this.keyFieldCount = keyFieldReaders.size();
        this.keyFieldReaders = keyFieldReaders;
        this.firstFieldPosition = firstFieldPosition;
        this.rowKeyComparisonRunLengths = rowKeyComparisonRunLengths;
        this.complexMetricSerdes = complexMetricSerdes;
        this.columnTypes = columnTypes;
    }

    public static FrameComparisonWidgetImpl create(Frame frame, RowSignature signature, List<KeyColumn> keyColumns, List<FieldReader> keyColumnReaders) {
        FrameWriterUtils.verifySortColumns(keyColumns, signature);
        if (keyColumnReaders.size() != keyColumns.size()) {
            throw new ISE("Mismatched lengths for keyColumnReaders and keyColumns", new Object[0]);
        }
        RowKeyComparisonRunLengths rowKeyComparisonRunLengths = RowKeyComparisonRunLengths.create(keyColumns, signature);
        RunLengthEntry[] runLengthEntries = rowKeyComparisonRunLengths.getRunLengthEntries();
        ComplexMetricSerde[] complexMetricSerdes = new ComplexMetricSerde[runLengthEntries.length];
        ColumnType[] columnTypes = new ColumnType[runLengthEntries.length];
        int fieldsSeenSoFar = 0;
        for (int i = 0; i < runLengthEntries.length; ++i) {
            if (runLengthEntries[i].isByteComparable()) {
                complexMetricSerdes[i] = null;
                columnTypes[i] = null;
            } else {
                String columnName = keyColumns.get(fieldsSeenSoFar).columnName();
                ColumnType columnType = signature.getColumnType(columnName).orElse(null);
                if (columnType == null) {
                    throw DruidException.defensive("Cannot compare on the byte incomparable column [%s] without knowing it's type", columnName);
                }
                String complexTypeName = columnType.getComplexTypeName();
                if (complexTypeName == null) {
                    throw DruidException.defensive("Expected complex type name for column [%s] for comparison", columnName);
                }
                complexMetricSerdes[i] = (ComplexMetricSerde)Preconditions.checkNotNull((Object)ComplexMetrics.getSerdeForType(complexTypeName), (String)"Cannot find serde for column [%s] of type [%s]", (Object)columnName, (Object)complexTypeName);
                columnTypes[i] = columnType;
            }
            fieldsSeenSoFar += runLengthEntries[i].getRunLength();
        }
        return new FrameComparisonWidgetImpl(FrameType.ROW_BASED.ensureType(frame), signature, frame.region(0), frame.region(1), keyColumnReaders, ByteRowKeyComparator.computeFirstFieldPosition(signature.size()), rowKeyComparisonRunLengths, complexMetricSerdes, columnTypes);
    }

    @Override
    public RowKey readKey(int row) {
        int i;
        if (this.keyFieldCount == 0) {
            return RowKey.empty();
        }
        int keyFieldPointersEndInRow = this.keyFieldCount * 4;
        long rowPosition = this.getRowPositionInDataRegion(row);
        int keyEndInRow = this.dataRegion.getInt(rowPosition + (long)(this.keyFieldCount - 1) * 4L);
        long keyLength = keyEndInRow - this.firstFieldPosition;
        byte[] keyBytes = new byte[Ints.checkedCast((long)(keyFieldPointersEndInRow + keyEndInRow - this.firstFieldPosition))];
        int headerSizeAdjustment = (this.signature.size() - this.keyFieldCount) * 4;
        for (i = 0; i < this.keyFieldCount; ++i) {
            int fieldEndPosition = this.dataRegion.getInt(rowPosition + 4L * (long)i);
            int adjustedFieldEndPosition = fieldEndPosition - headerSizeAdjustment;
            keyBytes[4 * i] = (byte)adjustedFieldEndPosition;
            keyBytes[4 * i + 1] = (byte)(adjustedFieldEndPosition >> 8);
            keyBytes[4 * i + 2] = (byte)(adjustedFieldEndPosition >> 16);
            keyBytes[4 * i + 3] = (byte)(adjustedFieldEndPosition >> 24);
        }
        i = 0;
        while ((long)i < keyLength) {
            keyBytes[keyFieldPointersEndInRow + i] = this.dataRegion.getByte(rowPosition + (long)this.firstFieldPosition + (long)i);
            ++i;
        }
        return RowKey.wrap(keyBytes);
    }

    @Override
    public boolean hasNonNullKeyParts(int row, int[] keyParts) {
        if (keyParts.length == 0) {
            return true;
        }
        long rowPosition = this.getRowPositionInDataRegion(row);
        for (int i : keyParts) {
            if (i < 0 || i >= this.keyFieldCount) {
                throw new IAE("Invalid key part[%d]", i);
            }
            long keyFieldPosition = i == 0 ? rowPosition + (long)this.signature.size() * 4L : rowPosition + (long)this.dataRegion.getInt(rowPosition + (long)(i - 1) * 4L);
            if (!this.keyFieldReaders.get(i).isNull(this.dataRegion, keyFieldPosition)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compare(int row, RowKey key) {
        byte[] keyArray = key.array();
        long rowPosition = this.getRowPositionInDataRegion(row);
        long comparableBytesStartPositionInRow = this.firstFieldPosition;
        int comparableBytesStartPositionInKey = 4 * this.keyFieldCount;
        int fieldsComparedTillNow = 0;
        for (int i = 0; i < this.rowKeyComparisonRunLengths.getRunLengthEntries().length; ++i) {
            int cmp;
            RunLengthEntry runLengthEntry = this.rowKeyComparisonRunLengths.getRunLengthEntries()[i];
            if (runLengthEntry.getRunLength() <= 0) continue;
            int nextField = fieldsComparedTillNow + runLengthEntry.getRunLength();
            int comparableBytesEndPositionInKey = RowKeyReader.fieldEndPosition(keyArray, nextField - 1);
            int comparableBytesEndPositionInRow = this.getFieldEndPositionInRow(rowPosition, nextField - 1);
            if (!runLengthEntry.isByteComparable()) {
                assert (runLengthEntry.getRunLength() == 1);
                cmp = FrameReaderUtils.compareComplexTypes(this.dataRegion, rowPosition + comparableBytesStartPositionInRow, keyArray, comparableBytesStartPositionInKey, this.columnTypes[i], this.complexMetricSerdes[i]);
            } else {
                cmp = FrameReaderUtils.compareMemoryToByteArrayUnsigned(this.dataRegion, rowPosition + comparableBytesStartPositionInRow, (long)comparableBytesEndPositionInRow - comparableBytesStartPositionInRow, keyArray, comparableBytesStartPositionInKey, comparableBytesEndPositionInKey - comparableBytesStartPositionInKey);
            }
            if (cmp != 0) {
                return runLengthEntry.getOrder() == KeyOrder.ASCENDING ? cmp : -cmp;
            }
            fieldsComparedTillNow = nextField;
            comparableBytesStartPositionInRow = comparableBytesEndPositionInRow;
            comparableBytesStartPositionInKey = comparableBytesEndPositionInKey;
        }
        return 0;
    }

    @Override
    public int compare(int row, FrameComparisonWidget otherWidget, int otherRow) {
        FrameComparisonWidgetImpl otherWidgetImpl = (FrameComparisonWidgetImpl)otherWidget;
        long rowPosition = this.getRowPositionInDataRegion(row);
        long otherRowPosition = otherWidgetImpl.getRowPositionInDataRegion(otherRow);
        int comparableBytesStartPositionInRow = this.firstFieldPosition;
        int otherComparableBytesStartPositionInRow = otherWidgetImpl.firstFieldPosition;
        int fieldsComparedTillNow = 0;
        for (int i = 0; i < this.rowKeyComparisonRunLengths.getRunLengthEntries().length; ++i) {
            int cmp;
            RunLengthEntry runLengthEntry = this.rowKeyComparisonRunLengths.getRunLengthEntries()[i];
            if (runLengthEntry.getRunLength() <= 0) continue;
            int nextField = fieldsComparedTillNow + runLengthEntry.getRunLength();
            int comparableBytesEndPositionInRow = this.getFieldEndPositionInRow(rowPosition, nextField - 1);
            int otherComparableBytesEndPositionInRow = otherWidgetImpl.getFieldEndPositionInRow(otherRowPosition, nextField - 1);
            if (!runLengthEntry.isByteComparable()) {
                assert (runLengthEntry.getRunLength() == 1);
                cmp = FrameReaderUtils.compareComplexTypes(this.dataRegion, rowPosition + (long)comparableBytesStartPositionInRow, otherWidgetImpl.dataRegion, otherRowPosition + (long)otherComparableBytesStartPositionInRow, this.columnTypes[i], this.complexMetricSerdes[i]);
            } else {
                cmp = FrameReaderUtils.compareMemoryUnsigned(this.dataRegion, rowPosition + (long)comparableBytesStartPositionInRow, comparableBytesEndPositionInRow - comparableBytesStartPositionInRow, otherWidgetImpl.getDataRegion(), otherRowPosition + (long)otherComparableBytesStartPositionInRow, otherComparableBytesEndPositionInRow - otherComparableBytesStartPositionInRow);
            }
            if (cmp != 0) {
                return runLengthEntry.getOrder() == KeyOrder.ASCENDING ? cmp : -cmp;
            }
            fieldsComparedTillNow = nextField;
            comparableBytesStartPositionInRow = comparableBytesEndPositionInRow;
            otherComparableBytesStartPositionInRow = otherComparableBytesEndPositionInRow;
        }
        return 0;
    }

    long getRowPositionInDataRegion(int logicalRow) {
        int physicalRowNumber = this.frame.physicalRow(logicalRow);
        if (physicalRowNumber == 0) {
            return 0L;
        }
        return this.rowOffsetRegion.getLong(8L * (long)(physicalRowNumber - 1));
    }

    int getFieldEndPositionInRow(long rowPosition, int fieldNumber) {
        assert (fieldNumber >= 0 && fieldNumber < this.signature.size());
        return this.dataRegion.getInt(rowPosition + (long)fieldNumber * 4L);
    }

    Memory getDataRegion() {
        return this.dataRegion;
    }
}

