/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.field;

import org.apache.datasketches.memory.WritableMemory;
import org.apache.druid.frame.field.NumericFieldWriter;
import org.apache.druid.frame.field.TransformUtils;
import org.apache.druid.segment.BaseFloatColumnValueSelector;

public class FloatFieldWriter
extends NumericFieldWriter {
    private final BaseFloatColumnValueSelector selector;

    public static FloatFieldWriter forPrimitive(BaseFloatColumnValueSelector selector) {
        return new FloatFieldWriter(selector, false);
    }

    public static FloatFieldWriter forArray(BaseFloatColumnValueSelector selector) {
        return new FloatFieldWriter(selector, true);
    }

    private FloatFieldWriter(BaseFloatColumnValueSelector selector, boolean forArray) {
        super(selector, forArray);
        this.selector = selector;
    }

    @Override
    public void close() {
    }

    @Override
    public int getNumericSizeBytes() {
        return 4;
    }

    @Override
    public void writeSelectorToMemory(WritableMemory memory, long position) {
        this.writeToMemory(memory, position, this.selector.getFloat());
    }

    @Override
    public void writeNullToMemory(WritableMemory memory, long position) {
        this.writeToMemory(memory, position, 0.0f);
    }

    private void writeToMemory(WritableMemory memory, long position, float value) {
        memory.putInt(position, TransformUtils.transformFromFloat(value));
    }
}

