/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.autoscaling.ec2;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.indexing.overlord.autoscaling.ec2.EC2UserData;
import org.apache.druid.java.util.common.StringUtils;

public class GalaxyEC2UserData
implements EC2UserData<GalaxyEC2UserData> {
    private final ObjectMapper jsonMapper;
    private final String env;
    private final String version;
    private final String type;

    @JsonCreator
    public GalaxyEC2UserData(@JacksonInject @Json ObjectMapper jsonMapper, @JsonProperty(value="env") String env, @JsonProperty(value="version") String version, @JsonProperty(value="type") String type) {
        this.jsonMapper = jsonMapper;
        this.env = env;
        this.version = version;
        this.type = type;
    }

    @JsonProperty
    public String getEnv() {
        return this.env;
    }

    @JsonProperty
    public String getVersion() {
        return this.version;
    }

    @JsonProperty
    public String getType() {
        return this.type;
    }

    public GalaxyEC2UserData withVersion(String ver) {
        return new GalaxyEC2UserData(this.jsonMapper, this.env, ver, this.type);
    }

    @Override
    public String getUserDataBase64() {
        try {
            return StringUtils.encodeBase64String((byte[])this.jsonMapper.writeValueAsBytes((Object)this));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GalaxyEC2UserData that = (GalaxyEC2UserData)o;
        if (this.env != null ? !this.env.equals(that.env) : that.env != null) {
            return false;
        }
        if (this.jsonMapper != null ? !this.jsonMapper.equals(that.jsonMapper) : that.jsonMapper != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        return !(this.version != null ? !this.version.equals(that.version) : that.version != null);
    }

    public int hashCode() {
        int result = this.jsonMapper != null ? this.jsonMapper.hashCode() : 0;
        result = 31 * result + (this.env != null ? this.env.hashCode() : 0);
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "GalaxyUserData{env='" + this.env + "', version='" + this.version + "', type='" + this.type + "'}";
    }
}

