/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.lookup.namespace.cache;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.google.inject.Inject;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.druid.concurrent.ConcurrentAwaitableCounter;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.java.util.common.Cleaners;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceEventBuilder;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.query.lookup.LookupExtractor;
import org.apache.druid.query.lookup.namespace.CacheGenerator;
import org.apache.druid.query.lookup.namespace.ExtractionNamespace;
import org.apache.druid.server.lookup.namespace.cache.CacheHandler;
import org.apache.druid.server.lookup.namespace.cache.NamespaceExtractionCacheManager;

@LazySingleton
public final class CacheScheduler {
    private static final Logger log = new Logger(CacheScheduler.class);
    private final Map<Class<? extends ExtractionNamespace>, CacheGenerator<?>> namespaceGeneratorMap;
    private final NamespaceExtractionCacheManager cacheManager;
    private final AtomicLong updatesStarted = new AtomicLong(0L);
    private final AtomicInteger activeEntries = new AtomicInteger();

    @Inject
    public CacheScheduler(final ServiceEmitter serviceEmitter, Map<Class<? extends ExtractionNamespace>, CacheGenerator<?>> namespaceGeneratorMap, NamespaceExtractionCacheManager cacheManager) {
        this.namespaceGeneratorMap = new IdentityHashMap(namespaceGeneratorMap);
        this.cacheManager = cacheManager;
        cacheManager.scheduledExecutorService().scheduleAtFixedRate(new Runnable(){
            long priorUpdatesStarted = 0L;

            @Override
            public void run() {
                block2: {
                    try {
                        long tasks = CacheScheduler.this.updatesStarted.get();
                        serviceEmitter.emit((ServiceEventBuilder)ServiceMetricEvent.builder().setMetric("namespace/deltaTasksStarted", (Number)(tasks - this.priorUpdatesStarted)));
                        this.priorUpdatesStarted = tasks;
                    }
                    catch (Exception e) {
                        log.error((Throwable)e, "Error emitting namespace stats", new Object[0]);
                        if (!Thread.currentThread().isInterrupted()) break block2;
                        throw new RuntimeException(e);
                    }
                }
            }
        }, 1L, 10L, TimeUnit.MINUTES);
    }

    @VisibleForTesting
    long updatesStarted() {
        return this.updatesStarted.get();
    }

    @VisibleForTesting
    public long getActiveEntries() {
        return this.activeEntries.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Entry scheduleAndWait(ExtractionNamespace namespace, long waitForFirstRunMs) throws InterruptedException {
        Entry entry;
        block11: {
            Entry entry2;
            block12: {
                boolean success;
                Exception loadException;
                block8: {
                    Entry entry3;
                    block9: {
                        block10: {
                            loadException = null;
                            entry2 = this.schedule(namespace);
                            log.debug("Scheduled new %s", new Object[]{entry2});
                            success = false;
                            success = entry2.impl.firstLoadFinishedSuccessfully.get(waitForFirstRunMs, TimeUnit.MILLISECONDS);
                            if (!success) break block8;
                            entry3 = entry2;
                            if (success) break block9;
                            entry2.close();
                            if (loadException == null) break block10;
                            log.error((Throwable)loadException, "CacheScheduler[%s] - problem during start or waiting for the first run", new Object[]{entry2});
                            break block9;
                        }
                        log.error("CacheScheduler[%s] - problem during start or waiting for the first run", new Object[]{entry2});
                    }
                    return entry3;
                }
                try {
                    entry = null;
                    if (success) break block11;
                    entry2.close();
                    if (loadException == null) break block12;
                }
                catch (ExecutionException | TimeoutException e) {
                    Entry entry4;
                    block13: {
                        block14: {
                            try {
                                loadException = e;
                                entry4 = null;
                                if (success) break block13;
                                entry2.close();
                                if (loadException == null) break block14;
                            }
                            catch (Throwable throwable) {
                                if (!success) {
                                    entry2.close();
                                    if (loadException != null) {
                                        log.error((Throwable)loadException, "CacheScheduler[%s] - problem during start or waiting for the first run", new Object[]{entry2});
                                    } else {
                                        log.error("CacheScheduler[%s] - problem during start or waiting for the first run", new Object[]{entry2});
                                    }
                                }
                                throw throwable;
                            }
                            log.error((Throwable)loadException, "CacheScheduler[%s] - problem during start or waiting for the first run", new Object[]{entry2});
                            break block13;
                        }
                        log.error("CacheScheduler[%s] - problem during start or waiting for the first run", new Object[]{entry2});
                    }
                    return entry4;
                }
                log.error((Throwable)loadException, "CacheScheduler[%s] - problem during start or waiting for the first run", new Object[]{entry2});
                break block11;
            }
            log.error("CacheScheduler[%s] - problem during start or waiting for the first run", new Object[]{entry2});
        }
        return entry;
    }

    public <T extends ExtractionNamespace> Entry schedule(T namespace) {
        CacheGenerator<?> generator = this.namespaceGeneratorMap.get(namespace.getClass());
        if (generator == null) {
            throw new ISE("Cannot find generator for namespace [%s]", new Object[]{namespace});
        }
        return new Entry(this, namespace, generator);
    }

    public static final class VersionedCache
    implements CacheState,
    AutoCloseable {
        final String entryId;
        final CacheHandler cacheHandler;
        final String version;

        private VersionedCache(String entryId, String version, CacheHandler cache) {
            this.entryId = entryId;
            this.cacheHandler = cache;
            this.version = version;
        }

        public Map<String, String> getCache() {
            return this.cacheHandler.getCache();
        }

        public LookupExtractor asLookupExtractor(boolean isOneToOne, Supplier<byte[]> cacheKeySupplier) {
            return this.cacheHandler.asLookupExtractor(isOneToOne, cacheKeySupplier);
        }

        public String getVersion() {
            return this.version;
        }

        @Override
        public void close() {
            this.cacheHandler.close();
            log.debug("Closed version [%s] of %s", new Object[]{this.version, this.entryId});
        }
    }

    public static enum NoCache implements CacheState
    {
        CACHE_NOT_INITIALIZED,
        ENTRY_CLOSED;

    }

    public static interface CacheState {
    }

    public static class EntryImpl<T extends ExtractionNamespace>
    implements AutoCloseable {
        private final T namespace;
        private final String asString;
        private final AtomicReference<CacheState> cacheStateHolder = new AtomicReference<NoCache>(NoCache.CACHE_NOT_INITIALIZED);
        private final Future<?> updaterFuture;
        private final Cleaners.Cleanable entryCleanable;
        private final CacheGenerator<T> cacheGenerator;
        private final ConcurrentAwaitableCounter updateCounter = new ConcurrentAwaitableCounter();
        private final CountDownLatch startLatch = new CountDownLatch(1);
        private final CompletableFuture<Boolean> firstLoadFinishedSuccessfully = new CompletableFuture();
        final /* synthetic */ CacheScheduler this$0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private EntryImpl(T namespace, Entry<T> entry, CacheGenerator<T> cacheGenerator) {
            this.this$0 = this$0;
            try {
                this.namespace = namespace;
                this.asString = StringUtils.format((String)"namespace [%s] : %s", (Object[])new Object[]{namespace, super.toString()});
                this.updaterFuture = this.schedule(namespace);
                this.entryCleanable = this.createCleaner(entry);
                this.cacheGenerator = cacheGenerator;
                this$0.activeEntries.incrementAndGet();
            }
            finally {
                this.startLatch.countDown();
            }
        }

        private Cleaners.Cleanable createCleaner(Entry<T> entry) {
            return Cleaners.register(entry, this::closeFromCleaner);
        }

        private Future<?> schedule(T namespace) {
            long updateMs = namespace.getPollMs();
            Runnable command = this::updateCache;
            if (updateMs > 0L) {
                return this.this$0.cacheManager.scheduledExecutorService().scheduleAtFixedRate(command, namespace.getJitterMills(), updateMs, TimeUnit.MILLISECONDS);
            }
            return this.this$0.cacheManager.scheduledExecutorService().schedule(command, namespace.getJitterMills(), TimeUnit.MILLISECONDS);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateCache() {
            boolean updatedCacheSuccessfully = false;
            try {
                this.startLatch.await();
                CacheState currentCacheState = this.cacheStateHolder.get();
                if (!Thread.currentThread().isInterrupted() && currentCacheState != NoCache.ENTRY_CLOSED) {
                    String currentVersion = this.currentVersionOrNull(currentCacheState);
                    updatedCacheSuccessfully = this.tryUpdateCache(currentVersion);
                }
            }
            catch (Throwable t) {
                try {
                    this.close();
                }
                catch (Exception e) {
                    t.addSuppressed(e);
                }
                if (Thread.currentThread().isInterrupted() || t instanceof InterruptedException || t instanceof Error) {
                    throw new RuntimeException(t);
                }
            }
            finally {
                if (!this.firstLoadFinishedSuccessfully.isDone()) {
                    this.firstLoadFinishedSuccessfully.complete(updatedCacheSuccessfully);
                }
            }
        }

        private boolean tryUpdateCache(String currentVersion) throws Exception {
            boolean updatedCacheSuccessfully;
            block10: {
                updatedCacheSuccessfully = false;
                CacheHandler newCache = null;
                try {
                    this.this$0.updatesStarted.incrementAndGet();
                    newCache = this.this$0.cacheManager.allocateCache();
                    String newVersion = this.cacheGenerator.generateCache(this.namespace, this, currentVersion, newCache);
                    if (newVersion != null) {
                        newCache = this.this$0.cacheManager.attachCache(newCache);
                        VersionedCache newVersionedCache = new VersionedCache(String.valueOf(this), newVersion, newCache);
                        CacheState previousCacheState = this.swapCacheState(newVersionedCache);
                        if (previousCacheState != NoCache.ENTRY_CLOSED) {
                            updatedCacheSuccessfully = true;
                            if (previousCacheState instanceof VersionedCache) {
                                ((VersionedCache)previousCacheState).close();
                            }
                            log.debug("%s: the cache was successfully updated", new Object[]{this});
                        } else {
                            newVersionedCache.close();
                            log.debug("%s was closed while the cache was being updated, discarding the update", new Object[]{this});
                        }
                    } else {
                        log.debug("%s: Version `%s` not updated, the cache is not updated", new Object[]{this, currentVersion});
                    }
                }
                catch (Throwable t) {
                    try {
                        if (newCache != null && !updatedCacheSuccessfully) {
                            newCache.close();
                        }
                        log.error(t, "Failed to update %s", new Object[]{this});
                    }
                    catch (Exception e) {
                        t.addSuppressed(e);
                    }
                    if (!Thread.currentThread().isInterrupted() && !(t instanceof InterruptedException) && !(t instanceof Error)) break block10;
                    throw t;
                }
            }
            return updatedCacheSuccessfully;
        }

        private String currentVersionOrNull(CacheState currentCacheState) {
            if (currentCacheState instanceof VersionedCache) {
                return ((VersionedCache)currentCacheState).version;
            }
            return null;
        }

        private CacheState swapCacheState(VersionedCache newVersionedCache) {
            CacheState lastCacheState;
            do {
                if ((lastCacheState = this.cacheStateHolder.get()) != NoCache.ENTRY_CLOSED) continue;
                return lastCacheState;
            } while (!this.cacheStateHolder.compareAndSet(lastCacheState, newVersionedCache));
            this.updateCounter.increment();
            return lastCacheState;
        }

        @Override
        public void close() {
            if (!this.doClose(true)) {
                log.error("Cache for %s has already been closed", new Object[]{this});
            }
            this.entryCleanable.clean();
        }

        private void closeFromCleaner() {
            try {
                if (this.doClose(false)) {
                    log.error("Entry.close() was not called, closed resources by the JVM", new Object[0]);
                }
            }
            catch (Throwable t) {
                try {
                    log.error(t, "Error while closing %s", new Object[]{this});
                }
                catch (Exception e) {
                    t.addSuppressed(e);
                }
                Throwables.propagateIfInstanceOf((Throwable)t, Error.class);
            }
        }

        private boolean doClose(boolean calledManually) {
            CacheState lastCacheState = this.cacheStateHolder.getAndSet(NoCache.ENTRY_CLOSED);
            if (lastCacheState != NoCache.ENTRY_CLOSED) {
                try {
                    log.info("Closing %s", new Object[]{this});
                    this.logExecutionError();
                }
                finally {
                    this.this$0.activeEntries.decrementAndGet();
                    this.updaterFuture.cancel(true);
                    if (calledManually && lastCacheState instanceof VersionedCache) {
                        ((VersionedCache)lastCacheState).cacheHandler.close();
                    }
                }
                return true;
            }
            return false;
        }

        private void logExecutionError() {
            if (this.updaterFuture.isDone()) {
                try {
                    this.updaterFuture.get();
                }
                catch (ExecutionException ee) {
                    log.error(ee.getCause(), "Error in %s", new Object[]{this});
                }
                catch (CancellationException ce) {
                    log.error((Throwable)ce, "Future for %s has already been cancelled", new Object[]{this});
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(ie);
                }
            }
        }

        public String toString() {
            return this.asString;
        }
    }

    public static final class Entry<T extends ExtractionNamespace>
    implements AutoCloseable {
        private final EntryImpl<T> impl;
        final /* synthetic */ CacheScheduler this$0;

        private Entry(T namespace, CacheGenerator<T> cacheGenerator) {
            this.this$0 = this$0;
            this.impl = new EntryImpl((CacheScheduler)this$0, namespace, this, cacheGenerator);
        }

        public CacheState getCacheState() {
            return this.impl.cacheStateHolder.get();
        }

        public Map<String, String> getCache() {
            CacheState cacheState = this.getCacheState();
            if (cacheState instanceof VersionedCache) {
                return ((VersionedCache)cacheState).getCache();
            }
            throw new ISE("Cannot get cache: %s", new Object[]{cacheState});
        }

        @VisibleForTesting
        Future<?> getUpdaterFuture() {
            return this.impl.updaterFuture;
        }

        @VisibleForTesting
        public void awaitTotalUpdates(int totalUpdates) throws InterruptedException {
            this.impl.updateCounter.awaitCount((long)totalUpdates);
        }

        @VisibleForTesting
        public void awaitTotalUpdatesWithTimeout(int totalUpdates, long timeoutMills) throws InterruptedException, TimeoutException {
            this.impl.updateCounter.awaitCount((long)totalUpdates, timeoutMills, TimeUnit.MILLISECONDS);
        }

        @VisibleForTesting
        void awaitNextUpdates(int nextUpdates) throws InterruptedException {
            this.impl.updateCounter.awaitNextIncrements((long)nextUpdates);
        }

        @Override
        public void close() {
            this.impl.close();
        }

        public String toString() {
            return this.impl.toString();
        }
    }
}

