/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.kafka;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.druid.common.utils.IdUtils;
import org.apache.druid.data.input.kafka.KafkaRecordEntity;
import org.apache.druid.data.input.kafka.KafkaTopicPartition;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.InvalidInput;
import org.apache.druid.indexing.kafka.KafkaConsumerConfigs;
import org.apache.druid.indexing.kafka.KafkaConsumerMonitor;
import org.apache.druid.indexing.kafka.KafkaSequenceNumber;
import org.apache.druid.indexing.seekablestream.common.OrderedPartitionableRecord;
import org.apache.druid.indexing.seekablestream.common.OrderedSequenceNumber;
import org.apache.druid.indexing.seekablestream.common.RecordSupplier;
import org.apache.druid.indexing.seekablestream.common.StreamException;
import org.apache.druid.indexing.seekablestream.common.StreamPartition;
import org.apache.druid.indexing.seekablestream.extension.KafkaConfigOverrides;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.metrics.Monitor;
import org.apache.druid.metadata.DynamicConfigProvider;
import org.apache.druid.metadata.PasswordProvider;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.Deserializer;

public class KafkaRecordSupplier
implements RecordSupplier<KafkaTopicPartition, Long, KafkaRecordEntity> {
    private final KafkaConsumer<byte[], byte[]> consumer;
    private final KafkaConsumerMonitor monitor;
    private boolean closed;
    private final boolean multiTopic;
    private String stream;

    public KafkaRecordSupplier(Map<String, Object> consumerProperties, ObjectMapper sortingMapper, KafkaConfigOverrides configOverrides, boolean multiTopic) {
        this(KafkaRecordSupplier.getKafkaConsumer(sortingMapper, consumerProperties, configOverrides), multiTopic);
    }

    @VisibleForTesting
    public KafkaRecordSupplier(KafkaConsumer<byte[], byte[]> consumer, boolean multiTopic) {
        this.consumer = consumer;
        this.multiTopic = multiTopic;
        this.monitor = new KafkaConsumerMonitor(consumer);
    }

    public void assign(Set<StreamPartition<KafkaTopicPartition>> streamPartitions) {
        if (streamPartitions.isEmpty()) {
            KafkaRecordSupplier.wrapExceptions(() -> this.consumer.assign(Collections.emptyList()));
            return;
        }
        Set streams = streamPartitions.stream().map(StreamPartition::getStream).collect(Collectors.toSet());
        if (streams.size() > 1) {
            throw InvalidInput.exception((String)"[%s] streams found. Only one stream is supported.", (Object[])new Object[]{streams});
        }
        this.stream = (String)streams.iterator().next();
        KafkaRecordSupplier.wrapExceptions(() -> this.consumer.assign((Collection)streamPartitions.stream().map(x -> ((KafkaTopicPartition)x.getPartitionId()).asTopicPartition(x.getStream())).collect(Collectors.toSet())));
    }

    public void seek(StreamPartition<KafkaTopicPartition> partition, Long sequenceNumber) {
        KafkaRecordSupplier.wrapExceptions(() -> this.consumer.seek(((KafkaTopicPartition)partition.getPartitionId()).asTopicPartition(partition.getStream()), sequenceNumber.longValue()));
    }

    public void seekToEarliest(Set<StreamPartition<KafkaTopicPartition>> partitions) {
        KafkaRecordSupplier.wrapExceptions(() -> this.consumer.seekToBeginning((Collection)partitions.stream().map(e -> ((KafkaTopicPartition)e.getPartitionId()).asTopicPartition(e.getStream())).collect(Collectors.toList())));
    }

    public void seekToLatest(Set<StreamPartition<KafkaTopicPartition>> partitions) {
        KafkaRecordSupplier.wrapExceptions(() -> this.consumer.seekToEnd((Collection)partitions.stream().map(e -> ((KafkaTopicPartition)e.getPartitionId()).asTopicPartition(e.getStream())).collect(Collectors.toList())));
    }

    public Set<StreamPartition<KafkaTopicPartition>> getAssignment() {
        return KafkaRecordSupplier.wrapExceptions(() -> this.consumer.assignment().stream().map(e -> new StreamPartition(this.stream, (Object)new KafkaTopicPartition(this.multiTopic, e.topic(), e.partition()))).collect(Collectors.toSet()));
    }

    @Nonnull
    public List<OrderedPartitionableRecord<KafkaTopicPartition, Long, KafkaRecordEntity>> poll(long timeout) {
        ArrayList<OrderedPartitionableRecord<KafkaTopicPartition, Long, KafkaRecordEntity>> polledRecords = new ArrayList<OrderedPartitionableRecord<KafkaTopicPartition, Long, KafkaRecordEntity>>();
        for (ConsumerRecord record : this.consumer.poll(Duration.ofMillis(timeout))) {
            polledRecords.add((OrderedPartitionableRecord<KafkaTopicPartition, Long, KafkaRecordEntity>)new OrderedPartitionableRecord(record.topic(), (Object)new KafkaTopicPartition(this.multiTopic, record.topic(), record.partition()), (Object)record.offset(), record.value() == null ? null : ImmutableList.of((Object)((Object)new KafkaRecordEntity((ConsumerRecord<byte[], byte[]>)record)))));
        }
        return polledRecords;
    }

    public Long getLatestSequenceNumber(StreamPartition<KafkaTopicPartition> partition) {
        Object currPos = this.getPosition((StreamPartition)partition);
        this.seekToLatest(Collections.singleton(partition));
        Object nextPos = this.getPosition((StreamPartition)partition);
        this.seek(partition, (Long)currPos);
        return nextPos;
    }

    public Long getEarliestSequenceNumber(StreamPartition<KafkaTopicPartition> partition) {
        Object currPos = this.getPosition((StreamPartition)partition);
        this.seekToEarliest(Collections.singleton(partition));
        Object nextPos = this.getPosition((StreamPartition)partition);
        this.seek(partition, (Long)currPos);
        return nextPos;
    }

    public boolean isOffsetAvailable(StreamPartition<KafkaTopicPartition> partition, OrderedSequenceNumber<Long> offset) {
        Object earliestOffset = this.getEarliestSequenceNumber((StreamPartition)partition);
        return earliestOffset != null && offset.isAvailableWithEarliest((OrderedSequenceNumber)KafkaSequenceNumber.of((Long)earliestOffset));
    }

    public Long getPosition(StreamPartition<KafkaTopicPartition> partition) {
        return KafkaRecordSupplier.wrapExceptions(() -> this.consumer.position(((KafkaTopicPartition)partition.getPartitionId()).asTopicPartition(partition.getStream())));
    }

    public Set<KafkaTopicPartition> getPartitionIds(String stream) {
        return KafkaRecordSupplier.wrapExceptions(() -> {
            List allPartitions;
            if (this.multiTopic) {
                Pattern pattern = Pattern.compile(stream);
                allPartitions = this.consumer.listTopics().entrySet().stream().filter(e -> pattern.matcher((CharSequence)e.getKey()).matches()).flatMap(e -> ((List)e.getValue()).stream()).collect(Collectors.toList());
                if (allPartitions.isEmpty()) {
                    throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.OPERATOR).ofCategory(DruidException.Category.INVALID_INPUT).build("No partitions found for topics that match given pattern [%s].Check that the pattern regex is correct and matching topics exists", new Object[]{stream});
                }
            } else {
                allPartitions = this.consumer.partitionsFor(stream);
                if (allPartitions == null) {
                    throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.OPERATOR).ofCategory(DruidException.Category.INVALID_INPUT).build("Topic [%s] is not found. Check that the topic exists in Kafka cluster", new Object[]{stream});
                }
            }
            return allPartitions.stream().map(p -> new KafkaTopicPartition(this.multiTopic, p.topic(), p.partition())).collect(Collectors.toSet());
        });
    }

    public Monitor monitor() {
        return this.monitor;
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.monitor.stopAfterNextEmit();
        this.consumer.close();
    }

    public static void addConsumerPropertiesFromConfig(Properties properties, ObjectMapper configMapper, Map<String, Object> consumerProperties) {
        for (Map.Entry<String, Object> entry : consumerProperties.entrySet()) {
            String propertyKey = entry.getKey();
            if ("druid.dynamic.config.provider".equals(propertyKey)) continue;
            if (propertyKey.equals("ssl.truststore.password") || propertyKey.equals("ssl.keystore.password") || propertyKey.equals("ssl.key.password")) {
                PasswordProvider configPasswordProvider = (PasswordProvider)configMapper.convertValue(entry.getValue(), PasswordProvider.class);
                properties.setProperty(propertyKey, configPasswordProvider.getPassword());
                continue;
            }
            properties.setProperty(propertyKey, String.valueOf(entry.getValue()));
        }
        Object dynamicConfigProviderJson = consumerProperties.get("druid.dynamic.config.provider");
        if (dynamicConfigProviderJson != null) {
            DynamicConfigProvider dynamicConfigProvider = (DynamicConfigProvider)configMapper.convertValue(dynamicConfigProviderJson, DynamicConfigProvider.class);
            Map dynamicConfig = dynamicConfigProvider.getConfig();
            for (Map.Entry e : dynamicConfig.entrySet()) {
                properties.setProperty((String)e.getKey(), (String)e.getValue());
            }
        }
    }

    private static Deserializer getKafkaDeserializer(Properties properties, String kafkaConfigKey, boolean isKey) {
        Deserializer deserializerObject;
        try {
            Class<?> deserializerClass = Class.forName(properties.getProperty(kafkaConfigKey, ByteArrayDeserializer.class.getTypeName()));
            Method deserializerMethod = deserializerClass.getMethod("deserialize", String.class, byte[].class);
            Type deserializerReturnType = deserializerMethod.getGenericReturnType();
            if (deserializerReturnType != byte[].class) {
                throw new IllegalArgumentException("Kafka deserializers must return a byte array (byte[]), " + deserializerClass.getName() + " returns " + deserializerReturnType.getTypeName());
            }
            deserializerObject = (Deserializer)deserializerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new StreamException((Throwable)e);
        }
        HashMap<String, String> configs = new HashMap<String, String>();
        for (String key : properties.stringPropertyNames()) {
            configs.put(key, properties.getProperty(key));
        }
        deserializerObject.configure(configs, isKey);
        return deserializerObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KafkaConsumer<byte[], byte[]> getKafkaConsumer(ObjectMapper sortingMapper, Map<String, Object> consumerProperties, KafkaConfigOverrides configOverrides) {
        Map<String, Object> consumerConfigs = KafkaConsumerConfigs.getConsumerProperties();
        Properties props = new Properties();
        Map effectiveConsumerProperties = configOverrides != null ? configOverrides.overrideConfigs(consumerProperties) : consumerProperties;
        KafkaRecordSupplier.addConsumerPropertiesFromConfig(props, sortingMapper, effectiveConsumerProperties);
        props.putIfAbsent("isolation.level", "read_committed");
        props.putIfAbsent("group.id", StringUtils.format((String)"kafka-supervisor-%s", (Object[])new Object[]{IdUtils.getRandomId()}));
        props.putAll(consumerConfigs);
        ClassLoader currCtxCl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(KafkaRecordSupplier.class.getClassLoader());
            Deserializer keyDeserializerObject = KafkaRecordSupplier.getKafkaDeserializer(props, "key.deserializer", true);
            Deserializer valueDeserializerObject = KafkaRecordSupplier.getKafkaDeserializer(props, "value.deserializer", false);
            KafkaConsumer kafkaConsumer = new KafkaConsumer(props, keyDeserializerObject, valueDeserializerObject);
            return kafkaConsumer;
        }
        finally {
            Thread.currentThread().setContextClassLoader(currCtxCl);
        }
    }

    private static <T> T wrapExceptions(Callable<T> callable) {
        try {
            return callable.call();
        }
        catch (Exception e) {
            throw new StreamException((Throwable)e);
        }
    }

    private static void wrapExceptions(Runnable runnable) {
        KafkaRecordSupplier.wrapExceptions(() -> {
            runnable.run();
            return null;
        });
    }
}

