/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.kafka;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.druid.data.input.impl.InputRowParser;
import org.apache.druid.data.input.kafka.KafkaRecordEntity;
import org.apache.druid.data.input.kafka.KafkaTopicPartition;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.task.TaskResource;
import org.apache.druid.indexing.kafka.IncrementalPublishingKafkaIndexTaskRunner;
import org.apache.druid.indexing.kafka.KafkaIndexTaskIOConfig;
import org.apache.druid.indexing.kafka.KafkaIndexTaskTuningConfig;
import org.apache.druid.indexing.kafka.KafkaRecordSupplier;
import org.apache.druid.indexing.seekablestream.SeekableStreamIndexTask;
import org.apache.druid.indexing.seekablestream.SeekableStreamIndexTaskIOConfig;
import org.apache.druid.indexing.seekablestream.SeekableStreamIndexTaskRunner;
import org.apache.druid.indexing.seekablestream.SeekableStreamIndexTaskTuningConfig;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.server.security.Action;
import org.apache.druid.server.security.Resource;
import org.apache.druid.server.security.ResourceAction;

public class KafkaIndexTask
extends SeekableStreamIndexTask<KafkaTopicPartition, Long, KafkaRecordEntity> {
    private static final String TYPE = "index_kafka";
    private final ObjectMapper configMapper;
    private long pollRetryMs = 30000L;

    @JsonCreator
    public KafkaIndexTask(@JsonProperty(value="id") String id, @JsonProperty(value="resource") TaskResource taskResource, @JsonProperty(value="dataSchema") DataSchema dataSchema, @JsonProperty(value="tuningConfig") KafkaIndexTaskTuningConfig tuningConfig, @JsonProperty(value="ioConfig") KafkaIndexTaskIOConfig ioConfig, @JsonProperty(value="context") Map<String, Object> context, @JacksonInject ObjectMapper configMapper) {
        super(KafkaIndexTask.getOrMakeId((String)id, (String)dataSchema.getDataSource(), (String)TYPE), taskResource, dataSchema, (SeekableStreamIndexTaskTuningConfig)tuningConfig, (SeekableStreamIndexTaskIOConfig)ioConfig, context, KafkaIndexTask.getFormattedGroupId((String)dataSchema.getDataSource(), (String)TYPE));
        this.configMapper = configMapper;
        Preconditions.checkArgument((boolean)ioConfig.getStartSequenceNumbers().getExclusivePartitions().isEmpty(), (Object)"All startSequenceNumbers must be inclusive");
    }

    long getPollRetryMs() {
        return this.pollRetryMs;
    }

    protected SeekableStreamIndexTaskRunner<KafkaTopicPartition, Long, KafkaRecordEntity> createTaskRunner() {
        return new IncrementalPublishingKafkaIndexTaskRunner(this, (InputRowParser<ByteBuffer>)this.dataSchema.getParser(), this.authorizerMapper, this.lockGranularityToUse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected KafkaRecordSupplier newTaskRecordSupplier(TaskToolbox toolbox) {
        ClassLoader currCtxCl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            KafkaIndexTaskIOConfig kafkaIndexTaskIOConfig = (KafkaIndexTaskIOConfig)this.ioConfig;
            HashMap<String, Object> props = new HashMap<String, Object>(kafkaIndexTaskIOConfig.getConsumerProperties());
            props.put("auto.offset.reset", "none");
            KafkaRecordSupplier recordSupplier = new KafkaRecordSupplier(props, this.configMapper, kafkaIndexTaskIOConfig.getConfigOverrides(), kafkaIndexTaskIOConfig.isMultiTopic());
            if (toolbox.getMonitorScheduler() != null) {
                toolbox.getMonitorScheduler().addMonitor(recordSupplier.monitor());
            }
            KafkaRecordSupplier kafkaRecordSupplier = recordSupplier;
            return kafkaRecordSupplier;
        }
        finally {
            Thread.currentThread().setContextClassLoader(currCtxCl);
        }
    }

    @JsonProperty
    public KafkaIndexTaskTuningConfig getTuningConfig() {
        return (KafkaIndexTaskTuningConfig)super.getTuningConfig();
    }

    @VisibleForTesting
    void setPollRetryMs(long retryMs) {
        this.pollRetryMs = retryMs;
    }

    @JsonProperty(value="ioConfig")
    public KafkaIndexTaskIOConfig getIOConfig() {
        return (KafkaIndexTaskIOConfig)super.getIOConfig();
    }

    public String getType() {
        return TYPE;
    }

    @Nonnull
    @JsonIgnore
    public Set<ResourceAction> getInputSourceResources() {
        return Collections.singleton(new ResourceAction(new Resource("kafka", "EXTERNAL"), Action.READ));
    }

    public boolean supportsQueries() {
        return true;
    }
}

