/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.seekablestream.common;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.apache.druid.data.input.impl.ByteEntity;
import org.apache.druid.indexing.seekablestream.common.StreamPartition;

public class OrderedPartitionableRecord<PartitionIdType, SequenceOffsetType, RecordType extends ByteEntity> {
    private final String stream;
    private final PartitionIdType partitionId;
    private final SequenceOffsetType sequenceNumber;
    private final List<RecordType> data;

    public OrderedPartitionableRecord(String stream, PartitionIdType partitionId, SequenceOffsetType sequenceNumber, List<RecordType> data) {
        Preconditions.checkNotNull((Object)stream, (Object)"stream");
        Preconditions.checkNotNull(partitionId, (Object)"partitionId");
        Preconditions.checkNotNull(sequenceNumber, (Object)"sequenceNumber");
        this.stream = stream;
        this.partitionId = partitionId;
        this.sequenceNumber = sequenceNumber;
        this.data = data == null ? ImmutableList.of() : data;
    }

    public String getStream() {
        return this.stream;
    }

    public PartitionIdType getPartitionId() {
        return this.partitionId;
    }

    public SequenceOffsetType getSequenceNumber() {
        return this.sequenceNumber;
    }

    @NotNull
    public List<? extends ByteEntity> getData() {
        return this.data;
    }

    public StreamPartition<PartitionIdType> getStreamPartition() {
        return StreamPartition.of(this.stream, this.partitionId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderedPartitionableRecord that = (OrderedPartitionableRecord)o;
        if (this.data.size() != that.data.size()) {
            return false;
        }
        for (int i = 0; i < this.data.size(); ++i) {
            if (((ByteEntity)this.data.get(i)).getBuffer().equals(((ByteEntity)that.data.get(i)).getBuffer())) continue;
            return false;
        }
        return Objects.equals(this.stream, that.stream) && Objects.equals(this.partitionId, that.partitionId) && Objects.equals(this.sequenceNumber, that.sequenceNumber);
    }

    public int hashCode() {
        int hashOfData = this.data.stream().map(e -> e.getBuffer().hashCode()).collect(Collectors.toList()).hashCode();
        return Objects.hash(this.stream, this.partitionId, this.sequenceNumber, hashOfData);
    }
}

