/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.supervisor;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import javax.annotation.Nullable;
import org.apache.druid.common.guava.FutureUtils;
import org.apache.druid.error.DruidException;
import org.apache.druid.indexing.common.TaskLockType;
import org.apache.druid.indexing.overlord.DataSourceMetadata;
import org.apache.druid.indexing.overlord.supervisor.NoopSupervisorSpec;
import org.apache.druid.indexing.overlord.supervisor.StreamSupervisor;
import org.apache.druid.indexing.overlord.supervisor.Supervisor;
import org.apache.druid.indexing.overlord.supervisor.SupervisorReport;
import org.apache.druid.indexing.overlord.supervisor.SupervisorSpec;
import org.apache.druid.indexing.overlord.supervisor.SupervisorStateManager;
import org.apache.druid.indexing.overlord.supervisor.VersionedSupervisorSpec;
import org.apache.druid.indexing.overlord.supervisor.autoscaler.SupervisorTaskAutoScaler;
import org.apache.druid.indexing.seekablestream.supervisor.SeekableStreamSupervisor;
import org.apache.druid.indexing.seekablestream.supervisor.SeekableStreamSupervisorSpec;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.metadata.MetadataSupervisorManager;
import org.apache.druid.metadata.PendingSegmentRecord;
import org.apache.druid.query.QueryContexts;
import org.apache.druid.segment.incremental.ParseExceptionReport;

public class SupervisorManager {
    private static final EmittingLogger log = new EmittingLogger(SupervisorManager.class);
    private final MetadataSupervisorManager metadataSupervisorManager;
    private final ConcurrentHashMap<String, Pair<Supervisor, SupervisorSpec>> supervisors = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, SupervisorTaskAutoScaler> autoscalers = new ConcurrentHashMap();
    private final Object lock = new Object();
    private volatile boolean started = false;

    @Inject
    public SupervisorManager(MetadataSupervisorManager metadataSupervisorManager) {
        this.metadataSupervisorManager = metadataSupervisorManager;
    }

    public MetadataSupervisorManager getMetadataSupervisorManager() {
        return this.metadataSupervisorManager;
    }

    public Set<String> getSupervisorIds() {
        return this.supervisors.keySet();
    }

    public Optional<String> getActiveSupervisorIdForDatasourceWithAppendLock(String datasource) {
        for (Map.Entry<String, Pair<Supervisor, SupervisorSpec>> entry : this.supervisors.entrySet()) {
            SeekableStreamSupervisorSpec seekableStreamSupervisorSpec;
            Map<String, Object> context;
            String supervisorId = entry.getKey();
            Supervisor supervisor = (Supervisor)entry.getValue().lhs;
            SupervisorSpec supervisorSpec = (SupervisorSpec)entry.getValue().rhs;
            boolean hasAppendLock = false;
            if (supervisorSpec instanceof SeekableStreamSupervisorSpec && (context = (seekableStreamSupervisorSpec = (SeekableStreamSupervisorSpec)supervisorSpec).getContext()) != null) {
                TaskLockType taskLockType;
                Boolean useConcurrentLocks = QueryContexts.getAsBoolean((String)"useConcurrentLocks", (Object)context.get("useConcurrentLocks"));
                hasAppendLock = useConcurrentLocks == null ? ((taskLockType = (TaskLockType)QueryContexts.getAsEnum((String)"taskLockType", (Object)context.get("taskLockType"), TaskLockType.class)) == null ? false : taskLockType == TaskLockType.APPEND) : useConcurrentLocks;
            }
            if (!(supervisor instanceof SeekableStreamSupervisor) || supervisorSpec.isSuspended() || !supervisorSpec.getDataSources().contains(datasource) || !hasAppendLock) continue;
            return Optional.of((Object)supervisorId);
        }
        return Optional.absent();
    }

    public Optional<SupervisorSpec> getSupervisorSpec(String id) {
        Pair<Supervisor, SupervisorSpec> supervisor = this.supervisors.get(id);
        return supervisor == null ? Optional.absent() : Optional.fromNullable((Object)((SupervisorSpec)supervisor.rhs));
    }

    public Optional<SupervisorStateManager.State> getSupervisorState(String id) {
        Pair<Supervisor, SupervisorSpec> supervisor = this.supervisors.get(id);
        return supervisor == null ? Optional.absent() : Optional.fromNullable((Object)((Supervisor)supervisor.lhs).getState());
    }

    public boolean handoffTaskGroupsEarly(String id, List<Integer> taskGroupIds) {
        Pair<Supervisor, SupervisorSpec> supervisor = this.supervisors.get(id);
        if (supervisor == null || supervisor.lhs == null) {
            return false;
        }
        StreamSupervisor streamSupervisor = this.requireStreamSupervisor(id, "handoff");
        streamSupervisor.handoffTaskGroupsEarly(taskGroupIds);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createOrUpdateAndStartSupervisor(SupervisorSpec spec) {
        Preconditions.checkState((boolean)this.started, (Object)"SupervisorManager not started");
        Preconditions.checkNotNull((Object)spec, (Object)"spec");
        Preconditions.checkNotNull((Object)spec.getId(), (Object)"spec.getId()");
        Preconditions.checkNotNull((Object)spec.getDataSources(), (Object)"spec.getDatasources()");
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkState((boolean)this.started, (Object)"SupervisorManager not started");
            this.possiblyStopAndRemoveSupervisorInternal(spec.getId(), false);
            return this.createAndStartSupervisorInternal(spec, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopAndRemoveSupervisor(String id) {
        Preconditions.checkState((boolean)this.started, (Object)"SupervisorManager not started");
        Preconditions.checkNotNull((Object)id, (Object)"id");
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkState((boolean)this.started, (Object)"SupervisorManager not started");
            return this.possiblyStopAndRemoveSupervisorInternal(id, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean suspendOrResumeSupervisor(String id, boolean suspend) {
        Preconditions.checkState((boolean)this.started, (Object)"SupervisorManager not started");
        Preconditions.checkNotNull((Object)id, (Object)"id");
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkState((boolean)this.started, (Object)"SupervisorManager not started");
            return this.possiblySuspendOrResumeSupervisorInternal(id, suspend);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStart
    public void start() {
        Preconditions.checkState((!this.started ? 1 : 0) != 0, (Object)"SupervisorManager already started");
        log.info("Loading stored supervisors from database", new Object[0]);
        Object object = this.lock;
        synchronized (object) {
            Map supervisors = this.metadataSupervisorManager.getLatest();
            for (Map.Entry supervisor : supervisors.entrySet()) {
                SupervisorSpec spec = (SupervisorSpec)supervisor.getValue();
                if (spec instanceof NoopSupervisorSpec) continue;
                try {
                    this.createAndStartSupervisorInternal(spec, false);
                }
                catch (Exception ex) {
                    log.error((Throwable)ex, "Failed to start supervisor: id [%s]", new Object[]{spec.getId()});
                }
            }
            this.started = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStop
    public void stop() {
        Preconditions.checkState((boolean)this.started, (Object)"SupervisorManager not started");
        ArrayList<ListenableFuture> stopFutures = new ArrayList<ListenableFuture>();
        Object object = this.lock;
        synchronized (object) {
            log.info("Stopping [%d] supervisors", new Object[]{((ConcurrentHashMap.CollectionView)((Object)this.supervisors.keySet())).size()});
            for (String id : this.supervisors.keySet()) {
                try {
                    stopFutures.add(((Supervisor)this.supervisors.get((Object)id).lhs).stopAsync());
                    SupervisorTaskAutoScaler autoscaler = this.autoscalers.get(id);
                    if (autoscaler == null) continue;
                    autoscaler.stop();
                }
                catch (Exception e) {
                    log.warn((Throwable)e, "Caught exception while stopping supervisor [%s]", new Object[]{id});
                }
            }
            log.info("Waiting for [%d] supervisors to shutdown", new Object[]{stopFutures.size()});
            try {
                FutureUtils.coalesce(stopFutures).get();
            }
            catch (Exception e) {
                log.warn((Throwable)e, "Stopped [%d] out of [%d] supervisors. Remaining supervisors will be killed.", new Object[]{stopFutures.stream().filter(Future::isDone).count(), stopFutures.size()});
            }
            this.supervisors.clear();
            this.autoscalers.clear();
            this.started = false;
        }
        log.info("SupervisorManager stopped.", new Object[0]);
    }

    public List<VersionedSupervisorSpec> getSupervisorHistoryForId(String id) {
        return this.metadataSupervisorManager.getAllForId(id);
    }

    public Map<String, List<VersionedSupervisorSpec>> getSupervisorHistory() {
        return this.metadataSupervisorManager.getAll();
    }

    public Optional<SupervisorReport> getSupervisorStatus(String id) {
        Pair<Supervisor, SupervisorSpec> supervisor = this.supervisors.get(id);
        return supervisor == null ? Optional.absent() : Optional.fromNullable((Object)((Supervisor)supervisor.lhs).getStatus());
    }

    public Optional<Map<String, Map<String, Object>>> getSupervisorStats(String id) {
        Pair<Supervisor, SupervisorSpec> supervisor = this.supervisors.get(id);
        return supervisor == null ? Optional.absent() : Optional.fromNullable((Object)((Supervisor)supervisor.lhs).getStats());
    }

    public Optional<List<ParseExceptionReport>> getSupervisorParseErrors(String id) {
        Pair<Supervisor, SupervisorSpec> supervisor = this.supervisors.get(id);
        return supervisor == null ? Optional.absent() : Optional.fromNullable((Object)((Supervisor)supervisor.lhs).getParseErrors());
    }

    public Optional<Boolean> isSupervisorHealthy(String id) {
        Pair<Supervisor, SupervisorSpec> supervisor = this.supervisors.get(id);
        return supervisor == null ? Optional.absent() : Optional.fromNullable((Object)((Supervisor)supervisor.lhs).isHealthy());
    }

    public boolean resetSupervisor(String id, @Nullable DataSourceMetadata resetDataSourceMetadata) {
        Preconditions.checkState((boolean)this.started, (Object)"SupervisorManager not started");
        Preconditions.checkNotNull((Object)id, (Object)"id");
        Pair<Supervisor, SupervisorSpec> supervisor = this.supervisors.get(id);
        if (supervisor == null) {
            return false;
        }
        StreamSupervisor streamSupervisor = this.requireStreamSupervisor(id, "reset");
        if (resetDataSourceMetadata == null) {
            streamSupervisor.reset(null);
        } else {
            streamSupervisor.resetOffsets(resetDataSourceMetadata);
        }
        SupervisorTaskAutoScaler autoscaler = this.autoscalers.get(id);
        if (autoscaler != null) {
            autoscaler.reset();
        }
        return true;
    }

    public boolean checkPointDataSourceMetadata(String supervisorId, int taskGroupId, DataSourceMetadata previousDataSourceMetadata) {
        try {
            Preconditions.checkState((boolean)this.started, (Object)"SupervisorManager not started");
            Preconditions.checkNotNull((Object)supervisorId, (Object)"supervisorId cannot be null");
            Pair<Supervisor, SupervisorSpec> supervisor = this.supervisors.get(supervisorId);
            Preconditions.checkNotNull(supervisor, (Object)"supervisor could not be found");
            StreamSupervisor streamSupervisor = this.requireStreamSupervisor(supervisorId, "checkPoint");
            streamSupervisor.checkpoint(taskGroupId, previousDataSourceMetadata);
            return true;
        }
        catch (Exception e) {
            log.error((Throwable)e, "Checkpoint request failed", new Object[0]);
            return false;
        }
    }

    public boolean registerUpgradedPendingSegmentOnSupervisor(String supervisorId, PendingSegmentRecord upgradedPendingSegment) {
        try {
            Preconditions.checkNotNull((Object)supervisorId, (Object)"supervisorId cannot be null");
            Preconditions.checkNotNull((Object)upgradedPendingSegment, (Object)"upgraded pending segment cannot be null");
            Preconditions.checkNotNull((Object)upgradedPendingSegment.getTaskAllocatorId(), (Object)"taskAllocatorId cannot be null");
            Preconditions.checkNotNull((Object)upgradedPendingSegment.getUpgradedFromSegmentId(), (Object)"upgradedFromSegmentId cannot be null");
            Pair<Supervisor, SupervisorSpec> supervisor = this.supervisors.get(supervisorId);
            Preconditions.checkNotNull(supervisor, (Object)"supervisor could not be found");
            if (!(supervisor.lhs instanceof SeekableStreamSupervisor)) {
                return false;
            }
            SeekableStreamSupervisor seekableStreamSupervisor = (SeekableStreamSupervisor)supervisor.lhs;
            seekableStreamSupervisor.registerNewVersionOfPendingSegment(upgradedPendingSegment);
            return true;
        }
        catch (Exception e) {
            log.error((Throwable)e, "Failed to upgrade pending segment[%s] to new pending segment[%s] on Supervisor[%s].", new Object[]{upgradedPendingSegment.getUpgradedFromSegmentId(), upgradedPendingSegment.getId().getVersion(), supervisorId});
            return false;
        }
    }

    private boolean possiblyStopAndRemoveSupervisorInternal(String id, boolean writeTombstone) {
        Pair<Supervisor, SupervisorSpec> pair = this.supervisors.get(id);
        if (pair == null) {
            return false;
        }
        if (writeTombstone) {
            this.metadataSupervisorManager.insert(id, (SupervisorSpec)new NoopSupervisorSpec(null, ((SupervisorSpec)pair.rhs).getDataSources()));
        }
        ((Supervisor)pair.lhs).stop(true);
        this.supervisors.remove(id);
        SupervisorTaskAutoScaler autoscler = this.autoscalers.get(id);
        if (autoscler != null) {
            autoscler.stop();
            this.autoscalers.remove(id);
        }
        return true;
    }

    private boolean possiblySuspendOrResumeSupervisorInternal(String id, boolean suspend) {
        Pair<Supervisor, SupervisorSpec> pair = this.supervisors.get(id);
        if (pair == null || ((SupervisorSpec)pair.rhs).isSuspended() == suspend) {
            return false;
        }
        SupervisorSpec nextState = suspend ? ((SupervisorSpec)pair.rhs).createSuspendedSpec() : ((SupervisorSpec)pair.rhs).createRunningSpec();
        this.possiblyStopAndRemoveSupervisorInternal(nextState.getId(), false);
        return this.createAndStartSupervisorInternal(nextState, true);
    }

    private boolean createAndStartSupervisorInternal(SupervisorSpec spec, boolean persistSpec) {
        SupervisorTaskAutoScaler autoscaler;
        Supervisor supervisor;
        String id = spec.getId();
        if (this.supervisors.containsKey(id)) {
            return false;
        }
        try {
            supervisor = spec.createSupervisor();
            autoscaler = spec.createAutoscaler(supervisor);
            supervisor.start();
            if (autoscaler != null) {
                autoscaler.start();
            }
        }
        catch (Exception e) {
            log.error("Failed to create and start supervisor: [%s]", new Object[]{spec.getId()});
            throw new RuntimeException(e);
        }
        if (persistSpec) {
            this.metadataSupervisorManager.insert(id, spec);
        }
        this.supervisors.put(id, (Pair<Supervisor, SupervisorSpec>)Pair.of((Object)supervisor, (Object)spec));
        if (autoscaler != null) {
            this.autoscalers.put(id, autoscaler);
        }
        return true;
    }

    private StreamSupervisor requireStreamSupervisor(String supervisorId, String operation) {
        Pair<Supervisor, SupervisorSpec> supervisor = this.supervisors.get(supervisorId);
        if (supervisor.lhs instanceof StreamSupervisor) {
            return (StreamSupervisor)supervisor.lhs;
        }
        throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.USER).ofCategory(DruidException.Category.UNSUPPORTED).build("Operation[%s] is not supported by supervisor[%s] of type[%s].", new Object[]{operation, supervisorId, ((SupervisorSpec)supervisor.rhs).getType()});
    }
}

