/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import java.util.List;
import java.util.Map;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.timeline.partition.BucketNumberedShardSpec;
import org.joda.time.Interval;

public class ShardSpecs {
    private final Map<Interval, List<BucketNumberedShardSpec<?>>> map;
    private final Granularity queryGranularity;

    ShardSpecs(Map<Interval, List<BucketNumberedShardSpec<?>>> map, Granularity queryGranularity) {
        this.map = map;
        this.queryGranularity = queryGranularity;
    }

    BucketNumberedShardSpec<?> getShardSpec(Interval interval, InputRow row) {
        List<BucketNumberedShardSpec<?>> shardSpecs = this.map.get(interval);
        if (shardSpecs == null || shardSpecs.isEmpty()) {
            throw new ISE("Failed to get shardSpec for interval[%s]", new Object[]{interval});
        }
        long truncatedTimestamp = this.queryGranularity.bucketStart(row.getTimestamp()).getMillis();
        return (BucketNumberedShardSpec)shardSpecs.get(0).getLookup(shardSpecs).getShardSpec(truncatedTimestamp, row);
    }
}

