/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.guice.ExtensionsConfig;
import org.apache.druid.guice.ExtensionsLoader;
import org.apache.druid.guice.StandardURLClassLoader;
import org.apache.druid.guice.StartupInjectorBuilder;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.task.AbstractBatchIndexTask;
import org.apache.druid.indexing.common.task.AbstractTask;
import org.apache.druid.indexing.common.task.HadoopIndexTask;
import org.apache.druid.indexing.common.task.Initialization;
import org.apache.druid.initialization.ServerInjectorBuilder;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.utils.JvmUtils;

public abstract class HadoopTask
extends AbstractBatchIndexTask {
    private static final Logger log = new Logger(HadoopTask.class);
    static final Injector INJECTOR = ((StartupInjectorBuilder)new StartupInjectorBuilder().forServer().add(new Module[]{ServerInjectorBuilder.registerNodeRoleModule((Set)ImmutableSet.of())})).build();
    private static final ExtensionsLoader EXTENSIONS_LOADER = ExtensionsLoader.instance((Injector)INJECTOR);
    private final List<String> hadoopDependencyCoordinates;
    protected static final Predicate<URL> IS_DRUID_URL = new Predicate<URL>(){

        public boolean apply(@Nullable URL input) {
            try {
                if (input == null) {
                    return false;
                }
                String fName = Paths.get(input.toURI()).getFileName().toString();
                return fName.startsWith("druid") && fName.endsWith(".jar") && !fName.endsWith("selfcontained.jar");
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
    };

    protected HadoopTask(String id, String dataSource, List<String> hadoopDependencyCoordinates, Map<String, Object> context) {
        super(id, dataSource, context, AbstractTask.IngestionMode.HADOOP);
        this.hadoopDependencyCoordinates = hadoopDependencyCoordinates;
    }

    public List<String> getHadoopDependencyCoordinates() {
        return this.hadoopDependencyCoordinates == null ? null : ImmutableList.copyOf(this.hadoopDependencyCoordinates);
    }

    protected ClassLoader buildClassLoader(TaskToolbox toolbox) {
        return HadoopTask.buildClassLoader(this.hadoopDependencyCoordinates, toolbox.getConfig().getDefaultHadoopCoordinates());
    }

    public static ClassLoader buildClassLoader(List<String> hadoopDependencyCoordinates, List<String> defaultHadoopCoordinates) {
        String hadoopContainerDruidClasspathJars;
        List<String> finalHadoopDependencyCoordinates = hadoopDependencyCoordinates != null ? hadoopDependencyCoordinates : defaultHadoopCoordinates;
        ClassLoader taskClassLoader = HadoopIndexTask.class.getClassLoader();
        List jobURLs = taskClassLoader instanceof URLClassLoader ? Lists.newArrayList(Arrays.asList(((URLClassLoader)taskClassLoader).getURLs())) : JvmUtils.systemClassPath();
        ArrayList<URL> extensionURLs = new ArrayList<URL>();
        for (File extension : EXTENSIONS_LOADER.getExtensionFilesToLoad()) {
            StandardURLClassLoader extensionLoader = EXTENSIONS_LOADER.getClassLoaderForExtension(extension, false);
            extensionURLs.addAll(Arrays.asList(extensionLoader.getURLs()));
        }
        jobURLs.addAll(extensionURLs);
        ArrayList<URL> localClassLoaderURLs = new ArrayList<URL>(jobURLs);
        for (File hadoopDependency : Initialization.getHadoopDependencyFilesToLoad(finalHadoopDependencyCoordinates, EXTENSIONS_LOADER.config())) {
            StandardURLClassLoader hadoopLoader = EXTENSIONS_LOADER.getClassLoaderForExtension(hadoopDependency, false);
            localClassLoaderURLs.addAll(Arrays.asList(hadoopLoader.getURLs()));
        }
        ClassLoader parent = ClassLoader.getPlatformClassLoader();
        URLClassLoader classLoader = new URLClassLoader(localClassLoaderURLs.toArray(new URL[0]), parent);
        ExtensionsConfig extnConfig = EXTENSIONS_LOADER.config();
        if (extnConfig.getHadoopContainerDruidClasspath() == null) {
            hadoopContainerDruidClasspathJars = Joiner.on((String)File.pathSeparator).join((Iterable)jobURLs);
        } else {
            ArrayList hadoopContainerURLs = Lists.newArrayList((Iterable)ExtensionsLoader.getURLsForClasspath((String)extnConfig.getHadoopContainerDruidClasspath()));
            if (extnConfig.getAddExtensionsToHadoopContainer()) {
                hadoopContainerURLs.addAll(extensionURLs);
            }
            hadoopContainerDruidClasspathJars = Joiner.on((String)File.pathSeparator).join((Iterable)hadoopContainerURLs);
        }
        log.info("Hadoop Container Druid Classpath is set to [%s]", new Object[]{hadoopContainerDruidClasspathJars});
        System.setProperty("druid.hadoop.internal.classpath", hadoopContainerDruidClasspathJars);
        return classLoader;
    }

    protected static void logExtensionsConfig() {
        log.info("HadoopTask started with the following config:\n%s", new Object[]{EXTENSIONS_LOADER.config().toString()});
    }

    public static <InputType, OutputType> OutputType invokeForeignLoader(String clazzName, InputType input, ClassLoader loader) {
        log.debug("Launching [%s] on class loader [%s] with input class [%s]", new Object[]{clazzName, loader, input.getClass()});
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(loader);
            Class<?> clazz = loader.loadClass(clazzName);
            Method method = clazz.getMethod("runTask", input.getClass());
            Object object = method.invoke(null, input);
            return (OutputType)object;
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }

    public static Object getForeignClassloaderObject(String clazzName, ClassLoader loader) {
        log.debug("Launching [%s] on class loader [%s]", new Object[]{clazzName, loader});
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(loader);
            Class<?> clazz = loader.loadClass(clazzName);
            Object obj = clazz.newInstance();
            return obj;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }
}

