/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.pool2.TrackedUse;

public class AbandonedTrace
implements TrackedUse {
    private final List<WeakReference<AbandonedTrace>> traceList = new ArrayList<WeakReference<AbandonedTrace>>();
    private volatile long lastUsed = 0L;

    public AbandonedTrace() {
        this.init(null);
    }

    public AbandonedTrace(AbandonedTrace parent) {
        this.init(parent);
    }

    private void init(AbandonedTrace parent) {
        if (parent != null) {
            parent.addTrace(this);
        }
    }

    public long getLastUsed() {
        return this.lastUsed;
    }

    protected void setLastUsed() {
        this.lastUsed = System.currentTimeMillis();
    }

    protected void setLastUsed(long time) {
        this.lastUsed = time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addTrace(AbandonedTrace trace) {
        List<WeakReference<AbandonedTrace>> list = this.traceList;
        synchronized (list) {
            this.traceList.add(new WeakReference<AbandonedTrace>(trace));
        }
        this.setLastUsed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearTrace() {
        List<WeakReference<AbandonedTrace>> list = this.traceList;
        synchronized (list) {
            this.traceList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<AbandonedTrace> getTrace() {
        int size = this.traceList.size();
        if (size == 0) {
            return Collections.emptyList();
        }
        ArrayList<AbandonedTrace> result = new ArrayList<AbandonedTrace>(size);
        List<WeakReference<AbandonedTrace>> list = this.traceList;
        synchronized (list) {
            Iterator<WeakReference<AbandonedTrace>> iter = this.traceList.iterator();
            while (iter.hasNext()) {
                WeakReference<AbandonedTrace> ref = iter.next();
                if (ref.get() == null) {
                    iter.remove();
                    continue;
                }
                result.add((AbandonedTrace)ref.get());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeTrace(AbandonedTrace trace) {
        List<WeakReference<AbandonedTrace>> list = this.traceList;
        synchronized (list) {
            Iterator<WeakReference<AbandonedTrace>> iter = this.traceList.iterator();
            while (iter.hasNext()) {
                WeakReference<AbandonedTrace> ref = iter.next();
                if (trace.equals(ref.get())) {
                    iter.remove();
                    break;
                }
                if (ref.get() != null) continue;
                iter.remove();
            }
        }
    }
}

