/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.jackson;

import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import io.swagger.models.Xml;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import org.apache.commons.lang3.StringUtils;

class JAXBAnnotationsHelper {
    private static final String JAXB_DEFAULT = "##default";

    private JAXBAnnotationsHelper() {
    }

    public static void apply(AnnotatedMember member, Property property) {
        if (member.hasAnnotation(XmlElementWrapper.class) || member.hasAnnotation(XmlElement.class)) {
            JAXBAnnotationsHelper.applyElement(member, property);
        } else if (member.hasAnnotation(XmlAttribute.class) && JAXBAnnotationsHelper.isAttributeAllowed(property)) {
            JAXBAnnotationsHelper.applyAttribute(member, property);
        }
    }

    private static void applyElement(AnnotatedMember member, Property property) {
        XmlElementWrapper wrapper = (XmlElementWrapper)member.getAnnotation(XmlElementWrapper.class);
        if (wrapper != null) {
            Xml xml = JAXBAnnotationsHelper.getXml(property);
            xml.setWrapped(true);
            if (!(JAXB_DEFAULT.equals(wrapper.name()) || wrapper.name().isEmpty() || wrapper.name().equals(property.getName()))) {
                xml.setName(wrapper.name());
            }
        } else {
            XmlElement element = (XmlElement)member.getAnnotation(XmlElement.class);
            if (element != null) {
                JAXBAnnotationsHelper.setName(element.namespace(), element.name(), property);
            }
        }
    }

    private static void applyAttribute(AnnotatedMember member, Property property) {
        XmlAttribute attribute = (XmlAttribute)member.getAnnotation(XmlAttribute.class);
        if (attribute != null) {
            Xml xml = JAXBAnnotationsHelper.getXml(property);
            xml.setAttribute(true);
            JAXBAnnotationsHelper.setName(attribute.namespace(), attribute.name(), property);
        }
    }

    private static Xml getXml(Property property) {
        Xml existing = property.getXml();
        if (existing != null) {
            return existing;
        }
        Xml created = new Xml();
        property.setXml(created);
        return created;
    }

    private static boolean setName(String ns, String name, Property property) {
        String useNS;
        String useName;
        boolean apply = false;
        String cleanName = StringUtils.trimToNull(name);
        if (!JAXBAnnotationsHelper.isEmpty(cleanName) && !cleanName.equals(property.getName())) {
            useName = cleanName;
            apply = true;
        } else {
            useName = null;
        }
        String cleanNS = StringUtils.trimToNull(ns);
        if (!JAXBAnnotationsHelper.isEmpty(cleanNS)) {
            useNS = cleanNS;
            apply = true;
        } else {
            useNS = null;
        }
        if (apply) {
            JAXBAnnotationsHelper.getXml(property).name(useName).namespace(useNS);
        }
        return apply;
    }

    private static boolean isAttributeAllowed(Property property) {
        for (Class item : new Class[]{ArrayProperty.class, MapProperty.class, ObjectProperty.class, RefProperty.class}) {
            if (!item.isInstance(property)) continue;
            return false;
        }
        return true;
    }

    private static boolean isEmpty(String name) {
        return StringUtils.isEmpty(name) || JAXB_DEFAULT.equals(name);
    }
}

