/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.querykit.groupby;

import com.google.common.collect.Iterables;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.function.Function;
import org.apache.druid.collections.NonBlockingPool;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.channel.FrameWithPartition;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.frame.channel.WritableFrameChannel;
import org.apache.druid.frame.processor.FrameRowTooLargeException;
import org.apache.druid.frame.processor.ReturnOrAwait;
import org.apache.druid.frame.read.FrameReader;
import org.apache.druid.frame.segment.FrameSegment;
import org.apache.druid.frame.write.FrameWriter;
import org.apache.druid.frame.write.FrameWriterFactory;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.Unit;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.guava.Yielder;
import org.apache.druid.java.util.common.guava.Yielders;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.msq.exec.DataServerQueryHandler;
import org.apache.druid.msq.exec.DataServerQueryResult;
import org.apache.druid.msq.input.ReadableInput;
import org.apache.druid.msq.input.table.SegmentWithDescriptor;
import org.apache.druid.msq.input.table.SegmentsInputSlice;
import org.apache.druid.msq.querykit.BaseLeafFrameProcessor;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.GroupingEngine;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.groupby.epinephelinae.RowBasedGrouperHelper;
import org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.query.spec.SpecificSegmentSpec;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.CompleteSegment;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.SegmentReference;
import org.apache.druid.segment.TimeBoundaryInspector;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.timeline.SegmentId;

public class GroupByPreShuffleFrameProcessor
extends BaseLeafFrameProcessor {
    private static final Logger log = new Logger(GroupByPreShuffleFrameProcessor.class);
    private final GroupByQuery query;
    private final GroupingEngine groupingEngine;
    private final NonBlockingPool<ByteBuffer> bufferPool;
    private final ColumnSelectorFactory frameWriterColumnSelectorFactory;
    private final Closer closer = Closer.create();
    private Yielder<ResultRow> resultYielder;
    private FrameWriter frameWriter;
    private long currentAllocatorCapacity;
    private SegmentsInputSlice handedOffSegments = null;
    private Yielder<Yielder<ResultRow>> currentResultsYielder;

    public GroupByPreShuffleFrameProcessor(GroupByQuery query, GroupingEngine groupingEngine, NonBlockingPool<ByteBuffer> bufferPool, ReadableInput baseInput, Function<SegmentReference, SegmentReference> segmentMapFn, ResourceHolder<WritableFrameChannel> outputChannelHolder, ResourceHolder<FrameWriterFactory> frameWriterFactoryHolder) {
        super(baseInput, segmentMapFn, outputChannelHolder, frameWriterFactoryHolder);
        this.query = query;
        this.groupingEngine = groupingEngine;
        this.bufferPool = bufferPool;
        this.frameWriterColumnSelectorFactory = RowBasedGrouperHelper.createResultRowBasedColumnSelectorFactory((GroupByQuery)query, () -> (ResultRow)this.resultYielder.get(), (RowSignature.Finalization)RowSignature.Finalization.NO);
    }

    @Override
    protected ReturnOrAwait<SegmentsInputSlice> runWithDataServerQuery(DataServerQueryHandler dataServerQueryHandler) throws IOException {
        if (this.resultYielder == null || this.resultYielder.isDone()) {
            if (this.currentResultsYielder == null) {
                DataServerQueryResult dataServerQueryResult = dataServerQueryHandler.fetchRowsFromDataServer(this.groupingEngine.prepareGroupByQuery(this.query), Function.identity(), this.closer);
                this.handedOffSegments = dataServerQueryResult.getHandedOffSegments();
                if (!this.handedOffSegments.getDescriptors().isEmpty()) {
                    log.info("Query to dataserver for segments found [%d] handed off segments", new Object[]{this.handedOffSegments.getDescriptors().size()});
                }
                List yielders = dataServerQueryResult.getResultsYielders();
                this.currentResultsYielder = Yielders.each((Sequence)Sequences.simple(yielders));
            }
            if (this.currentResultsYielder.isDone()) {
                return ReturnOrAwait.returnObject((Object)this.handedOffSegments);
            }
            this.resultYielder = (Yielder)this.currentResultsYielder.get();
            this.currentResultsYielder = this.currentResultsYielder.next(null);
        }
        this.populateFrameWriterAndFlushIfNeeded();
        if ((this.resultYielder == null || this.resultYielder.isDone()) && this.currentResultsYielder.isDone()) {
            return ReturnOrAwait.returnObject((Object)this.handedOffSegments);
        }
        return ReturnOrAwait.runAgain();
    }

    @Override
    protected ReturnOrAwait<Unit> runWithSegment(SegmentWithDescriptor segment) throws IOException {
        if (this.resultYielder == null) {
            ResourceHolder segmentHolder = (ResourceHolder)this.closer.register(segment.getOrLoad());
            SegmentReference mappedSegment = this.mapSegment(((CompleteSegment)segmentHolder.get()).getSegment());
            Sequence rowSequence = this.groupingEngine.process(this.query.withQuerySegmentSpec((QuerySegmentSpec)new SpecificSegmentSpec((SegmentDescriptor)segment.getDescriptor())), mappedSegment.asCursorFactory(), (TimeBoundaryInspector)mappedSegment.as(TimeBoundaryInspector.class), this.bufferPool, null);
            this.resultYielder = Yielders.each((Sequence)rowSequence);
        }
        this.populateFrameWriterAndFlushIfNeeded();
        if (this.resultYielder == null || this.resultYielder.isDone()) {
            return ReturnOrAwait.returnObject((Object)Unit.instance());
        }
        return ReturnOrAwait.runAgain();
    }

    @Override
    protected ReturnOrAwait<Unit> runWithInputChannel(ReadableFrameChannel inputChannel, FrameReader inputFrameReader) throws IOException {
        if (this.resultYielder == null || this.resultYielder.isDone()) {
            this.closeAndDiscardResultYielder();
            if (inputChannel.canRead()) {
                Frame frame = inputChannel.read();
                FrameSegment frameSegment = new FrameSegment(frame, inputFrameReader, SegmentId.dummy((String)"x"));
                SegmentReference mappedSegment = this.mapSegment((Segment)frameSegment);
                Sequence rowSequence = this.groupingEngine.process(this.query.withQuerySegmentSpec((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)Intervals.ONLY_ETERNITY)), mappedSegment.asCursorFactory(), (TimeBoundaryInspector)mappedSegment.as(TimeBoundaryInspector.class), this.bufferPool, null);
                this.resultYielder = Yielders.each((Sequence)rowSequence);
            } else {
                if (inputChannel.isFinished()) {
                    this.flushFrameWriterIfNeeded();
                    return ReturnOrAwait.returnObject((Object)Unit.instance());
                }
                return ReturnOrAwait.awaitAll((int)this.inputChannels().size());
            }
        }
        this.populateFrameWriterAndFlushIfNeeded();
        if (this.resultYielder == null || this.resultYielder.isDone()) {
            this.closeAndDiscardResultYielder();
            return ReturnOrAwait.awaitAll((int)this.inputChannels().size());
        }
        return ReturnOrAwait.runAgain();
    }

    @Override
    public void cleanup() throws IOException {
        this.closer.register(this::closeAndDiscardResultYielder);
        this.closer.register((Closeable)this.frameWriter);
        this.closer.register(() -> super.cleanup());
        this.closer.close();
    }

    private void populateFrameWriterAndFlushIfNeeded() throws IOException {
        this.createFrameWriterIfNeeded();
        while (!this.resultYielder.isDone()) {
            boolean didAddToFrame = this.frameWriter.addSelection();
            if (didAddToFrame) {
                this.resultYielder = this.resultYielder.next(null);
                continue;
            }
            if (this.frameWriter.getNumRows() == 0) {
                throw new FrameRowTooLargeException(this.currentAllocatorCapacity);
            }
            this.flushFrameWriterIfNeeded();
            return;
        }
        this.flushFrameWriterIfNeeded();
        this.closeAndDiscardResultYielder();
    }

    private void createFrameWriterIfNeeded() {
        if (this.frameWriter == null) {
            FrameWriterFactory frameWriterFactory = this.getFrameWriterFactory();
            this.frameWriter = frameWriterFactory.newFrameWriter(this.frameWriterColumnSelectorFactory);
            this.currentAllocatorCapacity = frameWriterFactory.allocatorCapacity();
        }
    }

    private void flushFrameWriterIfNeeded() throws IOException {
        if (this.frameWriter != null && this.frameWriter.getNumRows() > 0) {
            Frame frame = Frame.wrap((byte[])this.frameWriter.toByteArray());
            ((WritableFrameChannel)Iterables.getOnlyElement(this.outputChannels())).write(new FrameWithPartition(frame, -1));
            this.frameWriter.close();
            this.frameWriter = null;
        }
    }

    private void closeAndDiscardResultYielder() throws IOException {
        Yielder<ResultRow> tmp = this.resultYielder;
        this.resultYielder = null;
        if (tmp != null) {
            tmp.close();
        }
    }
}

