/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.querykit;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.druid.frame.key.ClusterBy;
import org.apache.druid.frame.key.KeyColumn;
import org.apache.druid.frame.key.KeyOrder;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.msq.input.stage.StageInputSpec;
import org.apache.druid.msq.kernel.HashShuffleSpec;
import org.apache.druid.msq.kernel.MixShuffleSpec;
import org.apache.druid.msq.kernel.QueryDefinition;
import org.apache.druid.msq.kernel.QueryDefinitionBuilder;
import org.apache.druid.msq.kernel.ShuffleSpec;
import org.apache.druid.msq.kernel.StageDefinition;
import org.apache.druid.msq.kernel.StageDefinitionBuilder;
import org.apache.druid.msq.querykit.DataSourcePlan;
import org.apache.druid.msq.querykit.QueryKit;
import org.apache.druid.msq.querykit.QueryKitSpec;
import org.apache.druid.msq.querykit.QueryKitUtils;
import org.apache.druid.msq.querykit.ShuffleSpecFactory;
import org.apache.druid.msq.querykit.WindowOperatorQueryFrameProcessorFactory;
import org.apache.druid.msq.util.MultiStageQueryContext;
import org.apache.druid.query.operator.AbstractPartitioningOperatorFactory;
import org.apache.druid.query.operator.AbstractSortOperatorFactory;
import org.apache.druid.query.operator.ColumnWithDirection;
import org.apache.druid.query.operator.GlueingPartitioningOperatorFactory;
import org.apache.druid.query.operator.OperatorFactory;
import org.apache.druid.query.operator.PartitionSortOperatorFactory;
import org.apache.druid.query.operator.WindowOperatorQuery;
import org.apache.druid.query.operator.window.WindowOperatorFactory;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;

public class WindowOperatorQueryKit
implements QueryKit<WindowOperatorQuery> {
    private static final Logger log = new Logger(WindowOperatorQueryKit.class);
    private final ObjectMapper jsonMapper;
    private final boolean isOperatorTransformationEnabled;

    public WindowOperatorQueryKit(ObjectMapper jsonMapper, boolean isOperatorTransformationEnabled) {
        this.jsonMapper = jsonMapper;
        this.isOperatorTransformationEnabled = isOperatorTransformationEnabled;
    }

    @Override
    public QueryDefinition makeQueryDefinition(QueryKitSpec queryKitSpec, WindowOperatorQuery originalQuery, ShuffleSpecFactory resultShuffleSpecFactory, int minStageNumber) {
        DataSourcePlan dataSourcePlan = DataSourcePlan.forDataSource(queryKitSpec, originalQuery.context(), originalQuery.getDataSource(), originalQuery.getQuerySegmentSpec(), originalQuery.getFilter(), null, minStageNumber, false);
        RowSignature signatureFromInput = dataSourcePlan.getSubQueryDefBuilder().get().build().getFinalStageDefinition().getSignature();
        WindowStages windowStages = new WindowStages(originalQuery, this.jsonMapper, queryKitSpec.getNumPartitionsForShuffle(), queryKitSpec.getMaxNonLeafWorkerCount(), resultShuffleSpecFactory, signatureFromInput, this.isOperatorTransformationEnabled);
        ShuffleSpec nextShuffleSpec = windowStages.getStages().get(0).findShuffleSpec(queryKitSpec.getNumPartitionsForShuffle());
        QueryDefinitionBuilder queryDefBuilder = this.makeQueryDefinitionBuilder(queryKitSpec.getQueryId(), dataSourcePlan, nextShuffleSpec);
        int firstWindowStageNumber = Math.max(minStageNumber, queryDefBuilder.getNextStageNumber());
        log.info("Row signature received from last stage is [%s].", new Object[]{signatureFromInput});
        for (int i = 0; i < windowStages.getStages().size(); ++i) {
            queryDefBuilder.add(windowStages.getStageDefinitionBuilder(firstWindowStageNumber + i, i));
        }
        return queryDefBuilder.build();
    }

    private QueryDefinitionBuilder makeQueryDefinitionBuilder(String queryId, DataSourcePlan dataSourcePlan, ShuffleSpec shuffleSpec) {
        QueryDefinitionBuilder queryDefBuilder = QueryDefinition.builder(queryId);
        int previousStageNumber = dataSourcePlan.getSubQueryDefBuilder().get().build().getFinalStageDefinition().getStageNumber();
        for (StageDefinition stageDef : dataSourcePlan.getSubQueryDefBuilder().get().build().getStageDefinitions()) {
            if (stageDef.getStageNumber() == previousStageNumber) {
                RowSignature rowSignature = QueryKitUtils.sortableSignature(stageDef.getSignature(), shuffleSpec.clusterBy().getColumns());
                queryDefBuilder.add(StageDefinition.builder(stageDef).shuffleSpec(shuffleSpec).signature(rowSignature));
                continue;
            }
            queryDefBuilder.add(StageDefinition.builder(stageDef));
        }
        return queryDefBuilder;
    }

    private static class WindowStage {
        private AbstractSortOperatorFactory sortOperatorFactory;
        private AbstractPartitioningOperatorFactory partitioningOperatorFactory;
        private final List<WindowOperatorFactory> windowOperatorFactories = new ArrayList<WindowOperatorFactory>();
        private final int maxRowsMaterialized;

        private WindowStage(int maxRowsMaterialized) {
            this.maxRowsMaterialized = maxRowsMaterialized;
        }

        private void addOperatorFactory(OperatorFactory op) {
            if (op instanceof AbstractSortOperatorFactory) {
                this.sortOperatorFactory = (AbstractSortOperatorFactory)op;
            } else if (op instanceof AbstractPartitioningOperatorFactory) {
                this.partitioningOperatorFactory = (AbstractPartitioningOperatorFactory)op;
            } else {
                this.windowOperatorFactories.add((WindowOperatorFactory)op);
            }
        }

        private List<OperatorFactory> getOperatorFactories() {
            ArrayList<OperatorFactory> operatorFactories = new ArrayList<OperatorFactory>();
            if (this.sortOperatorFactory != null) {
                operatorFactories.add((OperatorFactory)this.sortOperatorFactory);
            }
            if (this.partitioningOperatorFactory != null) {
                operatorFactories.add((OperatorFactory)this.partitioningOperatorFactory);
            }
            operatorFactories.addAll(this.windowOperatorFactories);
            return operatorFactories;
        }

        private List<OperatorFactory> getTransformedOperatorFactories() {
            ArrayList<OperatorFactory> operatorFactories = new ArrayList<OperatorFactory>();
            if (this.partitioningOperatorFactory != null) {
                operatorFactories.add((OperatorFactory)new GlueingPartitioningOperatorFactory(this.partitioningOperatorFactory.getPartitionColumns(), Integer.valueOf(this.maxRowsMaterialized)));
            }
            if (this.sortOperatorFactory != null) {
                operatorFactories.add((OperatorFactory)new PartitionSortOperatorFactory(this.sortOperatorFactory.getSortColumns()));
            }
            operatorFactories.addAll(this.windowOperatorFactories);
            return operatorFactories;
        }

        private List<WindowOperatorFactory> getWindowOperatorFactories() {
            return this.windowOperatorFactories;
        }

        private ShuffleSpec findShuffleSpec(int partitionCount) {
            HashMap<String, ColumnWithDirection.Direction> sortColumnsMap = new HashMap<String, ColumnWithDirection.Direction>();
            if (this.sortOperatorFactory != null) {
                for (ColumnWithDirection sortColumn : this.sortOperatorFactory.getSortColumns()) {
                    sortColumnsMap.put(sortColumn.getColumn(), sortColumn.getDirection());
                }
            }
            if (this.partitioningOperatorFactory == null) {
                return null;
            }
            if (this.partitioningOperatorFactory.getPartitionColumns().isEmpty()) {
                return MixShuffleSpec.instance();
            }
            ArrayList<KeyColumn> keyColsOfWindow = new ArrayList<KeyColumn>();
            Iterator iterator = this.partitioningOperatorFactory.getPartitionColumns().iterator();
            while (iterator.hasNext()) {
                String partitionColumn;
                KeyColumn kc = new KeyColumn(partitionColumn, sortColumnsMap.get(partitionColumn = (String)iterator.next()) == ColumnWithDirection.Direction.DESC ? KeyOrder.DESCENDING : KeyOrder.ASCENDING);
                keyColsOfWindow.add(kc);
            }
            return new HashShuffleSpec(new ClusterBy(keyColsOfWindow, 0), partitionCount);
        }

        private boolean canAccept(OperatorFactory operatorFactory) {
            if (this.getOperatorFactories().isEmpty()) {
                return true;
            }
            if (operatorFactory instanceof AbstractSortOperatorFactory) {
                return false;
            }
            if (operatorFactory instanceof WindowOperatorFactory) {
                return true;
            }
            if (operatorFactory instanceof AbstractPartitioningOperatorFactory) {
                return this.sortOperatorFactory != null;
            }
            throw new ISE("Encountered unexpected operatorFactory type: [%s]", new Object[]{operatorFactory.getClass().getName()});
        }

        private List<String> getPartitionColumns() {
            return this.partitioningOperatorFactory == null ? new ArrayList() : this.partitioningOperatorFactory.getPartitionColumns();
        }

        public String toString() {
            return "WindowStage{sortOperatorFactory=" + this.sortOperatorFactory + ", partitioningOperatorFactory=" + this.partitioningOperatorFactory + ", windowOperatorFactories=" + this.windowOperatorFactories + "}";
        }
    }

    private static class WindowStages {
        private final List<WindowStage> stages = new ArrayList<WindowStage>();
        private final WindowOperatorQuery query;
        private final int numPartitionsForShuffle;
        private final int maxNonLeafWorkerCount;
        private final ShuffleSpec finalWindowStageShuffleSpec;
        private final RowSignature finalWindowStageRowSignature;
        private final RowSignature.Builder rowSignatureBuilder;
        private final boolean isOperatorTransformationEnabled;

        private WindowStages(WindowOperatorQuery query, ObjectMapper jsonMapper, int numPartitionsForShuffle, int maxNonLeafWorkerCount, ShuffleSpecFactory resultShuffleSpecFactory, RowSignature signatureFromInput, boolean isOperatorTransformationEnabled) {
            this.query = query;
            this.numPartitionsForShuffle = numPartitionsForShuffle;
            this.maxNonLeafWorkerCount = maxNonLeafWorkerCount;
            this.isOperatorTransformationEnabled = isOperatorTransformationEnabled;
            Granularity segmentGranularity = QueryKitUtils.getSegmentGranularityFromContext(jsonMapper, query.getContext());
            ClusterBy finalWindowClusterBy = this.computeClusterByForFinalWindowStage(segmentGranularity);
            this.finalWindowStageShuffleSpec = this.computeShuffleSpecForFinalWindowStage(resultShuffleSpecFactory, finalWindowClusterBy);
            this.finalWindowStageRowSignature = this.computeSignatureForFinalWindowStage(query.getRowSignature(), finalWindowClusterBy, segmentGranularity);
            this.rowSignatureBuilder = RowSignature.builder().addAll(signatureFromInput);
            this.populateStages();
        }

        private void populateStages() {
            WindowStage currentStage = new WindowStage(this.getMaxRowsMaterialized());
            for (OperatorFactory of : this.query.getOperators()) {
                if (!currentStage.canAccept(of)) {
                    this.stages.add(currentStage);
                    currentStage = new WindowStage(this.getMaxRowsMaterialized());
                }
                currentStage.addOperatorFactory(of);
            }
            if (!currentStage.getOperatorFactories().isEmpty()) {
                this.stages.add(currentStage);
            }
            log.info("Created window stages: [%s]", new Object[]{this.stages});
        }

        private List<WindowStage> getStages() {
            return this.stages;
        }

        private RowSignature getRowSignatureForStage(int windowStageIndex, ShuffleSpec shuffleSpec) {
            if (windowStageIndex == this.stages.size() - 1) {
                return this.finalWindowStageRowSignature;
            }
            WindowStage stage = this.stages.get(windowStageIndex);
            for (WindowOperatorFactory operatorFactory : stage.getWindowOperatorFactories()) {
                for (String columnName : operatorFactory.getProcessor().getOutputColumnNames()) {
                    int indexInRowSignature = this.query.getRowSignature().indexOf(columnName);
                    if (indexInRowSignature == -1 || this.rowSignatureBuilder.build().indexOf(columnName) != -1) continue;
                    ColumnType columnType = (ColumnType)this.query.getRowSignature().getColumnType(indexInRowSignature).get();
                    this.rowSignatureBuilder.add(columnName, columnType);
                }
            }
            RowSignature intermediateSignature = this.rowSignatureBuilder.build();
            RowSignature stageRowSignature = shuffleSpec == null ? intermediateSignature : QueryKitUtils.sortableSignature(intermediateSignature, shuffleSpec.clusterBy().getColumns());
            log.info("Using row signature [%s] for window stage.", new Object[]{stageRowSignature});
            return stageRowSignature;
        }

        private StageDefinitionBuilder getStageDefinitionBuilder(int stageNumber, int windowStageIndex) {
            WindowStage stage = this.stages.get(windowStageIndex);
            ShuffleSpec shuffleSpec = windowStageIndex == this.stages.size() - 1 ? this.finalWindowStageShuffleSpec : this.stages.get(windowStageIndex + 1).findShuffleSpec(this.numPartitionsForShuffle);
            RowSignature stageRowSignature = this.getRowSignatureForStage(windowStageIndex, shuffleSpec);
            List<OperatorFactory> operatorFactories = this.isOperatorTransformationEnabled ? stage.getTransformedOperatorFactories() : stage.getOperatorFactories();
            return StageDefinition.builder(stageNumber).inputs(new StageInputSpec(stageNumber - 1)).signature(stageRowSignature).maxWorkerCount(this.maxNonLeafWorkerCount).shuffleSpec(shuffleSpec).processorFactory(new WindowOperatorQueryFrameProcessorFactory(this.query, operatorFactories, stageRowSignature, this.getMaxRowsMaterialized(), stage.getPartitionColumns()));
        }

        private ClusterBy computeClusterByForFinalWindowStage(Granularity segmentGranularity) {
            List<KeyColumn> clusterByColumns = Collections.singletonList(new KeyColumn("__boost", KeyOrder.ASCENDING));
            return QueryKitUtils.clusterByWithSegmentGranularity(new ClusterBy(clusterByColumns, 0), segmentGranularity);
        }

        private RowSignature computeSignatureForFinalWindowStage(RowSignature rowSignature, ClusterBy finalWindowClusterBy, Granularity segmentGranularity) {
            RowSignature.Builder finalWindowStageRowSignatureBuilder = RowSignature.builder().addAll(rowSignature).add("__boost", ColumnType.LONG);
            return QueryKitUtils.sortableSignature(QueryKitUtils.signatureWithSegmentGranularity(finalWindowStageRowSignatureBuilder.build(), segmentGranularity), finalWindowClusterBy.getColumns());
        }

        private ShuffleSpec computeShuffleSpecForFinalWindowStage(ShuffleSpecFactory resultShuffleSpecFactory, ClusterBy finalWindowClusterBy) {
            return resultShuffleSpecFactory.build(finalWindowClusterBy, false);
        }

        private int getMaxRowsMaterialized() {
            return MultiStageQueryContext.getMaxRowsMaterializedInWindow(this.query.context());
        }
    }
}

