/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.dart.worker;

import com.google.common.annotations.VisibleForTesting;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.discovery.DiscoveryDruidNode;
import org.apache.druid.discovery.DruidNodeDiscovery;
import org.apache.druid.discovery.DruidNodeDiscoveryProvider;
import org.apache.druid.discovery.NodeRole;
import org.apache.druid.error.DruidException;
import org.apache.druid.guice.ManageLifecycle;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.msq.dart.worker.DartWorkerFactory;
import org.apache.druid.msq.dart.worker.WorkerId;
import org.apache.druid.msq.dart.worker.http.DartWorkerInfo;
import org.apache.druid.msq.dart.worker.http.GetWorkersResponse;
import org.apache.druid.msq.exec.Worker;
import org.apache.druid.msq.indexing.error.MSQFaultUtils;
import org.apache.druid.msq.rpc.ResourcePermissionMapper;
import org.apache.druid.msq.rpc.WorkerResource;
import org.apache.druid.query.QueryContext;
import org.apache.druid.server.security.AuthorizerMapper;
import org.joda.time.DateTime;

@ManageLifecycle
public class DartWorkerRunner {
    private static final Logger log = new Logger(DartWorkerRunner.class);
    @GuardedBy(value="this")
    private final Set<String> activeControllerHosts = new HashSet<String>();
    @GuardedBy(value="this")
    private final Map<String, WorkerHolder> workerMap = new HashMap<String, WorkerHolder>();
    private final DartWorkerFactory workerFactory;
    private final ExecutorService workerExec;
    private final DruidNodeDiscoveryProvider discoveryProvider;
    private final ResourcePermissionMapper permissionMapper;
    private final AuthorizerMapper authorizerMapper;
    private final File baseTempDir;

    public DartWorkerRunner(DartWorkerFactory workerFactory, ExecutorService workerExec, DruidNodeDiscoveryProvider discoveryProvider, ResourcePermissionMapper permissionMapper, AuthorizerMapper authorizerMapper, File baseTempDir) {
        this.workerFactory = workerFactory;
        this.workerExec = workerExec;
        this.discoveryProvider = discoveryProvider;
        this.permissionMapper = permissionMapper;
        this.authorizerMapper = authorizerMapper;
        this.baseTempDir = baseTempDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Worker startWorker(String queryId, String controllerHost, QueryContext context) {
        boolean newHolder;
        WorkerHolder holder;
        DartWorkerRunner dartWorkerRunner = this;
        synchronized (dartWorkerRunner) {
            if (!this.activeControllerHosts.contains(controllerHost)) {
                throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.OPERATOR).ofCategory(DruidException.Category.RUNTIME_FAILURE).build("Received startWorker request for unknown controller[%s]", new Object[]{controllerHost});
            }
            WorkerHolder existingHolder = this.workerMap.get(queryId);
            if (existingHolder != null) {
                holder = existingHolder;
                newHolder = false;
            } else {
                Worker worker = this.workerFactory.build(queryId, controllerHost, this.baseTempDir, context);
                WorkerResource resource = new WorkerResource(worker, this.permissionMapper, this.authorizerMapper);
                holder = new WorkerHolder(worker, controllerHost, resource, DateTimes.nowUtc());
                this.workerMap.put(queryId, holder);
                this.notifyAll();
                newHolder = true;
            }
        }
        if (newHolder) {
            this.workerExec.submit(() -> {
                String originalThreadName = Thread.currentThread().getName();
                try {
                    Thread.currentThread().setName(StringUtils.format((String)"%s[%s]", (Object[])new Object[]{originalThreadName, queryId}));
                    holder.worker.run();
                }
                catch (Throwable t) {
                    if (Thread.interrupted() || MSQFaultUtils.isCanceledException(t)) {
                        log.debug(t, "Canceled, exiting thread.", new Object[0]);
                    } else {
                        log.warn(t, "Worker for query[%s] failed and stopped.", new Object[]{queryId});
                    }
                }
                finally {
                    DartWorkerRunner dartWorkerRunner = this;
                    synchronized (dartWorkerRunner) {
                        this.workerMap.remove(queryId, holder);
                        this.notifyAll();
                    }
                    Thread.currentThread().setName(originalThreadName);
                }
            });
        }
        return holder.worker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopWorker(String queryId) {
        WorkerHolder holder;
        DartWorkerRunner dartWorkerRunner = this;
        synchronized (dartWorkerRunner) {
            holder = this.workerMap.get(queryId);
        }
        if (holder != null) {
            holder.worker.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public WorkerResource getWorkerResource(String queryId) {
        DartWorkerRunner dartWorkerRunner = this;
        synchronized (dartWorkerRunner) {
            WorkerHolder holder = this.workerMap.get(queryId);
            if (holder != null) {
                return holder.resource;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GetWorkersResponse getWorkersResponse() {
        ArrayList<DartWorkerInfo> infos = new ArrayList<DartWorkerInfo>();
        DartWorkerRunner dartWorkerRunner = this;
        synchronized (dartWorkerRunner) {
            for (Map.Entry<String, WorkerHolder> entry : this.workerMap.entrySet()) {
                String queryId = entry.getKey();
                WorkerHolder workerHolder = entry.getValue();
                infos.add(new DartWorkerInfo(queryId, WorkerId.fromString(workerHolder.worker.id()), workerHolder.controllerHost, workerHolder.acceptTime));
            }
        }
        return new GetWorkersResponse(infos);
    }

    @LifecycleStart
    public void start() {
        this.createAndCleanTempDirectory();
        DruidNodeDiscovery brokers = this.discoveryProvider.getForNodeRole(NodeRole.BROKER);
        brokers.registerListener((DruidNodeDiscovery.Listener)new BrokerListener());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStop
    public void stop() {
        DartWorkerRunner dartWorkerRunner = this;
        synchronized (dartWorkerRunner) {
            Collection<WorkerHolder> holders = this.workerMap.values();
            for (WorkerHolder holder : holders) {
                holder.worker.stop();
            }
            for (WorkerHolder holder : holders) {
                holder.worker.awaitStop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void awaitQuerySet(Predicate<Set<String>> queryIdsPredicate) throws InterruptedException {
        DartWorkerRunner dartWorkerRunner = this;
        synchronized (dartWorkerRunner) {
            while (!queryIdsPredicate.test(this.workerMap.keySet())) {
                this.wait();
            }
        }
    }

    void createAndCleanTempDirectory() {
        try {
            FileUtils.mkdirp((File)this.baseTempDir);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        File[] files = this.baseTempDir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.isDirectory()) continue;
                try {
                    FileUtils.deleteDirectory((File)file);
                    log.info("Removed stale query directory[%s].", new Object[]{file});
                }
                catch (Exception e) {
                    log.noStackTrace().warn((Throwable)e, "Could not remove stale query directory[%s], skipping.", new Object[]{file});
                }
            }
        }
    }

    private class BrokerListener
    implements DruidNodeDiscovery.Listener {
        private BrokerListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void nodesAdded(Collection<DiscoveryDruidNode> nodes) {
            DartWorkerRunner dartWorkerRunner = DartWorkerRunner.this;
            synchronized (dartWorkerRunner) {
                for (DiscoveryDruidNode node : nodes) {
                    DartWorkerRunner.this.activeControllerHosts.add(node.getDruidNode().getHostAndPortToUse());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void nodesRemoved(Collection<DiscoveryDruidNode> nodes) {
            Set hostsRemoved = nodes.stream().map(node -> node.getDruidNode().getHostAndPortToUse()).collect(Collectors.toSet());
            ArrayList<Worker> workersToNotify = new ArrayList<Worker>();
            DartWorkerRunner dartWorkerRunner = DartWorkerRunner.this;
            synchronized (dartWorkerRunner) {
                DartWorkerRunner.this.activeControllerHosts.removeAll(hostsRemoved);
                for (Map.Entry<String, WorkerHolder> entry : DartWorkerRunner.this.workerMap.entrySet()) {
                    if (!hostsRemoved.contains(entry.getValue().controllerHost)) continue;
                    workersToNotify.add(entry.getValue().worker);
                }
            }
            for (Worker worker : workersToNotify) {
                worker.controllerFailed();
            }
        }
    }

    private static class WorkerHolder {
        private final Worker worker;
        private final WorkerResource resource;
        private final String controllerHost;
        private final DateTime acceptTime;

        public WorkerHolder(Worker worker, String controllerHost, WorkerResource resource, DateTime acceptTime) {
            this.worker = worker;
            this.resource = resource;
            this.controllerHost = controllerHost;
            this.acceptTime = acceptTime;
        }
    }
}

