/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.dart.guice;

import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import java.io.File;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import org.apache.druid.discovery.DruidNodeDiscoveryProvider;
import org.apache.druid.discovery.NodeRole;
import org.apache.druid.guice.Jerseys;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.LifecycleModule;
import org.apache.druid.guice.ManageLifecycle;
import org.apache.druid.guice.ManageLifecycleAnnouncements;
import org.apache.druid.guice.annotations.LoadScope;
import org.apache.druid.guice.annotations.Self;
import org.apache.druid.initialization.DruidModule;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.messages.server.MessageRelayMonitor;
import org.apache.druid.messages.server.Outbox;
import org.apache.druid.messages.server.OutboxImpl;
import org.apache.druid.msq.dart.Dart;
import org.apache.druid.msq.dart.DartResourcePermissionMapper;
import org.apache.druid.msq.dart.controller.messages.ControllerMessage;
import org.apache.druid.msq.dart.guice.DartModules;
import org.apache.druid.msq.dart.guice.DartWorkerConfig;
import org.apache.druid.msq.dart.worker.DartDataSegmentProvider;
import org.apache.druid.msq.dart.worker.DartWorkerFactory;
import org.apache.druid.msq.dart.worker.DartWorkerFactoryImpl;
import org.apache.druid.msq.dart.worker.DartWorkerRunner;
import org.apache.druid.msq.dart.worker.http.DartWorkerResource;
import org.apache.druid.msq.exec.MemoryIntrospector;
import org.apache.druid.msq.querykit.DataSegmentProvider;
import org.apache.druid.msq.rpc.ResourcePermissionMapper;
import org.apache.druid.query.DruidProcessingConfig;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.security.AuthorizerMapper;

@LoadScope(roles={"historical"})
public class DartWorkerModule
implements DruidModule {
    @Inject
    private Properties properties;

    public void configure(Binder binder) {
        if (DartModules.isDartEnabled(this.properties)) {
            binder.install((Module)new ActualModule());
        }
    }

    public static class ActualModule
    implements Module {
        public void configure(Binder binder) {
            JsonConfigProvider.bind((Binder)binder, (String)"druid.msq.dart.worker", DartWorkerConfig.class);
            Jerseys.addResource((Binder)binder, DartWorkerResource.class);
            LifecycleModule.register((Binder)binder, DartWorkerRunner.class);
            LifecycleModule.registerKey((Binder)binder, (Key)Key.get(MessageRelayMonitor.class, Dart.class));
            binder.bind(DartWorkerFactory.class).to(DartWorkerFactoryImpl.class).in(LazySingleton.class);
            binder.bind(DataSegmentProvider.class).annotatedWith(Dart.class).to(DartDataSegmentProvider.class).in(LazySingleton.class);
            binder.bind(ResourcePermissionMapper.class).annotatedWith(Dart.class).to(DartResourcePermissionMapper.class);
        }

        @Provides
        @ManageLifecycle
        public DartWorkerRunner createWorkerRunner(@Self DruidNode selfNode, DartWorkerFactory workerFactory, DruidNodeDiscoveryProvider discoveryProvider, DruidProcessingConfig processingConfig, @Dart ResourcePermissionMapper permissionMapper, MemoryIntrospector memoryIntrospector, AuthorizerMapper authorizerMapper) {
            ExecutorService exec = Execs.multiThreaded((int)memoryIntrospector.numTasksInJvm(), (String)"dart-worker-%s");
            File baseTempDir = new File(processingConfig.getTmpDir(), StringUtils.format((String)"dart_%s", (Object[])new Object[]{selfNode.getPortToUse()}));
            return new DartWorkerRunner(workerFactory, exec, discoveryProvider, permissionMapper, authorizerMapper, baseTempDir);
        }

        @Provides
        @Dart
        public MessageRelayMonitor createMessageRelayMonitor(DruidNodeDiscoveryProvider discoveryProvider, Outbox<ControllerMessage> outbox) {
            return new MessageRelayMonitor(discoveryProvider, outbox, NodeRole.BROKER);
        }

        @Provides
        @ManageLifecycleAnnouncements
        public Outbox<ControllerMessage> createOutbox() {
            return new OutboxImpl();
        }
    }
}

