/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.histogram;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.histogram.ApproximateHistogram;
import org.apache.druid.query.aggregation.histogram.ApproximateHistogramPostAggregator;
import org.apache.druid.query.aggregation.histogram.FixedBucketsHistogram;
import org.apache.druid.query.aggregation.histogram.Quantiles;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.column.ColumnType;

@JsonTypeName(value="quantiles")
public class QuantilesPostAggregator
extends ApproximateHistogramPostAggregator {
    private final float[] probabilities;

    @JsonCreator
    public QuantilesPostAggregator(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName, @JsonProperty(value="probabilities") float[] probabilities) {
        super(name, fieldName);
        this.probabilities = probabilities;
        for (float p : probabilities) {
            if (!(p < 0.0f) && !(p > 1.0f)) continue;
            throw new IAE("Illegal probability[%s], must be strictly between 0 and 1", new Object[]{Float.valueOf(p)});
        }
    }

    @Override
    public Comparator getComparator() {
        throw new UnsupportedOperationException();
    }

    public Set<String> getDependentFields() {
        return Sets.newHashSet((Object[])new String[]{this.fieldName});
    }

    @Override
    public Object compute(Map<String, Object> values) {
        Object val = values.get(this.fieldName);
        if (val instanceof ApproximateHistogram) {
            ApproximateHistogram ah = (ApproximateHistogram)val;
            return new Quantiles(this.probabilities, ah.getQuantiles(this.probabilities), ah.getMin(), ah.getMax());
        }
        if (val instanceof FixedBucketsHistogram) {
            FixedBucketsHistogram fbh = (FixedBucketsHistogram)val;
            double[] adjustedProbabilites = new double[this.probabilities.length];
            for (int i = 0; i < this.probabilities.length; ++i) {
                adjustedProbabilites[i] = (double)this.probabilities[i] * 100.0;
            }
            return new Quantiles(this.probabilities, fbh.percentilesFloat(adjustedProbabilites), (float)fbh.getMin(), (float)fbh.getMax());
        }
        throw new ISE("Unknown value type: " + val.getClass(), new Object[0]);
    }

    public ColumnType getType(ColumnInspector signature) {
        return ColumnType.UNKNOWN_COMPLEX;
    }

    public PostAggregator decorate(Map<String, AggregatorFactory> aggregators) {
        return this;
    }

    @JsonProperty
    public float[] getProbabilities() {
        return this.probabilities;
    }

    @Override
    public String toString() {
        return "QuantilesPostAggregator{name='" + this.name + "', fieldName='" + this.fieldName + "', probabilities=" + Arrays.toString(this.getProbabilities()) + "}";
    }

    public byte[] getCacheKey() {
        return new CacheKeyBuilder(16).appendString(this.fieldName).appendFloatArray(this.probabilities).build();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        QuantilesPostAggregator that = (QuantilesPostAggregator)o;
        return Arrays.equals(this.probabilities, that.probabilities);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.probabilities);
        return result;
    }
}

