/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.druid.common.exception.SanitizableException;
import org.apache.druid.guice.annotations.NativeQuery;
import org.apache.druid.guice.annotations.Self;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.QueryResource;
import org.apache.druid.server.QueryResponse;
import org.apache.druid.server.QueryResultPusher;
import org.apache.druid.server.ResponseContextConfig;
import org.apache.druid.server.initialization.ServerConfig;
import org.apache.druid.server.security.AuthorizationResult;
import org.apache.druid.server.security.AuthorizationUtils;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.sql.DirectStatement;
import org.apache.druid.sql.HttpStatement;
import org.apache.druid.sql.SqlLifecycleManager;
import org.apache.druid.sql.SqlRowTransformer;
import org.apache.druid.sql.SqlStatementFactory;
import org.apache.druid.sql.http.ResultFormat;
import org.apache.druid.sql.http.SqlQuery;

@Path(value="/druid/v2/sql/")
public class SqlResource {
    public static final String SQL_QUERY_ID_RESPONSE_HEADER = "X-Druid-SQL-Query-Id";
    public static final String SQL_HEADER_RESPONSE_HEADER = "X-Druid-SQL-Header-Included";
    public static final String SQL_HEADER_VALUE = "yes";
    private static final Logger log = new Logger(SqlResource.class);
    public static final SqlResourceQueryMetricCounter QUERY_METRIC_COUNTER = new SqlResourceQueryMetricCounter();
    private final ObjectMapper jsonMapper;
    private final AuthorizerMapper authorizerMapper;
    private final SqlStatementFactory sqlStatementFactory;
    private final SqlLifecycleManager sqlLifecycleManager;
    private final ServerConfig serverConfig;
    private final ResponseContextConfig responseContextConfig;
    private final DruidNode selfNode;

    @Inject
    protected SqlResource(ObjectMapper jsonMapper, AuthorizerMapper authorizerMapper, @NativeQuery SqlStatementFactory sqlStatementFactory, SqlLifecycleManager sqlLifecycleManager, ServerConfig serverConfig, ResponseContextConfig responseContextConfig, @Self DruidNode selfNode) {
        this.jsonMapper = (ObjectMapper)Preconditions.checkNotNull((Object)jsonMapper, (Object)"jsonMapper");
        this.authorizerMapper = (AuthorizerMapper)Preconditions.checkNotNull((Object)authorizerMapper, (Object)"authorizerMapper");
        this.sqlStatementFactory = (SqlStatementFactory)Preconditions.checkNotNull((Object)sqlStatementFactory, (Object)"sqlStatementFactory");
        this.sqlLifecycleManager = (SqlLifecycleManager)Preconditions.checkNotNull((Object)sqlLifecycleManager, (Object)"sqlLifecycleManager");
        this.serverConfig = (ServerConfig)Preconditions.checkNotNull((Object)serverConfig, (Object)"serverConfig");
        this.responseContextConfig = responseContextConfig;
        this.selfNode = selfNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Nullable
    public Response doPost(SqlQuery sqlQuery, @Context HttpServletRequest req) {
        HttpStatement stmt = this.sqlStatementFactory.httpStatement(sqlQuery, req);
        String sqlQueryId = stmt.sqlQueryId();
        String currThreadName = Thread.currentThread().getName();
        try {
            Thread.currentThread().setName(StringUtils.format((String)"sql[%s]", (Object[])new Object[]{sqlQueryId}));
            SqlResourceQueryResultPusher pusher = this.makePusher(req, stmt, sqlQuery);
            Response response = pusher.push();
            return response;
        }
        finally {
            Thread.currentThread().setName(currThreadName);
        }
    }

    @DELETE
    @Path(value="{id}")
    @Produces(value={"application/json"})
    public Response cancelQuery(@PathParam(value="id") String sqlQueryId, @Context HttpServletRequest req) {
        log.debug("Received cancel request for query [%s]", new Object[]{sqlQueryId});
        List<SqlLifecycleManager.Cancelable> lifecycles = this.sqlLifecycleManager.getAll(sqlQueryId);
        if (lifecycles.isEmpty()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        AuthorizationResult authResult = this.authorizeCancellation(req, lifecycles);
        if (authResult.allowAccessWithNoRestriction()) {
            this.sqlLifecycleManager.removeAll(sqlQueryId, lifecycles);
            lifecycles.forEach(SqlLifecycleManager.Cancelable::cancel);
            return Response.status((Response.Status)Response.Status.ACCEPTED).build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }

    private SqlResourceQueryResultPusher makePusher(HttpServletRequest req, HttpStatement stmt, SqlQuery sqlQuery) {
        String sqlQueryId = stmt.sqlQueryId();
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        headers.put(SQL_QUERY_ID_RESPONSE_HEADER, sqlQueryId);
        if (sqlQuery.includeHeader()) {
            headers.put(SQL_HEADER_RESPONSE_HEADER, SQL_HEADER_VALUE);
        }
        return new SqlResourceQueryResultPusher(req, sqlQueryId, stmt, sqlQuery, headers);
    }

    public AuthorizationResult authorizeCancellation(HttpServletRequest req, List<SqlLifecycleManager.Cancelable> cancelables) {
        Set resources = cancelables.stream().flatMap(lifecycle -> lifecycle.resources().stream()).collect(Collectors.toSet());
        return AuthorizationUtils.authorizeAllResourceActions((HttpServletRequest)req, resources, (AuthorizerMapper)this.authorizerMapper);
    }

    private class SqlResourceQueryResultPusher
    extends QueryResultPusher {
        private final String sqlQueryId;
        private final HttpStatement stmt;
        private final SqlQuery sqlQuery;

        public SqlResourceQueryResultPusher(HttpServletRequest req, String sqlQueryId, HttpStatement stmt, SqlQuery sqlQuery, Map<String, String> headers) {
            super(req, SqlResource.this.jsonMapper, SqlResource.this.responseContextConfig, SqlResource.this.selfNode, (QueryResource.QueryMetricCounter)QUERY_METRIC_COUNTER, sqlQueryId, MediaType.APPLICATION_JSON_TYPE, headers);
            this.sqlQueryId = sqlQueryId;
            this.stmt = stmt;
            this.sqlQuery = sqlQuery;
        }

        public QueryResultPusher.ResultsWriter start() {
            return new QueryResultPusher.ResultsWriter(){
                private QueryResponse<Object[]> queryResponse;
                private DirectStatement.ResultSet thePlan;

                @Nullable
                public Response.ResponseBuilder start() {
                    this.thePlan = SqlResourceQueryResultPusher.this.stmt.plan();
                    this.queryResponse = this.thePlan.run();
                    return null;
                }

                public QueryResponse<Object> getQueryResponse() {
                    return this.queryResponse;
                }

                public QueryResultPusher.Writer makeWriter(OutputStream out) throws IOException {
                    final ResultFormat.Writer writer = SqlResourceQueryResultPusher.this.sqlQuery.getResultFormat().createFormatter(out, SqlResource.this.jsonMapper);
                    final SqlRowTransformer rowTransformer = this.thePlan.createRowTransformer();
                    return new QueryResultPusher.Writer(){

                        public void writeResponseStart() throws IOException {
                            writer.writeResponseStart();
                            if (SqlResourceQueryResultPusher.this.sqlQuery.includeHeader()) {
                                writer.writeHeader(rowTransformer.getRowType(), SqlResourceQueryResultPusher.this.sqlQuery.includeTypesHeader(), SqlResourceQueryResultPusher.this.sqlQuery.includeSqlTypesHeader());
                            }
                        }

                        public void writeRow(Object obj) throws IOException {
                            Object[] row = (Object[])obj;
                            writer.writeRowStart();
                            for (int i = 0; i < rowTransformer.getFieldList().size(); ++i) {
                                Object value = rowTransformer.transform(row, i);
                                writer.writeRowField(rowTransformer.getFieldList().get(i), value);
                            }
                            writer.writeRowEnd();
                        }

                        public void writeResponseEnd() throws IOException {
                            writer.writeResponseEnd();
                        }

                        public void close() throws IOException {
                            writer.close();
                        }
                    };
                }

                public void recordSuccess(long numBytes) {
                    SqlResourceQueryResultPusher.this.stmt.reporter().succeeded(numBytes);
                }

                public void recordFailure(Exception e) {
                    if (SqlResourceQueryResultPusher.this.sqlQuery.queryContext().isDebug()) {
                        log.warn((Throwable)e, "Exception while processing sqlQueryId[%s]", new Object[]{SqlResourceQueryResultPusher.this.sqlQueryId});
                    } else {
                        log.noStackTrace().warn((Throwable)e, "Exception while processing sqlQueryId[%s]", new Object[]{SqlResourceQueryResultPusher.this.sqlQueryId});
                    }
                    SqlResourceQueryResultPusher.this.stmt.reporter().failed(e);
                }

                public void close() {
                    SqlResourceQueryResultPusher.this.stmt.close();
                }
            };
        }

        public void writeException(Exception ex, OutputStream out) throws IOException {
            if (ex instanceof SanitizableException) {
                ex = SqlResource.this.serverConfig.getErrorResponseTransformStrategy().transformIfNeeded((SanitizableException)ex);
            }
            out.write(SqlResource.this.jsonMapper.writeValueAsBytes((Object)ex));
        }
    }

    private static class SqlResourceQueryMetricCounter
    implements QueryResource.QueryMetricCounter {
        private SqlResourceQueryMetricCounter() {
        }

        public void incrementSuccess() {
        }

        public void incrementFailed() {
        }

        public void incrementInterrupted() {
        }

        public void incrementTimedOut() {
        }
    }
}

