/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.run;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.druid.error.InvalidSqlInput;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.query.JoinAlgorithm;
import org.apache.druid.server.QueryLifecycleFactory;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.run.EngineFeature;
import org.apache.druid.sql.calcite.run.NativeQueryMaker;
import org.apache.druid.sql.calcite.run.QueryMaker;
import org.apache.druid.sql.calcite.run.SqlEngine;
import org.apache.druid.sql.calcite.run.SqlEngines;
import org.apache.druid.sql.destination.IngestDestination;

@LazySingleton
public class NativeSqlEngine
implements SqlEngine {
    public static final Set<String> SYSTEM_CONTEXT_PARAMETERS = ImmutableSet.of((Object)"maxTimeArrayOutputName", (Object)"minTimeArrayOutputName", (Object)"timestampResultField", (Object)"timestampResultFieldGranularity", (Object)"timestampResultFieldInOriginalDimensions", (Object)"scanSignature", (Object[])new String[]{"sqlInsertSegmentGranularity", "sqlReplaceTimeChunks"});
    private static final String NAME = "native";
    private final QueryLifecycleFactory queryLifecycleFactory;
    private final ObjectMapper jsonMapper;

    @Inject
    public NativeSqlEngine(QueryLifecycleFactory queryLifecycleFactory, ObjectMapper jsonMapper) {
        this.queryLifecycleFactory = queryLifecycleFactory;
        this.jsonMapper = jsonMapper;
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public void validateContext(Map<String, Object> queryContext) {
        SqlEngines.validateNoSpecialContextKeys(queryContext, SYSTEM_CONTEXT_PARAMETERS);
        NativeSqlEngine.validateJoinAlgorithm(queryContext);
    }

    @Override
    public RelDataType resultTypeForSelect(RelDataTypeFactory typeFactory, RelDataType validatedRowType, Map<String, Object> queryContext) {
        return validatedRowType;
    }

    @Override
    public RelDataType resultTypeForInsert(RelDataTypeFactory typeFactory, RelDataType validatedRowType, Map<String, Object> queryContext) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean featureAvailable(EngineFeature feature) {
        switch (feature) {
            case CAN_SELECT: 
            case ALLOW_BINDABLE_PLAN: 
            case TIMESERIES_QUERY: 
            case TOPN_QUERY: 
            case GROUPING_SETS: 
            case WINDOW_FUNCTIONS: 
            case UNNEST: 
            case ALLOW_BROADCAST_RIGHTY_JOIN: 
            case ALLOW_TOP_LEVEL_UNION_ALL: 
            case TIME_BOUNDARY_QUERY: 
            case GROUPBY_IMPLICITLY_SORTS: {
                return true;
            }
            case CAN_INSERT: 
            case CAN_REPLACE: 
            case READ_EXTERNAL_DATA: 
            case WRITE_EXTERNAL_DATA: 
            case SCAN_ORDER_BY_NON_TIME: 
            case SCAN_NEEDS_SIGNATURE: 
            case WINDOW_LEAF_OPERATOR: {
                return false;
            }
        }
        throw SqlEngines.generateUnrecognizedFeatureException(NativeSqlEngine.class.getSimpleName(), feature);
    }

    @Override
    public QueryMaker buildQueryMakerForSelect(RelRoot relRoot, PlannerContext plannerContext) {
        return new NativeQueryMaker(this.queryLifecycleFactory, plannerContext, this.jsonMapper, (List<Map.Entry<Integer, String>>)relRoot.fields);
    }

    @Override
    public QueryMaker buildQueryMakerForInsert(IngestDestination destination, RelRoot relRoot, PlannerContext plannerContext) {
        throw new UnsupportedOperationException();
    }

    private static void validateJoinAlgorithm(Map<String, Object> queryContext) {
        JoinAlgorithm joinAlgorithm = PlannerContext.getJoinAlgorithm(queryContext);
        if (joinAlgorithm != JoinAlgorithm.BROADCAST) {
            throw InvalidSqlInput.exception((String)"Join algorithm [%s] is not supported by engine [%s]", (Object[])new Object[]{joinAlgorithm, NAME});
        }
    }
}

