/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.rule.logical;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.rules.SubstitutionRule;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.druid.error.DruidException;
import org.apache.druid.sql.calcite.rule.logical.LogicalUnnest;

public class UnnestInputCleanupRule
extends RelOptRule
implements SubstitutionRule {
    public UnnestInputCleanupRule() {
        super(UnnestInputCleanupRule.operand(LogicalUnnest.class, (RelOptRuleOperand)UnnestInputCleanupRule.operand(Project.class, (RelOptRuleOperandChildren)UnnestInputCleanupRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]));
    }

    public void onMatch(RelOptRuleCall call) {
        LogicalUnnest unnest = (LogicalUnnest)call.rel(0);
        Project project = (Project)call.rel(1);
        ImmutableBitSet input = RelOptUtil.InputFinder.analyze((RexNode)unnest.unnestExpr).build();
        if (input.isEmpty()) {
            throw DruidException.defensive((String)"Found an unbound unnest expression.", (Object[])new Object[0]);
        }
        if (!(unnest.unnestExpr instanceof RexInputRef)) {
            return;
        }
        if (input.cardinality() != 1) {
            return;
        }
        int inputIndex = input.nextSetBit(0);
        ArrayList<RexNode> projects = new ArrayList<RexNode>(project.getProjects());
        RexNode unnestInput = (RexNode)projects.get(inputIndex);
        projects.set(inputIndex, (RexNode)call.builder().getRexBuilder().makeInputRef(project.getInput(), 0));
        RexNode newUnnestExpr = (RexNode)unnestInput.accept((RexVisitor)new ExpressionPullerRexShuttle(projects, inputIndex));
        if (projects.size() != project.getProjects().size()) {
            return;
        }
        RelNode newInputRel = call.builder().push(project.getInput()).project(projects).build();
        LogicalUnnest newUnnest = new LogicalUnnest(unnest.getCluster(), unnest.getTraitSet(), newInputRel, newUnnestExpr, unnest.getRowType(), unnest.filter);
        call.transformTo((RelNode)newUnnest);
        call.getPlanner().prune((RelNode)unnest);
    }

    private static class ExpressionPullerRexShuttle
    extends RexShuttle {
        private final List<RexNode> projects;
        private int replaceableIndex;

        private ExpressionPullerRexShuttle(List<RexNode> projects, int replaceableIndex) {
            this.projects = projects;
            this.replaceableIndex = replaceableIndex;
        }

        public RexNode visitInputRef(RexInputRef inputRef) {
            int newIndex = this.projects.indexOf(inputRef);
            if (newIndex < 0) {
                if (this.replaceableIndex >= 0) {
                    newIndex = this.replaceableIndex;
                    this.projects.set(this.replaceableIndex, (RexNode)inputRef);
                    this.replaceableIndex = -1;
                } else {
                    newIndex = this.projects.size();
                    this.projects.add((RexNode)inputRef);
                }
            }
            if (newIndex == inputRef.getIndex()) {
                return inputRef;
            }
            return new RexInputRef(newIndex, inputRef.getType());
        }
    }
}

