/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.expression.builtin;

import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.TypeDescriptor;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.sql.calcite.planner.Calcites;

class ReductionOperatorConversionHelper {
    static final SqlReturnTypeInference TYPE_INFERENCE = opBinding -> {
        RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
        int n = opBinding.getOperandCount();
        if (n == 0) {
            return typeFactory.createSqlType(SqlTypeName.NULL);
        }
        SqlTypeName returnSqlTypeName = SqlTypeName.NULL;
        boolean hasDouble = false;
        boolean isString = false;
        for (int i = 0; i < n; ++i) {
            RelDataType type = opBinding.getOperandType(i);
            SqlTypeName sqlTypeName = type.getSqlTypeName();
            ColumnType valueType = SqlTypeName.INTERVAL_TYPES.contains(type.getSqlTypeName()) ? ColumnType.LONG : Calcites.getColumnTypeForRelDataType(type);
            if (valueType != null) {
                if (valueType.is((TypeDescriptor)ValueType.STRING)) {
                    returnSqlTypeName = sqlTypeName;
                    isString = true;
                    break;
                }
                if (valueType.anyOf((TypeDescriptor[])new ValueType[]{ValueType.DOUBLE, ValueType.FLOAT})) {
                    returnSqlTypeName = SqlTypeName.DOUBLE;
                    hasDouble = true;
                    continue;
                }
                if (!valueType.is((TypeDescriptor)ValueType.LONG) || hasDouble) continue;
                returnSqlTypeName = SqlTypeName.BIGINT;
                continue;
            }
            if (sqlTypeName == SqlTypeName.NULL) continue;
            throw new IAE("Argument %d has invalid type: %s", new Object[]{i, sqlTypeName});
        }
        return typeFactory.createTypeWithNullability(typeFactory.createSqlType(returnSqlTypeName), true);
    };

    private ReductionOperatorConversionHelper() {
    }
}

