/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.cookie;

import io.netty.handler.codec.http.cookie.Cookie;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.asynchttpclient.cookie.CookieStore;
import org.asynchttpclient.uri.Uri;
import org.asynchttpclient.util.Assertions;
import org.asynchttpclient.util.MiscUtils;

public final class ThreadSafeCookieStore
implements CookieStore {
    private Map<CookieKey, StoredCookie> cookieJar = new ConcurrentHashMap<CookieKey, StoredCookie>();

    @Override
    public void add(Uri uri, Cookie cookie) {
        String thisRequestDomain = this.requestDomain(uri);
        String thisRequestPath = this.requestPath(uri);
        this.add(thisRequestDomain, thisRequestPath, cookie);
    }

    @Override
    public List<Cookie> get(Uri uri) {
        return this.get(this.requestDomain(uri), this.requestPath(uri), uri.isSecured());
    }

    @Override
    public List<Cookie> getAll() {
        boolean[] removeExpired = new boolean[]{false};
        List<Cookie> result = this.cookieJar.entrySet().stream().filter(pair -> {
            boolean hasCookieExpired = this.hasCookieExpired(((StoredCookie)pair.getValue()).cookie, ((StoredCookie)pair.getValue()).createdAt);
            if (hasCookieExpired && !removeExpired[0]) {
                removeExpired[0] = true;
            }
            return !hasCookieExpired;
        }).map(pair -> ((StoredCookie)pair.getValue()).cookie).collect(Collectors.toList());
        if (removeExpired[0]) {
            this.removeExpired();
        }
        return result;
    }

    @Override
    public boolean remove(Predicate<Cookie> predicate) {
        return this.cookieJar.entrySet().removeIf(v -> predicate.test(((StoredCookie)v.getValue()).cookie));
    }

    @Override
    public boolean clear() {
        boolean result = !this.cookieJar.isEmpty();
        this.cookieJar.clear();
        return result;
    }

    private String requestDomain(Uri requestUri) {
        return requestUri.getHost().toLowerCase();
    }

    private String requestPath(Uri requestUri) {
        return requestUri.getPath().isEmpty() ? "/" : requestUri.getPath();
    }

    private AbstractMap.SimpleEntry<String, Boolean> cookieDomain(String cookieDomain, String requestDomain) {
        if (cookieDomain != null) {
            String normalizedCookieDomain = cookieDomain.toLowerCase();
            return new AbstractMap.SimpleEntry<String, Boolean>(!cookieDomain.isEmpty() && cookieDomain.charAt(0) == '.' ? normalizedCookieDomain.substring(1) : normalizedCookieDomain, false);
        }
        return new AbstractMap.SimpleEntry<String, Boolean>(requestDomain, true);
    }

    private String cookiePath(String rawCookiePath, String requestPath) {
        if (MiscUtils.isNonEmpty(rawCookiePath) && rawCookiePath.charAt(0) == '/') {
            return rawCookiePath;
        }
        int indexOfLastSlash = requestPath.lastIndexOf(47);
        if (!requestPath.isEmpty() && requestPath.charAt(0) == '/' && indexOfLastSlash > 0) {
            return requestPath.substring(0, indexOfLastSlash);
        }
        return "/";
    }

    private boolean hasCookieExpired(Cookie cookie, long whenCreated) {
        if (cookie.maxAge() == Long.MIN_VALUE) {
            return false;
        }
        if (cookie.maxAge() <= 0L) {
            return true;
        }
        if (whenCreated > 0L) {
            long deltaSecond = (System.currentTimeMillis() - whenCreated) / 1000L;
            return deltaSecond > cookie.maxAge();
        }
        return false;
    }

    private boolean domainsMatch(String cookieDomain, String requestDomain, boolean hostOnly) {
        return hostOnly && Objects.equals(requestDomain, cookieDomain) || Objects.equals(requestDomain, cookieDomain) || requestDomain.endsWith("." + cookieDomain);
    }

    private boolean pathsMatch(String cookiePath, String requestPath) {
        return Objects.equals(cookiePath, requestPath) || requestPath.startsWith(cookiePath) && (cookiePath.charAt(cookiePath.length() - 1) == '/' || requestPath.charAt(cookiePath.length()) == '/');
    }

    private void add(String requestDomain, String requestPath, Cookie cookie) {
        AbstractMap.SimpleEntry<String, Boolean> pair = this.cookieDomain(cookie.domain(), requestDomain);
        String keyDomain = pair.getKey();
        boolean hostOnly = pair.getValue();
        String keyPath = this.cookiePath(cookie.path(), requestPath);
        CookieKey key = new CookieKey(cookie.name().toLowerCase(), keyDomain, keyPath);
        if (this.hasCookieExpired(cookie, 0L)) {
            this.cookieJar.remove(key);
        } else {
            this.cookieJar.put(key, new StoredCookie(cookie, hostOnly, cookie.maxAge() != Long.MIN_VALUE));
        }
    }

    private List<Cookie> get(String domain, String path, boolean secure) {
        boolean[] removeExpired = new boolean[]{false};
        List<Cookie> result = this.cookieJar.entrySet().stream().filter(pair -> {
            CookieKey key = (CookieKey)pair.getKey();
            StoredCookie storedCookie = (StoredCookie)pair.getValue();
            boolean hasCookieExpired = this.hasCookieExpired(storedCookie.cookie, storedCookie.createdAt);
            if (hasCookieExpired && !removeExpired[0]) {
                removeExpired[0] = true;
            }
            return !hasCookieExpired && this.domainsMatch(key.domain, domain, storedCookie.hostOnly) && this.pathsMatch(key.path, path) && (secure || !storedCookie.cookie.isSecure());
        }).map(v -> ((StoredCookie)v.getValue()).cookie).collect(Collectors.toList());
        if (removeExpired[0]) {
            this.removeExpired();
        }
        return result;
    }

    private void removeExpired() {
        this.cookieJar.entrySet().removeIf(v -> this.hasCookieExpired(((StoredCookie)v.getValue()).cookie, ((StoredCookie)v.getValue()).createdAt));
    }

    private static class StoredCookie {
        final Cookie cookie;
        final boolean hostOnly;
        final boolean persistent;
        final long createdAt = System.currentTimeMillis();

        StoredCookie(Cookie cookie, boolean hostOnly, boolean persistent) {
            this.cookie = cookie;
            this.hostOnly = hostOnly;
            this.persistent = persistent;
        }

        public String toString() {
            return String.format("%s; hostOnly %s; persistent %s", this.cookie.toString(), this.hostOnly, this.persistent);
        }
    }

    private static class CookieKey
    implements Comparable<CookieKey> {
        final String name;
        final String domain;
        final String path;

        CookieKey(String name, String domain, String path) {
            this.name = name;
            this.domain = domain;
            this.path = path;
        }

        @Override
        public int compareTo(CookieKey o) {
            Assertions.assertNotNull(o, "Parameter can't be null");
            int result = this.name.compareTo(o.name);
            if (result == 0 && (result = this.domain.compareTo(o.domain)) == 0) {
                result = this.path.compareTo(o.path);
            }
            return result;
        }

        public boolean equals(Object obj) {
            return obj instanceof CookieKey && this.compareTo((CookieKey)obj) == 0;
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + this.name.hashCode();
            result = 31 * result + this.domain.hashCode();
            result = 31 * result + this.path.hashCode();
            return result;
        }

        public String toString() {
            return String.format("%s: %s; %s", this.name, this.domain, this.path);
        }
    }
}

